/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.genericsystem.api.core.annotations.constraints.InstanceValueGenerator;
import org.genericsystem.defaults.DefaultGeneric;

public class IntSequenceGenerator<T extends DefaultGeneric<T>>
implements InstanceValueGenerator.ValueGenerator<T> {
    public Serializable generateInstanceValue(T meta, List<T> supers, Serializable value, List<T> components) {
        return Integer.valueOf(this.incrementedValue(meta));
    }

    protected int incrementedValue(T meta) {
        Object sequence = meta.getRoot().getSequence();
        DefaultGeneric sequenceHolder = (DefaultGeneric)meta.getHolders(sequence).first();
        int newValue = sequenceHolder != null ? (Integer)sequenceHolder.getValue() + 1 : 0;
        meta.setHolder(sequence, (Serializable)Integer.valueOf(newValue), new DefaultGeneric[0]);
        return newValue;
    }

    public static class StringSequenceGenerator<T extends DefaultGeneric<T>>
    extends IntSequenceGenerator<T> {
        @Override
        public Serializable generateInstanceValue(T meta, List<T> supers, Serializable value, List<T> components) {
            Integer newValue = this.incrementedValue(meta);
            return meta.getValue() instanceof Class ? ((Class)meta.getValue()).getSimpleName() + "-" + newValue : Objects.toString(meta.getValue() + "-" + newValue);
        }
    }
}

