/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.defaults.DefaultGeneric;

public interface DefaultDependencies<T extends DefaultGeneric<T>>
extends IGeneric<T> {
    default public boolean isAlive() {
        return this.getCurrentCache().isAlive((DefaultGeneric)this);
    }

    default public boolean isAncestorOf(T dependency) {
        return this.equals(dependency) || !dependency.isMeta() && this.isAncestorOf((T)((DefaultGeneric)dependency.getMeta())) || dependency.getSupers().stream().anyMatch(this::isAncestorOf) || dependency.getComponents().stream().filter(x -> x != null).anyMatch(this::isAncestorOf);
    }

    default public DefaultContext<T> getCurrentCache() {
        return (DefaultContext)this.getRoot().getCurrentCache();
    }

    default public Snapshot<T> getDependencies() {
        return this.getCurrentCache().getDependencies((DefaultGeneric)this);
    }

    default public T getInstance(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInstances(value, (DefaultGeneric[])components).stream());
    }

    default public T getInstance(T ... components) {
        return this.getNonAmbiguousResult(this.getInstances((DefaultGeneric[])components).stream());
    }

    default public T getInstance(T override, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInstances((DefaultGeneric)override, value, (DefaultGeneric[])components).stream());
    }

    default public T getInstance(List<T> overrides, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInstances(overrides, value, (DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getInstances(Serializable value, T ... components) {
        return this.getInstances((DefaultGeneric[])components).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getInstances() {
        return this.getCurrentCache().getInstances((DefaultGeneric)this);
    }

    default public Snapshot<T> getInstances(T ... components) {
        return this.getInstances().filter(new IndexFilter(FiltersBuilder.HAS_COMPONENTS, (Object[])components));
    }

    default public Snapshot<T> getInstances(T override, Serializable value, T ... components) {
        return this.getInstances(Collections.singletonList(override), value, (DefaultGeneric[])components);
    }

    default public Snapshot<T> getInstances(List<T> overrides, Serializable value, T ... components) {
        List<DefaultGeneric> supers = this.getCurrentCache().computeAndCheckOverridesAreReached((DefaultGeneric)this, overrides, value, Arrays.asList(components));
        return this.getInstances(value, (DefaultGeneric[])components).filter(new IndexFilter(FiltersBuilder.HAS_SUPERS, supers.toArray()));
    }

    default public T getSubInstance(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances(value, (DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getSubInstances(Serializable value, T ... components) {
        return this.getSubInstances((DefaultGeneric[])components).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getSubInheritings() {
        return this.getCurrentCache().getSubInheritings((DefaultGeneric)this);
    }

    default public Snapshot<T> getSubInstances() {
        return this.getCurrentCache().getSubInstances((DefaultGeneric)this);
    }

    default public T getSubInstance(T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances((DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getSubInstances(T ... components) {
        return this.getSubInstances().filter(new IndexFilter(FiltersBuilder.HAS_COMPONENTS, (Object[])components));
    }

    default public T getSubInstance(T override, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances((DefaultGeneric)override, value, (DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getSubInstances(T override, Serializable value, T ... components) {
        return this.getSubInstances(Collections.singletonList(override), value, (DefaultGeneric[])components);
    }

    default public T getSubInstance(List<T> overrides, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances(overrides, value, (DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getSubInstances(List<T> overrides, Serializable value, T ... components) {
        List<DefaultGeneric> supers = this.getCurrentCache().computeAndCheckOverridesAreReached((DefaultGeneric)this, overrides, value, Arrays.asList(components));
        return this.getSubInstances(value, (DefaultGeneric[])components).filter(new IndexFilter(FiltersBuilder.HAS_SUPERS, supers.toArray()));
    }

    default public T getInheriting(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInheritings(value, (DefaultGeneric[])components).stream());
    }

    default public T getInheriting(T ... components) {
        return this.getNonAmbiguousResult(this.getInheritings((DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getInheritings(Serializable value, T ... components) {
        return this.getInheritings((DefaultGeneric[])components).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getInheritings() {
        return this.getCurrentCache().getInheritings((DefaultGeneric)this);
    }

    default public Snapshot<T> getInheritings(T ... components) {
        return this.getInheritings().filter(new IndexFilter(FiltersBuilder.HAS_COMPONENTS, (Object[])components));
    }

    default public T getSubInheriting(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInheritings(value, (DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getSubInheritings(Serializable value, T ... components) {
        return this.getSubInheritings((DefaultGeneric[])components).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public T getSubInheriting(T ... components) {
        return this.getNonAmbiguousResult(this.getSubInheritings((DefaultGeneric[])components).stream());
    }

    default public Snapshot<T> getSubInheritings(T ... components) {
        return this.getSubInheritings().filter(new IndexFilter(FiltersBuilder.HAS_COMPONENTS, (Object[])components));
    }

    default public T getComposite(Serializable value) {
        return this.getNonAmbiguousResult(this.getComposites(value).stream());
    }

    default public Snapshot<T> getComposites(Serializable value) {
        return this.getComposites().filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getComposites() {
        return this.getCurrentCache().getComposites((DefaultGeneric)this);
    }

    public static <T extends DefaultGeneric<T>> Predicate<T> valueFilter(Serializable value) {
        return attribute -> Objects.equals(attribute.getValue(), value);
    }

    public static <T extends DefaultGeneric<T>> Predicate<T> overridesFilter(List<T> overrides) {
        return x -> overrides.isEmpty() ? x.getSupers().isEmpty() : DefaultDependencies.filter(x.getSupers(), overrides).test((DefaultGeneric)x);
    }

    public static <T extends DefaultGeneric<T>> Predicate<T> componentsFilter(T ... components) {
        return x -> DefaultDependencies.filter(x.getComponents(), Arrays.asList(components)).test((DefaultGeneric)x);
    }

    public static <T extends DefaultGeneric<T>> Predicate<T> filter(List<T> ancestors, List<T> ancestorsReached) {
        return attribute -> {
            ArrayList attributeAncestors = new ArrayList(ancestors);
            for (DefaultGeneric ancestorsReach : ancestorsReached) {
                DefaultGeneric matchedComponent = attributeAncestors.stream().filter(attributeAncestor -> attributeAncestor.equals(ancestorsReach)).findFirst().orElse(null);
                if (matchedComponent != null) {
                    attributeAncestors.remove(matchedComponent);
                    continue;
                }
                return false;
            }
            return true;
        };
    }

    public T getNonAmbiguousResult(Stream<T> var1);
}

