/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import org.genericsystem.api.core.IGeneric;
import org.genericsystem.defaults.DefaultGeneric;

public interface DefaultDisplay<T extends DefaultGeneric<T>>
extends IGeneric<T> {
    default public String info() {
        return "(" + ((DefaultGeneric)this.getMeta()).getValue() + ")" + this.getSupers() + this + this.getComponents() + " ";
    }

    default public String detailedInfo() {
        String s = "\n\n*******************************" + System.identityHashCode(this) + "******************************\n";
        s = s + " Value       : " + this.getValue() + "\n";
        s = s + " Meta        : " + this.getMeta() + " (" + System.identityHashCode(this.getMeta()) + ")\n";
        s = s + " MetaLevel   : " + DefaultDisplay.getMetaLevelString(this.getLevel()) + "\n";
        s = s + " Category    : " + DefaultDisplay.getCategoryString(this.getLevel(), this.getComponents().size()) + "\n";
        s = s + " Class       : " + this.getClass().getName() + "\n";
        s = s + "**********************************************************************\n";
        for (DefaultGeneric superGeneric : this.getSupers()) {
            s = s + " Super       : " + superGeneric + " (" + System.identityHashCode(superGeneric) + ")\n";
        }
        for (DefaultGeneric component : this.getComponents()) {
            s = s + " Component   : " + component + " (" + System.identityHashCode(component) + ")\n";
        }
        s = s + "**********************************************************************\n";
        return s;
    }

    public static String getMetaLevelString(int metaLevel) {
        switch (metaLevel) {
            case 0: {
                return "META";
            }
            case 1: {
                return "STRUCTURAL";
            }
            case 2: {
                return "CONCRETE";
            }
            case 3: {
                return "SENSOR";
            }
        }
        return "UNKNOWN";
    }

    public static String getCategoryString(int metaLevel, int dim) {
        switch (metaLevel) {
            case 0: {
                switch (dim) {
                    case 0: {
                        return "MetaType";
                    }
                    case 1: {
                        return "MetaAttribute";
                    }
                    case 2: {
                        return "MetaRelation";
                    }
                }
                return "MetaNRelation";
            }
            case 1: {
                switch (dim) {
                    case 0: {
                        return "Type";
                    }
                    case 1: {
                        return "Attribute";
                    }
                    case 2: {
                        return "Relation";
                    }
                }
                return "NRelation";
            }
            case 2: {
                switch (dim) {
                    case 0: {
                        return "Instance";
                    }
                    case 1: {
                        return "Holder";
                    }
                    case 2: {
                        return "Link";
                    }
                }
                return "NLink";
            }
        }
        return null;
    }
}

