/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults.constraints;

import java.io.Serializable;
import java.util.Objects;
import org.genericsystem.api.core.annotations.Components;
import org.genericsystem.api.core.annotations.Meta;
import org.genericsystem.api.core.annotations.Supers;
import org.genericsystem.api.core.annotations.SystemGeneric;
import org.genericsystem.api.core.annotations.constraints.InstanceValueClassConstraint;
import org.genericsystem.api.core.annotations.constraints.PropertyConstraint;
import org.genericsystem.api.core.exceptions.ConstraintViolationException;
import org.genericsystem.defaults.DefaultConfig;
import org.genericsystem.defaults.DefaultRoot;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.defaults.constraints.Constraint;
import org.genericsystem.defaults.exceptions.UniqueValueConstraintViolationException;

@SystemGeneric
@Meta(value=DefaultConfig.MetaAttribute.class)
@Supers(value={DefaultConfig.SystemMap.class})
@Components(value={DefaultRoot.class})
@InstanceValueClassConstraint(value=Boolean.class)
@PropertyConstraint
public class UniqueValueConstraint<T extends DefaultVertex<T>>
implements Constraint.CheckedConstraint<T> {
    @Override
    public void check(T modified, T attribute, Serializable value) throws ConstraintViolationException {
        for (DefaultVertex instance : modified.getMeta().getSubInstances()) {
            if (!Objects.equals(instance.getValue(), modified.getValue()) || instance.equals(modified)) continue;
            throw new UniqueValueConstraintViolationException("Duplicate value : " + instance.getValue());
        }
    }
}

