/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.core.AxedPropertyClass;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.annotations.constraints.InstanceValueGenerator;
import org.genericsystem.api.core.exceptions.NotFoundException;
import org.genericsystem.defaults.DefaultConfig;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.defaults.constraints.InstanceValueClassConstraint;
import org.genericsystem.defaults.constraints.PropertyConstraint;
import org.genericsystem.defaults.constraints.RequiredConstraint;
import org.genericsystem.defaults.constraints.SingularConstraint;
import org.genericsystem.defaults.constraints.UniqueValueConstraint;

public interface DefaultSystemProperties<T extends DefaultVertex<T>>
extends IVertex<T> {
    default public T getKey(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        DefaultVertex property = (DefaultVertex)this.getRoot().find(propertyClass);
        Stream keys = property != null ? property.getInheritings().stream() : Stream.empty();
        return (T)((DefaultVertex)keys.filter(x -> Objects.equals(x.getValue(), new AxedPropertyClass(propertyClass, pos))).findFirst().orElse(null));
    }

    default public Serializable getSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        IVertex key = this.getKey((Class)propertyClass, pos);
        if (key != null) {
            DefaultVertex result = this.getHolders(key).stream().filter(x -> this.isSpecializationOf(x.getBaseComponent())).findFirst().orElse(null);
            return result != null ? result.getValue() : null;
        }
        return null;
    }

    default public T setSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos, Serializable value, T ... targets) {
        if (pos != -1 && this.getComponent(pos) == null) {
            ((DefaultContext)this.getCurrentCache()).discardWithException((Throwable)new NotFoundException("Unable to set system property : " + propertyClass.getSimpleName() + " because no component exists for position : " + pos));
        }
        DefaultVertex map = (DefaultVertex)this.getRoot().getMap();
        if (!1.$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        DefaultVertex property = (DefaultVertex)this.getRoot().bind(propertyClass);
        if (!1.$assertionsDisabled && property == null) {
            throw new AssertionError(propertyClass);
        }
        map.getMeta().setInstance(property, (Serializable)new AxedPropertyClass(propertyClass, pos), (DefaultVertex[])this.coerceToTArray(property.getComponents().toArray())).setInstance(value, (DefaultVertex[])this.addThisToTargets((IVertex[])targets));
        return (T)((DefaultVertex)this);
    }

    default public T enableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos, T ... targets) {
        this.setSystemPropertyValue(propertyClass, pos, Boolean.TRUE, (DefaultVertex[])targets);
        return (T)((DefaultVertex)this);
    }

    default public T disableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos, T ... targets) {
        this.setSystemPropertyValue(propertyClass, pos, Boolean.FALSE, (DefaultVertex[])targets);
        return (T)((DefaultVertex)this);
    }

    default public boolean isSystemPropertyEnabled(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        Serializable value = this.getSystemPropertyValue(propertyClass, pos);
        return value != null && !Boolean.FALSE.equals(value);
    }

    default public T enableReferentialIntegrity(int pos) {
        return (T)this.disableSystemProperty(DefaultConfig.NoReferentialIntegrityProperty.class, pos, new DefaultVertex[0]);
    }

    default public T disableReferentialIntegrity(int pos) {
        return (T)this.enableSystemProperty(DefaultConfig.NoReferentialIntegrityProperty.class, pos, new DefaultVertex[0]);
    }

    default public boolean isReferentialIntegrityEnabled(int pos) {
        return !this.isSystemPropertyEnabled(DefaultConfig.NoReferentialIntegrityProperty.class, pos);
    }

    default public T enableSingularConstraint(int pos) {
        return (T)this.enableSystemProperty(SingularConstraint.class, pos, new DefaultVertex[0]);
    }

    default public T disableSingularConstraint(int pos) {
        return (T)this.disableSystemProperty(SingularConstraint.class, pos, new DefaultVertex[0]);
    }

    default public boolean isSingularConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(SingularConstraint.class, pos);
    }

    default public T enablePropertyConstraint() {
        return (T)this.enableSystemProperty(PropertyConstraint.class, -1, new DefaultVertex[0]);
    }

    default public T disablePropertyConstraint() {
        return (T)this.disableSystemProperty(PropertyConstraint.class, -1, new DefaultVertex[0]);
    }

    default public boolean isPropertyConstraintEnabled() {
        return this.isSystemPropertyEnabled(PropertyConstraint.class, -1);
    }

    default public T enableUniqueValueConstraint() {
        return (T)this.enableSystemProperty(UniqueValueConstraint.class, -1, new DefaultVertex[0]);
    }

    default public T disableUniqueValueConstraint() {
        return (T)this.disableSystemProperty(UniqueValueConstraint.class, -1, new DefaultVertex[0]);
    }

    default public boolean isUniqueValueEnabled() {
        return this.isSystemPropertyEnabled(UniqueValueConstraint.class, -1);
    }

    default public T enableRequiredConstraint(int pos) {
        return (T)this.enableSystemProperty(RequiredConstraint.class, pos, (DefaultVertex[])this.coerceToTArray(new Object[]{this.getComponents().get(pos)}));
    }

    default public T disableRequiredConstraint(int pos) {
        return (T)this.disableSystemProperty(RequiredConstraint.class, pos, (DefaultVertex[])this.coerceToTArray(new Object[]{this.getComponents().get(pos)}));
    }

    default public boolean isRequiredConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(RequiredConstraint.class, pos);
    }

    @Deprecated
    default public T enableCascadeRemove(int pos) {
        return (T)this.enableSystemProperty(DefaultConfig.CascadeRemoveProperty.class, pos, new DefaultVertex[0]);
    }

    @Deprecated
    default public T disableCascadeRemove(int pos) {
        return (T)this.disableSystemProperty(DefaultConfig.CascadeRemoveProperty.class, pos, new DefaultVertex[0]);
    }

    @Deprecated
    default public boolean isCascadeRemoveEnabled(int pos) {
        return this.isSystemPropertyEnabled(DefaultConfig.CascadeRemoveProperty.class, pos);
    }

    default public T enableInheritance() {
        return (T)this.disableSystemProperty(DefaultConfig.NonHeritableProperty.class, -1, new DefaultVertex[0]);
    }

    default public T disableInheritance() {
        return (T)this.enableSystemProperty(DefaultConfig.NonHeritableProperty.class, -1, new DefaultVertex[0]);
    }

    default public boolean isInheritanceEnabled() {
        return !this.isSystemPropertyEnabled(DefaultConfig.NonHeritableProperty.class, -1);
    }

    default public Class<? extends Serializable> getInstanceValueClassConstraint() {
        return (Class)this.getSystemPropertyValue(InstanceValueClassConstraint.class, -1);
    }

    default public T setInstanceValueClassConstraint(Class<? extends Serializable> instanceValueConstraintClass) {
        this.setSystemPropertyValue(InstanceValueClassConstraint.class, -1, instanceValueConstraintClass, new DefaultVertex[0]);
        return (T)((DefaultVertex)this);
    }

    default public Class<? extends InstanceValueGenerator.ValueGenerator> getInstanceValueGenerator() {
        return (Class)this.getSystemPropertyValue(DefaultConfig.InstanceValueGeneratorProperty.class, -1);
    }

    default public T setInstanceValueGenerator(Class<? extends InstanceValueGenerator.ValueGenerator> instanceValueGeneratorClass) {
        this.setSystemPropertyValue(DefaultConfig.InstanceValueGeneratorProperty.class, -1, instanceValueGeneratorClass, new DefaultVertex[0]);
        return (T)((DefaultVertex)this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    static class 1 {
    }
}

