/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.defaults.DefaultVertex;

class InheritanceComputer<T extends DefaultVertex<T>>
extends HashSet<T> {
    private static final long serialVersionUID = 1877502935577170921L;
    private final Map<T, Collection<T>> inheritingsCache = new HashMap<T, Collection<T>>();
    private final T base;
    private final T origin;
    private final int level;

    InheritanceComputer(T base, T origin, int level) {
        this.base = base;
        this.origin = origin;
        this.level = level;
    }

    Stream<T> inheritanceStream() {
        return this.getInheringsStream(this.base).filter(holder -> !this.contains(holder) && !holder.equals(this.origin) && holder.getLevel() == this.level);
    }

    private Stream<T> getInheringsStream(T superVertex) {
        Collection result = this.inheritingsCache.get(superVertex);
        if (result == null) {
            result = new Inheritings(this, (DefaultVertex)superVertex).inheritanceStream().collect(Collectors.toList());
            this.inheritingsCache.put(superVertex, result);
        }
        return result.stream();
    }

    private static <T extends DefaultVertex<T>> Stream<T> compositesByMeta(T localBase, T holder) {
        return localBase.getComposites().get().filter(x -> !x.equals(holder) && ((DefaultVertex)x.getMeta()).equals(holder));
    }

    private static <T extends DefaultVertex<T>> Stream<T> compositesBySuper(T localBase, T holder) {
        return localBase.getComposites().get().filter(x -> x.getSupers().contains(holder));
    }

    private static class Inheritings {
        private final T localBase;
        final /* synthetic */ InheritanceComputer this$0;

        private Inheritings(T localBase) {
            this.this$0 = var1_1;
            this.localBase = localBase;
        }

        private Stream<T> inheritanceStream() {
            return this.fromAboveStream().flatMap(holder -> this.getStream(holder)).distinct();
        }

        private boolean hasIntermediateSuperOrIsMeta() {
            return this.localBase.isMeta() || this.localBase.getSupers().stream().filter(next -> ((DefaultVertex)this.localBase.getMeta()).equals(next.getMeta())).count() != 0L;
        }

        private Stream<T> metaAndSupersStream() {
            return Stream.concat(this.hasIntermediateSuperOrIsMeta() ? Stream.empty() : Stream.of(this.localBase.getMeta()), this.localBase.getSupers().stream()).distinct();
        }

        private Stream<T> fromAboveStream() {
            return this.localBase.isRoot() ? Stream.of(this.this$0.origin) : this.metaAndSupersStream().flatMap(x$0 -> this.this$0.getInheringsStream(x$0)).distinct();
        }

        private Stream<T> getStream(T holder) {
            if (InheritanceComputer.compositesBySuper(this.localBase, holder).count() != 0L) {
                this.this$0.add(holder);
            }
            Stream<DefaultVertex> indexStream = Stream.concat(holder.getLevel() < this.this$0.level ? InheritanceComputer.compositesByMeta(this.localBase, holder) : Stream.empty(), InheritanceComputer.compositesBySuper(this.localBase, holder));
            return Stream.concat(Stream.of(holder), indexStream.flatMap(x -> this.getStream(x)).distinct());
        }
    }
}

