/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.core.ApiStatics;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.exceptions.AmbiguousSelectionException;
import org.genericsystem.api.core.exceptions.MetaRuleConstraintViolationException;
import org.genericsystem.defaults.DefaultAncestors;
import org.genericsystem.defaults.DefaultCompositesInheritance;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.defaults.DefaultDependencies;
import org.genericsystem.defaults.DefaultDisplay;
import org.genericsystem.defaults.DefaultSystemProperties;
import org.genericsystem.defaults.DefaultWritable;
import org.genericsystem.defaults.annotation.GenerateValue;

public interface DefaultVertex<T extends DefaultVertex<T>>
extends DefaultAncestors<T>,
DefaultDependencies<T>,
DefaultDisplay<T>,
DefaultSystemProperties<T>,
DefaultCompositesInheritance<T>,
DefaultWritable<T> {
    @Override
    default public DefaultContext<T> getCurrentCache() {
        return this.getRoot().getCurrentCache();
    }

    @Override
    default public boolean isAlive() {
        return this.getCurrentCache().isAlive(this);
    }

    @Override
    default public T addInstance(List<T> overrides, Serializable value, T ... components) {
        return (T)this.getCurrentCache().addInstance(this, overrides, value, this.reorder(Arrays.asList(components)));
    }

    default public List<T> reorder(List<T> components) {
        ArrayList<T> previousOrderComp = new ArrayList<T>(components);
        ArrayList<DefaultVertex<T>> result = new ArrayList<DefaultVertex<T>>();
        for (DefaultVertex type : this.getComponents()) {
            DefaultVertex matchedComponent = previousOrderComp.stream().filter(component -> component.isSpecializationOf(type)).findFirst().orElse(null);
            if (matchedComponent != null) {
                result.add(matchedComponent);
                previousOrderComp.remove(matchedComponent);
                continue;
            }
            this.getCurrentCache().discardWithException((Throwable)new MetaRuleConstraintViolationException("Unable to order components : " + components + " with this meta : " + this.info()));
        }
        result.addAll(previousOrderComp);
        return result;
    }

    @Override
    default public T setInstance(List<T> overrides, Serializable value, T ... components) {
        return (T)this.getCurrentCache().setInstance(this, overrides, value, this.reorder(Arrays.asList(components)));
    }

    @Override
    default public T update(List<T> overrides, Serializable newValue, T ... newComponents) {
        return (T)this.getCurrentCache().update(this, overrides, newValue, Arrays.asList(newComponents));
    }

    public static <T extends DefaultVertex<T>> boolean isSuperOf(T subMeta, Serializable subValue, List<T> subComponents, T superMeta, Serializable superValue, List<T> superComponents) {
        if (subMeta == null ? !superMeta.isMeta() : !subMeta.inheritsFrom(superMeta)) {
            return false;
        }
        boolean[] singular = new boolean[1];
        if (!superMeta.componentsDepends(subComponents, superComponents, singular)) {
            return false;
        }
        if (singular[0]) {
            return true;
        }
        if (superMeta.isPropertyConstraintEnabled() && !subComponents.equals(superComponents)) {
            return true;
        }
        return Objects.equals(subValue, superValue);
    }

    default public boolean inheritsFrom(T superMeta, Serializable superValue, List<T> superComponents) {
        return this.inheritsFrom(superMeta, Collections.emptyList(), superValue, superComponents);
    }

    default public boolean inheritsFrom(T superMeta, List<T> overrides, Serializable superValue, List<T> superComponents) {
        return DefaultVertex.isSuperOf((DefaultVertex)this.getMeta(), this.getValue(), this.getComponents(), superMeta, superValue, superComponents) && ApiStatics.areOverridesReached((List)this.getSupers(), overrides);
    }

    default public boolean isDependencyOf(T meta, List<T> supers, Serializable value, List<T> components) {
        return this.inheritsFrom(meta, supers, value, components) || this.getComponents().stream().anyMatch(component -> component.isDependencyOf(meta, supers, value, components)) || !this.isMeta() && ((DefaultVertex)this.getMeta()).isDependencyOf(meta, supers, value, components) || !components.equals(this.getComponents()) && this.componentsDepends(this.getComponents(), components) && supers.stream().anyMatch(override -> override.inheritsFrom((DefaultVertex)this.getMeta()));
    }

    default public boolean isSuperOf(T subMeta, List<T> overrides, Serializable subValue, List<T> subComponents) {
        return overrides.stream().anyMatch(override -> override.inheritsFrom(this)) || ApiStatics.areOverridesReached((List)this.getSupers(), overrides) && DefaultVertex.isSuperOf(subMeta, subValue, subComponents, (DefaultVertex)this.getMeta(), this.getValue(), this.getComponents());
    }

    default public boolean componentsDepends(List<T> subComponents, List<T> superComponents) {
        return this.componentsDepends(subComponents, superComponents, new boolean[1]);
    }

    default public boolean componentsDepends(List<T> subComponents, List<T> superComponents, boolean[] singular) {
        singular[0] = false;
        int subIndex = 0;
        block0: for (DefaultVertex superComponent : superComponents) {
            while (subIndex < subComponents.size()) {
                DefaultVertex subComponent = (DefaultVertex)subComponents.get(subIndex);
                if (subComponent.isSpecializationOf(superComponent) || this.isSpecializationOf(superComponent) || subComponent.isSpecializationOf(this)) {
                    if (this.isSingularConstraintEnabled(subIndex) && subComponent != superComponent) {
                        singular[0] = true;
                    }
                    ++subIndex;
                    continue block0;
                }
                ++subIndex;
            }
            return singular[0];
        }
        return true;
    }

    default public T[] coerceToTArray(Object ... array) {
        DefaultVertex[] result = this.getCurrentCache().newTArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (DefaultVertex)array[i];
        }
        return result;
    }

    default public T adjustMeta(T ... components) {
        return this.adjustMeta(Arrays.asList(components));
    }

    default public T adjustMeta(List<T> components) {
        DefaultVertex result = null;
        if (!components.equals(this.getComponents())) {
            for (DefaultVertex directInheriting : this.getInheritings()) {
                if (!this.componentsDepends(components, directInheriting.getComponents())) continue;
                if (result == null) {
                    result = directInheriting;
                    continue;
                }
                this.getCurrentCache().discardWithException((Throwable)new AmbiguousSelectionException("Ambigous selection : " + result.info() + directInheriting.info()));
            }
        }
        return (T)(result == null ? this : result.adjustMeta(components));
    }

    default public T getDirectInstance(List<T> overrides, Serializable value, List<T> components) {
        if (this.isMeta() && this.equalsRegardlessSupers((ISignature<?>)this, value, (List<? extends ISignature<?>>)components)) {
            return (T)this;
        }
        for (DefaultVertex instance : this.getInstances()) {
            if (!instance.equalsRegardlessSupers((ISignature<?>)this, value, (List<? extends ISignature<?>>)components) || !ApiStatics.areOverridesReached((List)instance.getSupers(), overrides) || instance.getSupers().stream().anyMatch(superG -> superG.getComponents().equals(components) && this.equals(superG.getMeta())) && !ApiStatics.areOverridesReached(overrides, (List)instance.getSupers())) continue;
            return (T)instance;
        }
        return null;
    }

    default public T getDirectEquivInstance(Serializable value, List<T> components) {
        if (this.isMeta() && this.equalsRegardlessSupers((ISignature<?>)this, value, (List<? extends ISignature<?>>)components)) {
            return (T)this;
        }
        for (DefaultVertex instance : this.getInstances()) {
            if (!instance.equiv((ISignature<?>)this, value, (List<? extends ISignature<?>>)components)) continue;
            return (T)instance;
        }
        return null;
    }

    default public boolean equalsAndOverrides(T meta, List<T> overrides, Serializable value, List<T> components) {
        return this.equalsRegardlessSupers((ISignature<?>)meta, value, (List<? extends ISignature<?>>)components) && ApiStatics.areOverridesReached((List)this.getSupers(), overrides);
    }

    default public boolean equals(ISignature<?> meta, List<? extends ISignature<?>> supers, Serializable value, List<? extends ISignature<?>> components) {
        return this.equalsRegardlessSupers(meta, value, components) && this.getSupers().equals(supers);
    }

    default public boolean equalsRegardlessSupers(ISignature<?> meta, Serializable value, List<? extends ISignature<?>> components) {
        if (!((DefaultVertex)this.getMeta()).equals(meta == null ? this : meta)) {
            return false;
        }
        if (!Objects.equals(this.getValue(), value)) {
            return false;
        }
        List componentsList = this.getComponents();
        if (componentsList.size() != components.size()) {
            return false;
        }
        return componentsList.equals(components);
    }

    default public boolean genericEquals(ISignature<?> service) {
        if (service == null) {
            return false;
        }
        if (this == service) {
            return true;
        }
        if (!((DefaultVertex)this.getMeta()).genericEquals((ISignature<?>)(service == service.getMeta() ? this : service.getMeta()))) {
            return false;
        }
        if (!Objects.equals(this.getValue(), service.getValue())) {
            return false;
        }
        List componentsList = this.getComponents();
        if (componentsList.size() != service.getComponents().size()) {
            return false;
        }
        for (int i = 0; i < componentsList.size(); ++i) {
            if (DefaultVertex.genericEquals((DefaultVertex)componentsList.get(i), (ISignature)service.getComponents().get(i))) continue;
            return false;
        }
        List supersList = this.getSupers();
        if (supersList.size() != service.getSupers().size()) {
            return false;
        }
        for (int i = 0; i < supersList.size(); ++i) {
            if (((DefaultVertex)supersList.get(i)).genericEquals((ISignature)service.getSupers().get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends DefaultVertex<T>> boolean genericEquals(T component, ISignature<?> compare) {
        return component == compare || component != null && component.genericEquals(compare);
    }

    public static <T extends DefaultVertex<T>> boolean equiv(T component, ISignature<?> compare) {
        return component == compare || component != null && component.equiv(compare);
    }

    default public boolean equiv(ISignature<? extends ISignature<?>> service) {
        if (service == null) {
            return false;
        }
        if (this == service) {
            return true;
        }
        return this.equiv(service.getMeta(), service.getValue(), service.getComponents());
    }

    default public boolean equiv(ISignature<?> meta, Serializable value, List<? extends ISignature<?>> components) {
        int i;
        if (!((DefaultVertex)this.getMeta()).equals(meta == null ? this : meta)) {
            return false;
        }
        List componentsList = this.getComponents();
        if (componentsList.size() != components.size()) {
            return false;
        }
        for (i = 0; i < componentsList.size(); ++i) {
            if (((DefaultVertex)this.getMeta()).isReferentialIntegrityEnabled(i) || !((DefaultVertex)this.getMeta()).isSingularConstraintEnabled(i)) continue;
            return DefaultVertex.equiv((DefaultVertex)componentsList.get(i), components.get(i));
        }
        for (i = 0; i < componentsList.size(); ++i) {
            if (DefaultVertex.equiv((DefaultVertex)componentsList.get(i), components.get(i))) continue;
            return false;
        }
        if (!((DefaultVertex)this.getMeta()).isPropertyConstraintEnabled()) {
            return Objects.equals(this.getValue(), value);
        }
        return true;
    }

    default public void traverse(IVertex.Visitor<T> visitor) {
        visitor.traverse((IVertex)this);
    }

    default public T addGenerateInstance(T ... components) {
        class ValueGenerator {
            ValueGenerator() {
            }

            Serializable generateValue() {
                GenerateValue generate = DefaultVertex.this.getRoot().findAnnotedClass((IVertex)DefaultVertex.this).getAnnotation(GenerateValue.class);
                if (generate == null) {
                    DefaultVertex.this.getCurrentCache().discardWithException(new IllegalStateException("Unable to find @Generate annotation on : " + DefaultVertex.this.info()));
                }
                try {
                    return generate.clazz().newInstance().generate(DefaultVertex.this);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    DefaultVertex.this.getCurrentCache().discardWithException(e);
                    return null;
                }
            }
        }
        return (T)this.addInstance(new ValueGenerator().generateValue(), (DefaultVertex[])components);
    }

    @Override
    default public T getNonAmbiguousResult(Stream<T> stream) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        DefaultVertex result = (DefaultVertex)iterator.next();
        if (iterator.hasNext()) {
            this.getCurrentCache().discardWithException((Throwable)new AmbiguousSelectionException(result.info() + " " + ((DefaultVertex)iterator.next()).info()));
        }
        return (T)result;
    }
}

