/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.exceptions.NotFoundException;
import org.genericsystem.api.core.systemproperty.AxedPropertyClass;
import org.genericsystem.api.core.systemproperty.CascadeRemoveProperty;
import org.genericsystem.api.core.systemproperty.NoReferentialIntegrityProperty;
import org.genericsystem.api.core.systemproperty.NonHeritableProperty;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.defaults.constraints.InstanceValueClassConstraint;
import org.genericsystem.defaults.constraints.PropertyConstraint;
import org.genericsystem.defaults.constraints.RequiredConstraint;
import org.genericsystem.defaults.constraints.SingularConstraint;
import org.genericsystem.defaults.constraints.UniqueValueConstraint;

public interface DefaultSystemProperties<T extends DefaultVertex<T>>
extends IVertex<T> {
    default public T getKey(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        DefaultVertex map = (DefaultVertex)this.getRoot().getMap();
        Stream keys = map != null ? map.getInheritings().get() : Stream.empty();
        return (T)((DefaultVertex)keys.filter(x -> Objects.equals(x.getValue(), new AxedPropertyClass(propertyClass, pos))).findFirst().orElse(null));
    }

    default public Serializable getSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        IVertex key = this.getKey((Class)propertyClass, pos);
        if (key != null) {
            DefaultVertex result = this.getHolders(key).get().filter(x -> this.isSpecializationOf(x.getBaseComponent())).findFirst().orElse(null);
            return result != null ? result.getValue() : null;
        }
        return null;
    }

    default public T setSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos, Serializable value, T ... targets) {
        DefaultVertex map = (DefaultVertex)this.getRoot().getMap();
        Object[] roots = ((DefaultContext)this.getCurrentCache()).newTArray(targets.length + 1);
        Arrays.fill(roots, this.getRoot());
        ((DefaultVertex)map.getMeta()).setInstance(map, (Serializable)new AxedPropertyClass(propertyClass, pos), (DefaultVertex[])roots).setInstance(value, (DefaultVertex[])this.addThisToTargets((IVertex[])targets));
        return (T)((DefaultVertex)this);
    }

    default public T enableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos, T ... targets) {
        if (pos != -1 && this.getComponent(pos) == null) {
            ((DefaultContext)this.getCurrentCache()).discardWithException((Throwable)new NotFoundException("System property is not apply because no component exists for position : " + pos));
        }
        this.setSystemPropertyValue(propertyClass, pos, Boolean.TRUE, (DefaultVertex[])targets);
        return (T)((DefaultVertex)this);
    }

    default public T disableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos, T ... targets) {
        this.setSystemPropertyValue(propertyClass, pos, Boolean.FALSE, (DefaultVertex[])targets);
        return (T)((DefaultVertex)this);
    }

    default public boolean isSystemPropertyEnabled(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        Serializable value = this.getSystemPropertyValue(propertyClass, pos);
        return value != null && !Boolean.FALSE.equals(value);
    }

    default public T enableReferentialIntegrity(int pos) {
        return (T)this.disableSystemProperty(NoReferentialIntegrityProperty.class, pos, new DefaultVertex[0]);
    }

    default public T disableReferentialIntegrity(int pos) {
        return (T)this.enableSystemProperty(NoReferentialIntegrityProperty.class, pos, new DefaultVertex[0]);
    }

    default public boolean isReferentialIntegrityEnabled(int pos) {
        return !this.isSystemPropertyEnabled(NoReferentialIntegrityProperty.class, pos);
    }

    default public T enableSingularConstraint(int pos) {
        return (T)this.enableSystemProperty(SingularConstraint.class, pos, new DefaultVertex[0]);
    }

    default public T disableSingularConstraint(int pos) {
        return (T)this.disableSystemProperty(SingularConstraint.class, pos, new DefaultVertex[0]);
    }

    default public boolean isSingularConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(SingularConstraint.class, pos);
    }

    default public T enablePropertyConstraint() {
        return (T)this.enableSystemProperty(PropertyConstraint.class, -1, new DefaultVertex[0]);
    }

    default public T disablePropertyConstraint() {
        return (T)this.disableSystemProperty(PropertyConstraint.class, -1, new DefaultVertex[0]);
    }

    default public boolean isPropertyConstraintEnabled() {
        return this.isSystemPropertyEnabled(PropertyConstraint.class, -1);
    }

    default public T enableUniqueValueConstraint() {
        return (T)this.enableSystemProperty(UniqueValueConstraint.class, -1, new DefaultVertex[0]);
    }

    default public T disableUniqueValueConstraint() {
        return (T)this.disableSystemProperty(UniqueValueConstraint.class, -1, new DefaultVertex[0]);
    }

    default public boolean isUniqueValueEnabled() {
        return this.isSystemPropertyEnabled(UniqueValueConstraint.class, -1);
    }

    default public Class<?> getClassConstraint() {
        return (Class)this.getSystemPropertyValue(InstanceValueClassConstraint.class, -1);
    }

    default public T setClassConstraint(Class<?> constraintClass) {
        this.setSystemPropertyValue(InstanceValueClassConstraint.class, -1, constraintClass, new DefaultVertex[0]);
        return (T)((DefaultVertex)this);
    }

    default public T enableClassConstraint(Class<?> constraintClass) {
        return (T)this.setClassConstraint((Class)constraintClass);
    }

    default public T disableClassConstraint() {
        return (T)this.setClassConstraint((Class)null);
    }

    default public T enableRequiredConstraint(int pos) {
        return (T)this.enableSystemProperty(RequiredConstraint.class, pos, (DefaultVertex[])this.coerceToTArray(new Object[]{this.getComponents().get(pos)}));
    }

    default public T disableRequiredConstraint(int pos) {
        return (T)this.disableSystemProperty(RequiredConstraint.class, pos, (DefaultVertex[])this.coerceToTArray(new Object[]{this.getComponents().get(pos)}));
    }

    default public boolean isRequiredConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(RequiredConstraint.class, pos);
    }

    default public T enableCascadeRemove(int pos) {
        return (T)this.enableSystemProperty(CascadeRemoveProperty.class, pos, new DefaultVertex[0]);
    }

    default public T disableCascadeRemove(int pos) {
        return (T)this.disableSystemProperty(CascadeRemoveProperty.class, pos, new DefaultVertex[0]);
    }

    default public boolean isCascadeRemoveEnabled(int pos) {
        return this.isSystemPropertyEnabled(CascadeRemoveProperty.class, pos);
    }

    default public T enableHeritable() {
        return (T)this.disableSystemProperty(NonHeritableProperty.class, -1, new DefaultVertex[0]);
    }

    default public T disableHeritable() {
        return (T)this.enableSystemProperty(NonHeritableProperty.class, -1, new DefaultVertex[0]);
    }

    default public boolean isHeritableEnabled() {
        return !this.isSystemPropertyEnabled(NonHeritableProperty.class, -1);
    }
}

