/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.Objects;
import org.genericsystem.defaults.DefaultVertex;

public interface DefaultGenerator<T extends DefaultVertex<T>> {
    public Serializable generate(T var1);

    public static class IntAutoIncrementGenerator<T extends DefaultVertex<T>>
    implements DefaultGenerator<T> {
        @Override
        public Serializable generate(T type) {
            return Integer.valueOf(this.incrementedValue(type));
        }

        protected int incrementedValue(T type) {
            Object sequence = type.getRoot().getSequence();
            DefaultVertex sequenceHolder = (DefaultVertex)type.getHolders(sequence).first();
            int value = sequenceHolder != null ? (Integer)sequenceHolder.getValue() + 1 : 0;
            type.setHolder(sequence, (Serializable)Integer.valueOf(value), new DefaultVertex[0]);
            return value;
        }

        public static class StringAutoIncrementGenerator<T extends DefaultVertex<T>>
        extends IntAutoIncrementGenerator<T> {
            @Override
            public Serializable generate(T type) {
                Integer value = this.incrementedValue(type);
                return type.getValue() instanceof Class ? ((Class)type.getValue()).getSimpleName() + "-" + value : Objects.toString(type.getValue() + "-" + value);
            }
        }
    }
}

