/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.defaults.DefaultVertex;

public interface DefaultDependencies<T extends DefaultVertex<T>>
extends IVertex<T> {
    default public boolean isAlive() {
        return this.getCurrentCache().isAlive((DefaultVertex)this);
    }

    default public boolean isAncestorOf(T dependency) {
        return this.equals(dependency) || !dependency.isMeta() && this.isAncestorOf((T)((DefaultVertex)dependency.getMeta())) || dependency.getSupers().stream().anyMatch(this::isAncestorOf) || dependency.getComponents().stream().filter(x -> x != null).anyMatch(this::isAncestorOf);
    }

    default public DefaultContext<T> getCurrentCache() {
        return (DefaultContext)this.getRoot().getCurrentCache();
    }

    default public T getInstance(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInstances(value, (DefaultVertex[])components).get());
    }

    default public T getInstance(T ... components) {
        return this.getNonAmbiguousResult(this.getInstances((DefaultVertex[])components).get());
    }

    default public T getInstance(T override, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInstances((DefaultVertex)override, value, (DefaultVertex[])components).get());
    }

    default public T getInstance(List<T> overrides, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInstances(overrides, value, (DefaultVertex[])components).get());
    }

    default public Snapshot<T> getInstances(Serializable value, T ... components) {
        return this.getInstances((DefaultVertex[])components).filter(DefaultDependencies.valueFilter(value));
    }

    default public Snapshot<T> getInstances() {
        return this.getCurrentCache().getInstances((DefaultVertex)this);
    }

    default public Snapshot<T> getInstances(T ... components) {
        return this.getInstances().filter(DefaultDependencies.componentsFilter(components));
    }

    default public Snapshot<T> getInstances(T override, Serializable value, T ... components) {
        return this.getInstances(Collections.singletonList(override), value, (DefaultVertex[])components);
    }

    default public Snapshot<T> getInstances(List<T> overrides, Serializable value, T ... components) {
        List<DefaultVertex> supers = this.getCurrentCache().computeAndCheckOverridesAreReached((DefaultVertex)this, overrides, value, Arrays.asList(components));
        return this.getInstances(value, (DefaultVertex[])components).filter(DefaultDependencies.overridesFilter(supers));
    }

    default public T getSubInstance(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances(value, (DefaultVertex[])components).get());
    }

    default public Snapshot<T> getSubInstances(Serializable value, T ... components) {
        return this.getSubInstances((DefaultVertex[])components).filter(DefaultDependencies.valueFilter(value));
    }

    default public Snapshot<T> getSubInstances() {
        return () -> this.getSubInheritings().get().flatMap(inheriting -> inheriting.getInstances().get());
    }

    default public T getSubInstance(T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances((DefaultVertex[])components).get());
    }

    default public Snapshot<T> getSubInstances(T ... components) {
        return this.getSubInstances().filter(DefaultDependencies.componentsFilter(components));
    }

    default public T getSubInstance(T override, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances((DefaultVertex)override, value, (DefaultVertex[])components).get());
    }

    default public Snapshot<T> getSubInstances(T override, Serializable value, T ... components) {
        return this.getSubInstances(Collections.singletonList(override), value, (DefaultVertex[])components);
    }

    default public T getSubInstance(List<T> overrides, Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInstances(overrides, value, (DefaultVertex[])components).get());
    }

    default public Snapshot<T> getSubInstances(List<T> overrides, Serializable value, T ... components) {
        List<DefaultVertex> supers = this.getCurrentCache().computeAndCheckOverridesAreReached((DefaultVertex)this, overrides, value, Arrays.asList(components));
        return this.getSubInstances(value, (DefaultVertex[])components).filter(DefaultDependencies.overridesFilter(supers));
    }

    default public T getInheriting(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getInheritings(value, (DefaultVertex[])components).get());
    }

    default public T getInheriting(T ... components) {
        return this.getNonAmbiguousResult(this.getInheritings((DefaultVertex[])components).get());
    }

    default public Snapshot<T> getInheritings(Serializable value, T ... components) {
        return this.getInheritings((DefaultVertex[])components).filter(DefaultDependencies.valueFilter(value));
    }

    default public Snapshot<T> getInheritings() {
        return this.getCurrentCache().getInheritings((DefaultVertex)this);
    }

    default public Snapshot<T> getInheritings(T ... components) {
        return this.getInheritings().filter(DefaultDependencies.componentsFilter(components));
    }

    default public T getSubInheriting(Serializable value, T ... components) {
        return this.getNonAmbiguousResult(this.getSubInheritings(value, (DefaultVertex[])components).get());
    }

    default public Snapshot<T> getSubInheritings(Serializable value, T ... components) {
        return this.getSubInheritings((DefaultVertex[])components).filter(DefaultDependencies.valueFilter(value));
    }

    default public T getSubInheriting(T ... components) {
        return this.getNonAmbiguousResult(this.getSubInheritings((DefaultVertex[])components).get());
    }

    default public Snapshot<T> getSubInheritings(T ... components) {
        return this.getSubInheritings().filter(DefaultDependencies.componentsFilter(components));
    }

    default public Snapshot<T> getSubInheritings() {
        return () -> Stream.concat(Stream.of((DefaultVertex)this), this.getInheritings().get().flatMap(inheriting -> inheriting.getSubInheritings().get())).distinct();
    }

    default public T getComposite(Serializable value) {
        return this.getNonAmbiguousResult(this.getComposites(value).get());
    }

    default public Snapshot<T> getComposites(Serializable value) {
        return this.getComposites().filter(DefaultDependencies.valueFilter(value));
    }

    default public Snapshot<T> getComposites() {
        return this.getCurrentCache().getComposites((DefaultVertex)this);
    }

    public static <T extends DefaultVertex<T>> Predicate<T> valueFilter(Serializable value) {
        return attribute -> Objects.equals(attribute.getValue(), value);
    }

    public static <T extends DefaultVertex<T>> Predicate<T> overridesFilter(List<T> overrides) {
        return x -> overrides.isEmpty() ? x.getSupers().isEmpty() : DefaultDependencies.filter(x.getSupers(), overrides).test((DefaultVertex)x);
    }

    public static <T extends DefaultVertex<T>> Predicate<T> componentsFilter(T ... components) {
        return x -> DefaultDependencies.filter(x.getComponents(), Arrays.asList(components)).test((DefaultVertex)x);
    }

    public static <T extends DefaultVertex<T>> Predicate<T> filter(List<T> ancestors, List<T> ancestorsReached) {
        return attribute -> {
            ArrayList attributeAncestors = new ArrayList(ancestors);
            for (DefaultVertex ancestorsReach : ancestorsReached) {
                DefaultVertex matchedComponent = attributeAncestors.stream().filter(attributeAncestor -> attributeAncestor.equals(ancestorsReach)).findFirst().orElse(null);
                if (matchedComponent != null) {
                    attributeAncestors.remove(matchedComponent);
                    continue;
                }
                return false;
            }
            return true;
        };
    }

    public T getNonAmbiguousResult(Stream<T> var1);
}

