/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.systemproperty.NonHeritableProperty;
import org.genericsystem.defaults.DefaultDependencies;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.defaults.InheritanceComputer;

public interface DefaultCompositesInheritance<T extends DefaultVertex<T>>
extends IVertex<T> {
    default public T getAttribute(Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getAttributes(value, (DefaultVertex[])targets).get());
    }

    default public T getAttribute(T ... targets) {
        return this.getNonAmbiguousResult(this.getAttributes((T)targets).get());
    }

    default public Snapshot<T> getAttributes(Serializable value, T ... targets) {
        return this.getAttributes((T)targets).filter(DefaultDependencies.valueFilter(value));
    }

    default public Snapshot<T> getAttributes(T ... targets) {
        return this.getAttributes((T)((DefaultVertex)this.getRoot().getMetaAttribute())).filter(DefaultCompositesInheritance.componentsFilter((DefaultVertex[])((DefaultVertex[])this.addThisToTargets((IVertex[])targets))));
    }

    default public Snapshot<T> getAttributes(int pos) {
        return () -> this.getAttributes((T)new DefaultVertex[0]).get().filter(attribute -> attribute.getComponent(pos) != null && ((DefaultVertex)this).isSpecializationOf(attribute.getComponent(pos)));
    }

    default public Snapshot<T> getAttributes(T attribute) {
        DefaultVertex nonHeritableProperty = (DefaultVertex)this.getKey(NonHeritableProperty.class, -1);
        if (nonHeritableProperty == null || attribute.inheritsFrom((DefaultVertex)nonHeritableProperty) || attribute.isHeritableEnabled()) {
            return () -> new InheritanceComputer<DefaultVertex>((DefaultVertex)this, attribute, 1).inheritanceStream();
        }
        return () -> this.getComposites().get().filter(holder -> holder.isSpecializationOf(attribute) && holder.getLevel() == 1);
    }

    default public T getHolder(T attribute, Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getHolders((DefaultVertex)attribute, value, (DefaultVertex[])targets).get());
    }

    default public T getHolder(T attribute, T ... targets) {
        return this.getNonAmbiguousResult(this.getHolders((DefaultVertex)attribute, (DefaultVertex[])targets).get());
    }

    default public Snapshot<T> getHolders(T attribute, Serializable value, T ... targets) {
        return this.getHolders(attribute).filter(DefaultDependencies.valueFilter(value)).filter(DefaultCompositesInheritance.componentsFilter((DefaultVertex[])((DefaultVertex[])this.addThisToTargets((IVertex[])targets))));
    }

    default public Snapshot<T> getHolders(T attribute, T ... targets) {
        return this.getHolders(attribute).filter(DefaultCompositesInheritance.componentsFilter((DefaultVertex[])((DefaultVertex[])this.addThisToTargets((IVertex[])targets))));
    }

    default public Snapshot<T> getHolders(T attribute, int pos) {
        return () -> this.getHolders(attribute).get().filter(holder -> holder.getComponent(pos) != null && ((DefaultVertex)this).isSpecializationOf(holder.getComponent(pos)));
    }

    default public Snapshot<T> getHolders(T attribute) {
        DefaultVertex nonHeritableProperty = (DefaultVertex)this.getKey(NonHeritableProperty.class, -1);
        if (nonHeritableProperty == null || attribute.inheritsFrom((DefaultVertex)nonHeritableProperty) || attribute.isHeritableEnabled()) {
            return () -> new InheritanceComputer<DefaultVertex>((DefaultVertex)this, attribute, 2).inheritanceStream();
        }
        return () -> this.getComposites().get().filter(holder -> holder.isSpecializationOf(attribute) && holder.getLevel() == 2);
    }

    default public T getRelation(Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getRelations(value, (DefaultVertex[])targets).get());
    }

    default public T getRelation(T ... targets) {
        return this.getNonAmbiguousResult(this.getRelations((T)targets).get());
    }

    default public Snapshot<T> getRelations(Serializable value, T ... targets) {
        return this.getRelations((T)targets).filter(DefaultDependencies.valueFilter(value));
    }

    default public Snapshot<T> getRelations(T ... targets) {
        return this.getRelations((T)((DefaultVertex)this.getRoot().getMetaRelation())).filter(DefaultCompositesInheritance.componentsFilter((DefaultVertex[])((DefaultVertex[])this.addThisToTargets((IVertex[])targets))));
    }

    default public Snapshot<T> getRelations(int pos) {
        return () -> this.getRelations((T)new DefaultVertex[0]).get().filter(relation -> relation.getComponent(pos) != null && ((DefaultVertex)this).isSpecializationOf(relation.getComponent(pos)));
    }

    default public Snapshot<T> getRelations(T relation) {
        return ((DefaultVertex)this).getAttributes((DefaultVertex)relation);
    }

    default public T getLink(T relation, Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getLinks((DefaultVertex)relation, value, (DefaultVertex[])targets).get());
    }

    default public T getLink(T relation, T ... targets) {
        return this.getNonAmbiguousResult(this.getLinks((DefaultVertex)relation, (DefaultVertex[])targets).get());
    }

    default public Snapshot<T> getLinks(T relation, Serializable value, T ... targets) {
        return this.getLinks(relation).filter(DefaultDependencies.valueFilter(value)).filter(DefaultCompositesInheritance.componentsFilter((DefaultVertex[])((DefaultVertex[])this.addThisToTargets((IVertex[])targets))));
    }

    default public Snapshot<T> getLinks(T relation, T ... targets) {
        return this.getLinks(relation).filter(DefaultCompositesInheritance.componentsFilter((DefaultVertex[])((DefaultVertex[])this.addThisToTargets((IVertex[])targets))));
    }

    default public Snapshot<T> getLinks(T relation, int pos) {
        return () -> this.getLinks(relation).get().filter(link -> link.getComponent(pos) != null && ((DefaultVertex)this).isSpecializationOf(link.getComponent(pos)));
    }

    default public Snapshot<T> getLinks(T relation) {
        return ((DefaultVertex)this).getHolders((DefaultVertex)relation);
    }

    default public Serializable getValue(T attribute, Serializable value, T ... targets) {
        DefaultVertex holder = this.getHolder((DefaultVertex)attribute, value, (DefaultVertex[])targets);
        return holder != null ? holder.getValue() : null;
    }

    default public Serializable getValue(T attribute, T ... targets) {
        DefaultVertex holder = this.getHolder((DefaultVertex)attribute, (DefaultVertex[])targets);
        return holder != null ? holder.getValue() : null;
    }

    default public Snapshot<Serializable> getValues(T attribute, Serializable value, T ... targets) {
        return () -> this.getLinks((DefaultVertex)attribute, value, (DefaultVertex[])targets).get().map(x -> x.getValue());
    }

    default public Snapshot<Serializable> getValues(T attribute, T ... targets) {
        return () -> this.getLinks((DefaultVertex)attribute, (DefaultVertex[])targets).get().map(x -> x.getValue());
    }

    default public Snapshot<Serializable> getValues(T attribute, int pos) {
        return () -> this.getHolders(attribute, pos).get().map(x -> x.getValue());
    }

    public static <T extends DefaultVertex<T>> Predicate<T> componentsFilter(T ... componentsReached) {
        return attribute -> {
            ArrayList attributeComps = new ArrayList(attribute.getComponents());
            for (DefaultVertex componentReach : componentsReached) {
                DefaultVertex matchedComponent = attributeComps.stream().filter(attributeComp -> componentsReached[0].isSpecializationOf(attributeComp) ? true : componentReach.equals(attributeComp)).findFirst().orElse(null);
                if (matchedComponent == null) {
                    return false;
                }
                attributeComps.remove(matchedComponent);
            }
            return true;
        };
    }

    public T getNonAmbiguousResult(Stream<T> var1);
}

