/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.LinesDetector8;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class LinesDetector9
extends AbstractApp {
    static final double f = 672.5555555555555;
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private boolean stabilize;
    private LinesDetector8.Lines lines;
    double[] vps0 = new double[]{5000.0, 0.0, 1.0};

    @Override
    protected void onSpace() {
        this.stabilize = !this.stabilize;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    public static void main(String[] args) {
        LinesDetector9.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        Mat dePerspectived = new Mat();
        this.capture.read(frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskiewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskiewedView, 0, 1);
        ImageView gradView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)gradView, 1, 0);
        this.timer.scheduleAtFixedRate(() -> {
            try {
                if (!this.stabilize) {
                    this.capture.read(frame);
                }
                Img grad = new Img(frame, false).morphologyEx(4, 2, new Size(10.0, 10.0)).otsu();
                Img closed = grad.morphologyEx(3, 2, new Size(10.0, 10.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
                gradView.setImage(closed.toJfxImage());
                if (!this.stabilize) {
                    this.lines = new LinesDetector8.Lines(closed.houghLinesP(1, Math.PI / 180, 10, 20.0, 5.0));
                }
                if (this.lines.size() > 10) {
                    Mat colorFrame = frame.clone();
                    this.lines.draw(colorFrame, new Scalar(0.0, 0.0, 0.0));
                    Img img = new Img(frame, false);
                    List<Edgelet> edgelets1 = LinesDetector9.computeEdgelets(img);
                    double[] pp = new double[]{frame.width() / 2, frame.height() / 2};
                    this.vps0 = new LevenbergImpl<Edgelet>((edgelet, model) -> LinesDetector9.computeVote(edgelet, model, 5.0), edgelets1, this.vps0).getParams();
                    double[] calibratedVps0 = new Calibrated(this.vps0, pp, 672.5555555555555).getCalibratexyz();
                    double[] calibratedVps1 = new Calibrated(new double[]{320.0, 240000.0, 1.0}, pp, 672.5555555555555).getCalibratexyz();
                    System.out.println("SCALAR :" + (calibratedVps0[0] * calibratedVps1[0] + calibratedVps0[1] * calibratedVps1[1] + calibratedVps0[2] * calibratedVps1[2]));
                    frameView.setImage(Tools.mat2jfxImage(colorFrame));
                    Mat homographyMat = LinesDetector9.findHomography(frame.size(), LinesDetector9.reorderXyz(new double[][]{calibratedVps0, calibratedVps1}), new double[]{frame.width() / 2, frame.height() / 2}, 672.5555555555555);
                    Imgproc.warpPerspective((Mat)frame, (Mat)dePerspectived, (Mat)homographyMat, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    deskiewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + this.lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 50L, TimeUnit.MILLISECONDS);
    }

    public double[] getOrthoVpFromVp(double[] vp1, double lambda) {
        double k1 = vp1[0] * Math.sin(lambda) + vp1[1] * Math.cos(lambda);
        double k2 = vp1[2];
        double phi = Math.atan(-k2 / k1);
        double[] result = new double[]{Math.sin(phi) * Math.sin(lambda), Math.sin(phi) * Math.cos(lambda), Math.cos(phi)};
        if (result[2] == 0.0) {
            result[2] = 0.0011;
        }
        double N = Math.sqrt(result[0] * result[0] + result[1] * result[1] + result[2] * result[2]);
        result[0] = result[0] * (1.0 / N);
        result[1] = result[1] * (1.0 / N);
        result[2] = result[2] * (1.0 / N);
        return result;
    }

    public static Mat findHomography(Size size, double[][] vps, double[] pp, double f) {
        double[][] vps2D = LinesDetector9.getVp2DFromVps(vps, pp, f);
        System.out.println("vps2D : " + Arrays.deepToString((Object[])vps2D));
        double theta = Math.acos(vps[0][2]);
        double phi = Math.atan2(vps[0][1], vps[0][0]);
        double theta2 = Math.acos(vps[1][2]);
        double phi2 = Math.atan2(vps[1][1], vps[1][0]);
        double x = size.width / 4.0;
        double[] A = new double[]{size.width / 2.0, size.height / 2.0, 1.0};
        double[] B = new double[]{Math.cos(phi) < 0.0 ? size.width / 2.0 - x : size.width / 2.0 + x, size.height / 2.0};
        double[] D = new double[]{size.width / 2.0, Math.sin(phi2) < 0.0 ? size.height / 2.0 - x : size.height / 2.0 + x, 1.0};
        double[] C = new double[]{Math.cos(phi) < 0.0 ? size.width / 2.0 - x : size.width / 2.0 + x, Math.sin(phi2) < 0.0 ? size.height / 2.0 - x : size.height / 2.0 + x};
        System.out.println("vp1 (" + theta * 180.0 / Math.PI + "\u00b0, " + phi * 180.0 / Math.PI + "\u00b0)");
        System.out.println("vp2 (" + theta2 * 180.0 / Math.PI + "\u00b0, " + phi2 * 180.0 / Math.PI + "\u00b0)");
        double[] A_ = A;
        double[] B_ = new double[]{size.width / 2.0 + x * Math.sin(theta) * Math.sin(theta) * Math.cos(phi), size.height / 2.0 + x * Math.sin(theta) * Math.sin(theta) * Math.sin(phi), 1.0};
        double[] D_ = new double[]{size.width / 2.0 + x * Math.sin(theta2) * Math.sin(theta2) * Math.cos(phi2), size.height / 2.0 + x * Math.sin(theta2) * Math.sin(theta2) * Math.sin(phi2), 1.0};
        double[] C_ = LinesDetector9.cross2D(LinesDetector9.cross(B_, vps2D[1]), LinesDetector9.cross(D_, vps2D[0]));
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(A_), new Point(B_), new Point(C_), new Point(D_)}), (Mat)new MatOfPoint2f(new Point[]{new Point(A), new Point(B), new Point(C), new Point(D)}));
    }

    static double[] getVpFromVp2D(double[] vpImg, double[] pp, double f) {
        double[] vp = new double[]{vpImg[0] / vpImg[2] - pp[0], vpImg[1] / vpImg[2] - pp[1], f};
        if (vp[2] == 0.0) {
            vp[2] = 0.0011;
        }
        double N = Math.sqrt(vp[0] * vp[0] + vp[1] * vp[1] + vp[2] * vp[2]);
        vp[0] = vp[0] * (1.0 / N);
        vp[1] = vp[1] * (1.0 / N);
        vp[2] = vp[2] * (1.0 / N);
        return vp;
    }

    public static double[][] getVp2DFromVps(double[][] vps, double[] pp, double f) {
        double[][] result = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            result[i][0] = vps[i][0] * f / vps[i][2] + pp[0];
            result[i][1] = vps[i][1] * f / vps[i][2] + pp[1];
            result[i][2] = 1.0;
        }
        return result;
    }

    static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    static double det(double[] u, double[] v, double[] w) {
        return u[0] * v[1] * w[2] + u[2] * v[0] * w[1] + u[1] * v[2] * w[0] - u[2] * v[1] * w[0] - u[1] * v[0] * w[2] - u[0] * v[2] * w[1];
    }

    static double[] cross2D(double[] a, double[] b) {
        return LinesDetector9.uncalibrate(LinesDetector9.cross(a, b));
    }

    static double[] uncalibrate(double[] a) {
        return new double[]{a[0] / a[2], a[1] / a[2], 1.0};
    }

    public static List<Edgelet> computeEdgelets(Img image) {
        Img grad = image.morphologyEx(4, 2, new Size(10.0, 10.0)).otsu();
        Img closed = grad.morphologyEx(3, 2, new Size(10.0, 20.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
        LinesDetector8.Lines lines = new LinesDetector8.Lines(closed.houghLinesP(1, Math.PI / 180, 10, 20.0, 5.0));
        return lines.lines.stream().map(Edgelet::new).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    public static List<double[]> edgeletLines(List<Edgelet> edgelets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Double> computeVotes(List<Edgelet> edgelets, double[] model, double threshold_inlier) {
        double[] vp = new double[]{model[0] / model[2], model[1] / model[2]};
        ArrayList<Double> result = new ArrayList<Double>();
        for (Edgelet edgelet : edgelets) {
            result.add(LinesDetector9.computeVote(edgelet, vp, threshold_inlier));
        }
        return result;
    }

    public static Double computeVote(Edgelet edgelet, double[] vp, double threshold_inlier) {
        double theta_thresh;
        double theta;
        double est_directions0 = edgelet.location[0] - vp[0];
        double est_directions1 = edgelet.location[1] - vp[1];
        double dotProd = est_directions0 * edgelet.direction[0] + est_directions1 * edgelet.direction[1];
        double absProd = Math.sqrt(edgelet.direction[0] * edgelet.direction[0] + edgelet.direction[1] * edgelet.direction[1]) * Math.sqrt(est_directions0 * est_directions0 + est_directions1 * est_directions1);
        if (absProd == 0.0) {
            absProd = 1.0E-5;
        }
        return (theta = Math.acos(Math.abs(dotProd / absProd))) < (theta_thresh = threshold_inlier * Math.PI / 180.0) ? edgelet.strength * (Math.sin(2.0 * theta) + 0.2) : 0.0;
    }

    private static List<Integer> reverseArgSort(List<Double> a) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(a.size());
        for (int i = 0; i < a.size(); ++i) {
            indexes.add(i);
        }
        Collections.sort(indexes, (i1, i2) -> -Double.compare((Double)a.get((int)i1), (Double)a.get((int)i2)));
        return indexes;
    }

    public static double[] ransacVanishingPoint(List<Edgelet> edgelets, int numRansacIter, double thresholdInlier) {
        List<Double> strengths = edgelets.stream().map(edgelet -> edgelet.strength).collect(Collectors.toList());
        List<double[]> lines = LinesDetector9.edgeletLines(edgelets);
        List<Integer> sorted = LinesDetector9.reverseArgSort(strengths);
        ArrayList<Integer> first_index_space = new ArrayList<Integer>(sorted.subList(0, strengths.size() / 5));
        ArrayList<Integer> second_index_space = new ArrayList<Integer>(sorted.subList(0, strengths.size() / 2));
        double[] best_model = null;
        double best_votes = 0.0;
        for (int ransacIter = 0; ransacIter < numRansacIter; ++ransacIter) {
            double current_votes;
            double[] l2;
            double[] l1 = lines.get((Integer)first_index_space.get((int)(Math.random() * (double)first_index_space.size())));
            double[] current_model = LinesDetector9.cross(l1, l2 = lines.get((Integer)second_index_space.get((int)(Math.random() * (double)second_index_space.size()))));
            if (current_model[0] * current_model[0] + current_model[1] * current_model[1] + current_model[2] * current_model[2] < 1.0 || current_model[2] == 0.0 || !((current_votes = LinesDetector9.computeVotes(edgelets, current_model, thresholdInlier).stream().mapToDouble(d -> d).sum()) > best_votes)) continue;
            best_model = current_model;
            best_votes = current_votes;
        }
        return best_model;
    }

    private static double[][] reorderXyz(double[][] calibrateds) {
        if (calibrateds[0][1] * calibrateds[0][1] < calibrateds[1][1] * calibrateds[1][1]) {
            return new double[][]{calibrateds[0], calibrateds[1]};
        }
        return new double[][]{calibrateds[1], calibrateds[0]};
    }

    /*
     * Exception decompiling
     */
    public static double[] reestimate_model(double[] model, List<Edgelet> edgelets, int threshold_reestimate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Edgelet> removeInliers(double[] model, List<Edgelet> edgelets, int threshold_inlier) {
        List<Double> votes = LinesDetector9.computeVotes(edgelets, model, threshold_inlier);
        ArrayList<Edgelet> ouliers = new ArrayList<Edgelet>();
        for (int i = 0; i < edgelets.size(); ++i) {
            if (!(votes.get(i) <= 0.0)) continue;
            ouliers.add(edgelets.get(i));
        }
        return ouliers;
    }

    private static /* synthetic */ double lambda$reestimate_model$8(double[] line) {
        return -line[2];
    }

    private static /* synthetic */ double[][] lambda$reestimate_model$7(int x$0) {
        return new double[x$0][];
    }

    static {
        NativeLibraryLoader.load();
    }

    private static class Edgelet {
        final double[] location;
        final double[] direction;
        final double strength;

        public Edgelet(LinesDetector8.Line line) {
            this.location = new double[]{(line.x1 + line.x2) / 2.0, (line.y1 + line.y2) / 2.0};
            double dx = line.x2 - line.x1;
            double dy = line.y2 - line.y1;
            this.strength = Math.sqrt(dx * dx + dy * dy);
            this.direction = new double[]{dx / this.strength, dy / this.strength};
        }
    }
}

