/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.utils.Converters;
import org.opencv.videoio.VideoCapture;

public class Kmeans {
    private static VideoCapture camera;
    private static final int MAX_ITER = 10;
    private static final int CLUSTERS = 8;

    public static void main(String[] args) {
        JFrame jframe = new JFrame("Kmeans");
        jframe.setResizable(false);
        jframe.setDefaultCloseOperation(3);
        JLabel vidpanel = new JLabel();
        jframe.setContentPane(vidpanel);
        Mat img = new Mat();
        camera.read(img);
        jframe.setSize(img.width(), img.height());
        jframe.setVisible(true);
        while (true) {
            camera.read(img);
            Mat clusters = Kmeans.colorMapKMeans(img, 8);
            ImageIcon image = new ImageIcon(Kmeans.mat2bufferedImage(clusters));
            vidpanel.setIcon(image);
            vidpanel.repaint();
        }
    }

    public static Mat colorMapKMeans(Mat img, int K) {
        Mat m = img.reshape(1, img.rows() * img.cols());
        m.convertTo(m, 5);
        Mat bestLabels = new Mat(m.rows(), 1, 0);
        Mat centroids = new Mat(K, 1, 5);
        Core.kmeans((Mat)m, (int)K, (Mat)bestLabels, (TermCriteria)new TermCriteria(3, 10, 1.0E-5), (int)1, (int)2, (Mat)centroids);
        ArrayList idx = new ArrayList(m.rows());
        Converters.Mat_to_vector_int((Mat)bestLabels, idx);
        Mat imgMapped = new Mat(m.size(), m.type());
        for (int i = 0; i < idx.size(); ++i) {
            Mat row = imgMapped.row(i);
            centroids.row(((Integer)idx.get(i)).intValue()).copyTo(row);
        }
        Mat result = new Mat();
        Mat mat32 = imgMapped.reshape(3, img.rows());
        mat32.convertTo(result, 0);
        return result;
    }

    public static List<Mat> cluster(Mat cutout, int k) {
        Mat samples = cutout.reshape(1, cutout.cols() * cutout.rows());
        Mat samples32f = new Mat();
        samples.convertTo(samples32f, 5, 0.00392156862745098);
        Mat labels = new Mat();
        Mat centers = new Mat();
        Core.kmeans((Mat)samples32f, (int)k, (Mat)labels, (TermCriteria)new TermCriteria(3, 10, 1.0E-5), (int)1, (int)2, (Mat)centers);
        return Kmeans.showClusters(cutout, labels, centers);
    }

    private static List<Mat> showClusters(Mat cutout, Mat labels, Mat centers) {
        centers.convertTo(centers, CvType.CV_8UC1, 255.0);
        centers.reshape(3);
        ArrayList<Mat> clusters = new ArrayList<Mat>();
        for (int i = 0; i < centers.rows(); ++i) {
            clusters.add(Mat.zeros((Size)cutout.size(), (int)cutout.type()));
        }
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        for (int i = 0; i < centers.rows(); ++i) {
            counts.put(i, 0);
        }
        int rows = 0;
        for (int y = 0; y < cutout.rows(); ++y) {
            for (int x = 0; x < cutout.cols(); ++x) {
                int label = (int)labels.get(rows, 0)[0];
                int r = (int)centers.get(label, 2)[0];
                int g = (int)centers.get(label, 1)[0];
                int b = (int)centers.get(label, 0)[0];
                ((Mat)clusters.get(label)).put(y, x, new double[]{b, g, r});
                ++rows;
            }
        }
        return clusters;
    }

    public static BufferedImage mat2bufferedImage(Mat image) {
        MatOfByte bytemat = new MatOfByte();
        Imgcodecs.imencode((String)".jpg", (Mat)image, (MatOfByte)bytemat);
        try {
            return ImageIO.read(new ByteArrayInputStream(bytemat.toArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        NativeLibraryLoader.load();
        camera = new VideoCapture(0);
    }
}

