/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.fht;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.ProjectionLines;
import org.genericsystem.cv.application.RadonTransform;
import org.genericsystem.cv.application.TrajectStep;
import org.genericsystem.cv.application.fht.FHT;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class FHTRadonDemo
extends AbstractApp {
    private GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        FHTRadonDemo.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 1000L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        double y;
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
        }
        Image[] images = new Image[20];
        long ref = System.currentTimeMillis();
        Img binarized = this.frame.adaptativeGaussianInvThreshold(7, 5.0);
        double[] angles = new double[]{-10.0, -25.0, -5.0};
        int count = 0;
        for (int y2 = 100; y2 <= 260; y2 += 80) {
            double angle = angles[count] / 180.0 * Math.PI;
            ++count;
        }
        images[0] = binarized.toJfxImage();
        ref = this.trace("Binarization", ref);
        int stripWidth = 100;
        int vStep = 50;
        Mat vStrip = RadonTransform.extractStrip(binarized.getSrc(), binarized.width() / 2 - stripWidth / 2, stripWidth);
        Mat vStrip2 = RadonTransform.extractStrip(binarized.getSrc(), binarized.width() / 2 - stripWidth / 2 + vStep, stripWidth);
        Mat vStripDisplay = Mat.zeros((Size)binarized.size(), (int)binarized.type());
        Mat roi = new Mat(vStripDisplay, new Range(0, binarized.height()), new Range(binarized.width() / 2 - stripWidth / 2, binarized.width() / 2 + stripWidth / 2));
        vStrip.copyTo(roi);
        images[1] = new Img(vStripDisplay, false).toJfxImage();
        ref = this.trace("Extract strip", ref);
        Mat houghTransform = FHT.fastHoughTransform(vStrip);
        Mat houghTransform2 = FHT.fastHoughTransform(vStrip2);
        Mat houghTransform255 = new Mat();
        Mat houghTransform2552 = new Mat();
        Core.normalize((Mat)houghTransform, (Mat)houghTransform255, (double)0.0, (double)255.0, (int)32);
        Core.normalize((Mat)houghTransform2, (Mat)houghTransform2552, (double)0.0, (double)255.0, (int)32);
        Mat blur = new Mat();
        Imgproc.blur((Mat)houghTransform255, (Mat)blur, (Size)new Size(1.0, 11.0), (Point)new Point(-1.0, -1.0), (int)16);
        images[2] = new Img(blur, false).toJfxImage();
        blur.release();
        images[3] = new Img(houghTransform255, false).toJfxImage();
        ref = this.trace("FHT", ref);
        Mat adaptive = FHT.adaptivHough(houghTransform255, 200);
        Core.normalize((Mat)adaptive, (Mat)adaptive, (double)0.0, (double)255.0, (int)32);
        images[4] = new Img(adaptive, false).toJfxImage();
        adaptive.release();
        ref = this.trace("Adaptive FHT", ref);
        List<TrajectStep> magnitudes = FHT.bestTrajectFHT(houghTransform, 11, -0.2);
        ArrayList<TrajectStep> filteredMagnitudes = new ArrayList<TrajectStep>();
        filteredMagnitudes.add(magnitudes.get(0));
        for (int row = 1; row < magnitudes.size() - 1; ++row) {
            TrajectStep step2 = magnitudes.get(row);
            if (!(step2.magnitude >= 0.2)) continue;
            filteredMagnitudes.add(step2);
        }
        filteredMagnitudes.add(magnitudes.get(magnitudes.size() - 1));
        PolynomialSplineFunction polynomialSplineFunction = new LinearInterpolator().interpolate(filteredMagnitudes.stream().mapToDouble(step -> step.y).toArray(), filteredMagnitudes.stream().mapToDouble(step -> step.derivative).toArray());
        ref = this.trace("FHT traject 1", ref);
        List<TrajectStep> magnitudes2 = FHT.bestTrajectFHT2(houghTransform, 11, 500.0, 30);
        ref = this.trace("FHT traject2", ref);
        PolynomialSplineFunction polynomialSplineFunction2 = new LinearInterpolator().interpolate(magnitudes2.stream().mapToDouble(step -> step.y).toArray(), magnitudes2.stream().mapToDouble(step -> step.derivative).toArray());
        Mat trajectDisplay = Mat.zeros((int)houghTransform.height(), (int)200, (int)CvType.CV_8UC3);
        for (y = 0.0; y < (double)trajectDisplay.height(); y += 1.0) {
            trajectDisplay.put((int)y, (int)(100.0 * polynomialSplineFunction.value(y) + 100.0), new double[]{255.0, 0.0, 0.0});
        }
        for (y = 0.0; y < (double)trajectDisplay.height(); y += 1.0) {
            trajectDisplay.put((int)y, (int)(100.0 * polynomialSplineFunction2.value(y) + 100.0), new double[]{0.0, 0.0, 255.0});
        }
        images[5] = new Img(trajectDisplay, false).toJfxImage();
        ref = this.trace("FHT traject", ref);
        Mat magnitudesDisplay = Mat.zeros((int)magnitudes.size(), (int)255, (int)CvType.CV_8UC1);
        for (TrajectStep step3 : magnitudes) {
            Imgproc.line((Mat)magnitudesDisplay, (Point)new Point(0.0, (double)step3.y), (Point)new Point(step3.magnitude * 255.0, (double)step3.y), (Scalar)new Scalar(255.0));
        }
        images[6] = new Img(magnitudesDisplay, false).toJfxImage();
        ref = this.trace("Display magnitudes", ref);
        List<TrajectStep[]> lines = ProjectionLines.getStripLinesFHT(magnitudes, 0.3, 0.2);
        Mat rangeDisplay = magnitudesDisplay.clone();
        for (TrajectStep[] trajectStepArray : lines) {
            double minMagnitude = Double.MAX_VALUE;
            for (int y3 = trajectStepArray[0].y; y3 <= trajectStepArray[1].y; ++y3) {
                if (!(minMagnitude > magnitudes.get((int)y3).magnitude)) continue;
                minMagnitude = magnitudes.get((int)y3).magnitude;
            }
            Imgproc.line((Mat)rangeDisplay, (Point)new Point(minMagnitude * 255.0, (double)trajectStepArray[0].y), (Point)new Point(minMagnitude * 255.0, (double)trajectStepArray[1].y), (Scalar)new Scalar(0.0), (int)1);
        }
        images[7] = new Img(rangeDisplay, false).toJfxImage();
        ref = this.trace("Display ranged magnitudes", ref);
        Mat vStripColor = new Mat();
        Imgproc.cvtColor((Mat)vStrip, (Mat)vStripColor, (int)8);
        for (TrajectStep[] topBottom : lines) {
            double mag = stripWidth;
            int row = topBottom[0].y;
            double theta = Math.atan(magnitudes.get((int)row).derivative);
            Scalar color = new Scalar(0.0, 255.0, 0.0);
            Imgproc.line((Mat)vStripColor, (Point)new Point((double)(vStripColor.width() / 2) - mag * Math.cos(theta), (double)row - mag * Math.sin(theta)), (Point)new Point((double)(vStripColor.width() / 2) + mag * Math.cos(theta), (double)row + mag * Math.sin(theta)), (Scalar)color, (int)1);
            color = new Scalar(0.0, 0.0, 255.0);
            row = topBottom[1].y;
            theta = Math.atan(magnitudes.get((int)row).derivative);
            Imgproc.line((Mat)vStripColor, (Point)new Point((double)(vStripColor.width() / 2) - mag * Math.cos(theta), (double)row - mag * Math.sin(theta)), (Point)new Point((double)(vStripColor.width() / 2) + mag * Math.cos(theta), (double)row + mag * Math.sin(theta)), (Scalar)color, (int)1);
        }
        Mat mat = Mat.zeros((Size)binarized.size(), (int)vStripColor.type());
        Mat stripRoi = new Mat(mat, new Range(0, mat.height()), new Range(mat.width() / 2 - stripWidth / 2, mat.width() / 2 + stripWidth / 2));
        vStripColor.copyTo(stripRoi);
        images[8] = new Img(mat, false).toJfxImage();
        ref = this.trace("Display underlined strip", ref);
        List<TrajectStep> mags2 = FHT.bestTrajectFHT(houghTransform2, 11, -0.2);
        Double[] magnitudes_ = new Double[binarized.height()];
        Double[] derivatives = new Double[binarized.height()];
        for (int row = 0; row < binarized.height(); ++row) {
            double derivative = mags2.get((int)row).derivative;
            int newy = (int)Math.round(-derivative * (double)vStep + (double)row);
            if (newy < 0 || newy >= binarized.height()) continue;
            derivatives[newy] = derivative;
            magnitudes_[newy] = mags2.get((int)row).magnitude;
        }
        Mat penality = Mat.zeros((int)binarized.height(), (int)(2 * stripWidth - 1), (int)CvType.CV_64FC1);
        for (int row = 0; row < penality.height(); ++row) {
            Double derivative = derivatives[row];
            if (derivative == null) continue;
            double mag = magnitudes_[row];
            for (int col = 0; col < penality.width(); ++col) {
                double angle1 = Math.atan(derivative) * 180.0 / Math.PI;
                double angle2 = Math.atan(((double)col - (double)stripWidth + 1.0) / (double)(stripWidth - 1)) * 180.0 / Math.PI;
                double angleCoeff = Math.abs(angle1 - angle2) / 90.0;
                penality.put(row, col, new double[]{100.0 * mag * angleCoeff});
            }
        }
        images[9] = new Img(penality, false).toJfxImage();
        ref = this.trace("Display influence from second strip", ref);
        Mat newHough = houghTransform255.clone();
        Core.addWeighted((Mat)newHough, (double)1.0, (Mat)penality, (double)-1.0, (double)0.0, (Mat)newHough);
        images[10] = new Img(houghTransform2552, false).toJfxImage();
        ref = this.trace("Display new hough", ref);
        images[11] = new Img(newHough, false).toJfxImage();
        ref = this.trace("Display new hough", ref);
        Mat vTransform = RadonTransform.radonTransform(vStrip, -45, 45);
        Mat vProjection = RadonTransform.radonRemap(vTransform, -45);
        images[12] = new Img(vProjection, false).toJfxImage();
        System.out.println(vProjection);
        Imgproc.morphologyEx((Mat)vProjection, (Mat)vProjection, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(1.0, 2.0)));
        Core.normalize((Mat)vProjection, (Mat)vProjection, (double)0.0, (double)255.0, (int)32);
        ref = this.trace("Radon + Projection", ref);
        images[13] = new Img(vProjection, false).toJfxImage();
        RadonTransform.RadonTrajectStep[] vtraj = RadonTransform.bestTrajectRadon(vProjection, -20.0);
        block11: for (int y4 = 0; y4 < vtraj.length; ++y4) {
            if (vtraj[y4].magnitude != 0.0) continue;
            for (int end = y4 + 1; end < vtraj.length; ++end) {
                if (vtraj[end].magnitude == 0.0) continue;
                for (int current = y4; current < end; ++current) {
                    vtraj[current].theta = vtraj[y4 == 0 ? 0 : y4 - 1].theta + (vtraj[end].theta - vtraj[y4 == 0 ? 0 : y4 - 1].theta) * (current - y4) / (end - y4 + 1);
                }
                y4 = end;
                continue block11;
            }
        }
        Mat vProjectionColor = Mat.zeros((Size)vProjection.size(), (int)CvType.CV_8UC3);
        for (int y5 = 0; y5 < vProjectionColor.height(); ++y5) {
            if (vtraj[y5].magnitude != 0.0) {
                vProjectionColor.put(y5, vtraj[y5].theta, new double[]{255.0, 0.0, 0.0});
                continue;
            }
            vProjectionColor.put(y5, vtraj[y5].theta, new double[]{0.0, 0.0, 255.0});
        }
        ref = this.trace("Best traject radon", ref);
        images[14] = new Img(vProjectionColor, false).toJfxImage();
        return images;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

