/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.genericsystem.cv.Lines;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class DirectionalEnhancer {
    public static Lines getLines(Mat frame) {
        Mat mat = DirectionalEnhancer.prepare(frame);
        Mat houghLines = new Mat();
        Imgproc.HoughLinesP((Mat)mat, (Mat)houghLines, (double)1.0, (double)(Math.PI / 180), (int)10, (double)100.0, (double)10.0);
        mat.release();
        Lines lines = new Lines(houghLines);
        houghLines.release();
        return lines;
    }

    public static void drawFilteredLines(Mat binarized, Lines houghLines) {
        Lines horizontalLines = new Lines(houghLines.getLines().stream().filter(l -> Math.abs(l.y2 - l.y1) < Math.abs(l.x2 - l.x1)).collect(Collectors.toList()));
        horizontalLines.draw(binarized, new Scalar(255.0), 1);
        Lines verticalLines = new Lines(houghLines.getLines().stream().filter(l -> Math.abs(l.y2 - l.y1) > Math.abs(l.x2 - l.x1)).collect(Collectors.toList()));
        verticalLines.draw(binarized, new Scalar(255.0), 1);
    }

    public static Mat prepare(Mat frame) {
        Mat mat = new Mat();
        Imgproc.cvtColor((Mat)frame, (Mat)mat, (int)6);
        Imgproc.GaussianBlur((Mat)mat, (Mat)mat, (Size)new Size(13.0, 13.0), (double)0.0);
        Imgproc.adaptiveThreshold((Mat)mat, (Mat)mat, (double)255.0, (int)0, (int)1, (int)51, (double)2.0);
        Imgproc.morphologyEx((Mat)mat, (Mat)mat, (int)3, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(9.0, 9.0)));
        Imgproc.morphologyEx((Mat)mat, (Mat)mat, (int)2, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(5.0, 5.0)));
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)mat, contours, (Mat)new Mat(), (int)0, (int)2);
        for (MatOfPoint contour : contours) {
            Imgproc.drawContours((Mat)mat, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)-1);
        }
        Imgproc.morphologyEx((Mat)mat, (Mat)mat, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(4.0, 4.0)));
        return mat;
    }
}

