/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.retriever.AbstractFields;
import org.genericsystem.cv.retriever.DocField;
import org.genericsystem.cv.utils.ParallelTasks;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Scalar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocFields
extends AbstractFields<DocField> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DocFields() {
    }

    public DocFields(List<DocField> fields) {
        super(fields);
    }

    public static DocFields of(List<GSRect> rects) {
        DocFields fields = new DocFields();
        fields.buildFields(rects);
        return fields;
    }

    public static DocFields of(JsonObject jsonFields) {
        ArrayList<DocField> list = new ArrayList<DocField>();
        JsonArray array = jsonFields.getJsonArray("fields");
        array.forEach(field -> {
            try {
                list.add((DocField)field);
            }
            catch (Exception e) {
                logger.debug("Unable to cast {} as DocField ({}). Using Json.decodeValue instead.", field, (Object)e.getMessage());
                DocField f = (DocField)Json.decodeValue((String)((JsonObject)field).encode(), DocField.class);
                list.add(f);
            }
        });
        DocFields fields = new DocFields((List<DocField>)list);
        return fields;
    }

    public void buildFields(List<GSRect> rects) {
        int[] counter = new int[]{0};
        this.fields = rects.stream().map(rect -> {
            int n = counter[0];
            counter[0] = n + 1;
            return new DocField(n, (GSRect)rect);
        }).collect(Collectors.toList());
    }

    public Img annotateImage(Img img, double fontScale, Scalar color, int thickness) {
        Img annotated = new Img(img.getSrc(), true);
        this.stream().forEach(field -> field.annotateImage(annotated, fontScale, color, thickness));
        return annotated;
    }

    @Override
    public void performOcr(Img rootImg) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            ParallelTasks tasks = new ParallelTasks();
            for (int i = 0; i < tasks.getCounter(); ++i) {
                if (!it.hasNext()) continue;
                tasks.add(() -> ((DocField)it.next()).ocr(rootImg));
            }
            try {
                tasks.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

