/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.List;

public class VerticalInterpolator {
    private int[] sampleSkewXs;
    private int[] sampleSkewYs;
    private double[][] skewDirs;

    public VerticalInterpolator(List<Integer> patchXs, List<Integer> patchYs, int[][] dirs, int nSide, int nBin) {
        int i;
        this.sampleSkewXs = new int[patchXs.size()];
        for (i = 0; i < patchXs.size(); ++i) {
            this.sampleSkewXs[i] = patchXs.get(i) + nSide / 2;
        }
        this.sampleSkewYs = new int[patchYs.size()];
        for (i = 0; i < patchYs.size(); ++i) {
            this.sampleSkewYs[i] = patchYs.get(i) + nSide / 2;
        }
        this.skewDirs = new double[dirs.length][dirs[0].length];
        for (i = 0; i < this.skewDirs.length; ++i) {
            for (int j = 0; j < this.skewDirs[0].length; ++j) {
                double angle = Math.PI * (double)(dirs[i][j] - 1) / (double)nBin;
                if (angle >= Math.PI) {
                    angle -= Math.PI;
                }
                this.skewDirs[i][j] = angle;
            }
        }
    }

    public double interpolate(double x, double y) {
        LambdaSearchResult xLambda = this.lambdaSearch(this.sampleSkewXs, x);
        LambdaSearchResult yLambda = this.lambdaSearch(this.sampleSkewYs, y);
        double vAngle = (1.0 - xLambda.lambda) * ((1.0 - yLambda.lambda) * this.skewDirs[yLambda.indB][xLambda.indB] + yLambda.lambda * this.skewDirs[yLambda.indE][xLambda.indB]) + xLambda.lambda * ((1.0 - yLambda.lambda) * this.skewDirs[yLambda.indB][xLambda.indE] + yLambda.lambda * this.skewDirs[yLambda.indE][xLambda.indE]);
        return vAngle;
    }

    private LambdaSearchResult lambdaSearch(int[] xs, double x) {
        int indB;
        int indE = 0;
        double lambda = 0.0;
        for (indB = xs.length - 1; indB >= 0 && x < (double)xs[indB]; --indB) {
        }
        if (indB == xs.length - 1) {
            indE = indB;
        } else if (indB == -1) {
            ++indB;
        } else {
            indE = indB + 1;
            lambda = (x - (double)xs[indB]) / (double)(xs[indE] - xs[indB]);
        }
        return new LambdaSearchResult(indB, indE, lambda);
    }

    static class LambdaSearchResult {
        final int indB;
        final int indE;
        final double lambda;

        public LambdaSearchResult(int indB, int indE, double lambda) {
            this.indB = indB;
            this.indE = indE;
            this.lambda = lambda;
        }

        public String toString() {
            return "{ indB: " + this.indB + ", indE: " + this.indE + ", lambda: " + this.lambda + " }";
        }
    }
}

