/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.application.OrientedPoint;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;

public class Segment
implements Comparable<Segment> {
    public final OrientedPoint op1;
    public final OrientedPoint op2;
    private final double distance;

    public Segment(OrientedPoint op1, OrientedPoint op2, double w, boolean vertical) {
        this.op1 = op1;
        this.op2 = op2;
        this.distance = Math.abs(w * op1.derivative / 2.0 + (vertical ? op1.center.x : op1.center.y) - ((vertical ? op2.center.x : op2.center.y) - w * op2.derivative / 2.0));
    }

    public boolean invalidate(Segment selected) {
        return this.op1.equals(selected.op1) || this.op2.equals(selected.op2);
    }

    public double getDistance() {
        return this.distance;
    }

    @Override
    public int compareTo(Segment e) {
        return Double.compare(this.distance, e.distance);
    }

    public static List<List<Segment>>[] connect(List<List<OrientedPoint>[]> trajects, double w, double maxDistanceCoeff, boolean vertical) {
        ArrayList<List<Segment>> topResult = new ArrayList<List<Segment>>();
        ArrayList<List<Segment>> bottomResult = new ArrayList<List<Segment>>();
        for (int i = 0; i < trajects.size() - 1; ++i) {
            List<Segment>[] connectStrips = Segment.connectStrips(trajects.get(i), trajects.get(i + 1), w, maxDistanceCoeff, vertical);
            topResult.add(connectStrips[0]);
            bottomResult.add(connectStrips[1]);
        }
        return new List[]{topResult, bottomResult};
    }

    private static List<Segment>[] connectStrips(List<OrientedPoint>[] traject1, List<OrientedPoint>[] traject2, double w, double maxDistanceCoeff, boolean vertical) {
        ArrayList<Segment> topResult = new ArrayList<Segment>();
        ArrayList<Segment> topSortedFilteredEdges = new ArrayList<Segment>();
        traject1[0].forEach(step1 -> traject2[0].forEach(step2 -> topSortedFilteredEdges.add(new Segment((OrientedPoint)step1, (OrientedPoint)step2, w, vertical))));
        topSortedFilteredEdges.removeIf(edge -> edge.getDistance() > maxDistanceCoeff * w);
        Collections.sort(topSortedFilteredEdges);
        while (!topSortedFilteredEdges.isEmpty()) {
            Segment selected = (Segment)topSortedFilteredEdges.get(0);
            topResult.add(selected);
            topSortedFilteredEdges.removeIf(selected::invalidate);
        }
        ArrayList<Segment> bottomResult = new ArrayList<Segment>();
        ArrayList<Segment> bottomSortedFilteredEdges = new ArrayList<Segment>();
        traject1[1].forEach(step1 -> traject2[1].forEach(step2 -> bottomSortedFilteredEdges.add(new Segment((OrientedPoint)step1, (OrientedPoint)step2, w, vertical))));
        bottomSortedFilteredEdges.removeIf(edge -> edge.getDistance() > maxDistanceCoeff * w);
        Collections.sort(bottomSortedFilteredEdges);
        while (!bottomSortedFilteredEdges.isEmpty()) {
            Segment selected = (Segment)bottomSortedFilteredEdges.get(0);
            bottomResult.add(selected);
            bottomSortedFilteredEdges.removeIf(selected::invalidate);
        }
        return new List[]{topResult, bottomResult};
    }

    public static void displayHorizontalOps(List<List<Segment>> horizontalSegments, Mat img, double vStep, double hStep, Scalar color) {
        horizontalSegments.stream().flatMap(h -> h.stream()).flatMap(edge -> Stream.of(edge.op1, edge.op2)).forEach(op -> op.displayHorizontalOp(img, vStep, hStep, color));
    }

    public static void displayVerticalOps(List<List<Segment>> verticalSegments, Mat img, double vStep, double hStep, Scalar color) {
        verticalSegments.stream().flatMap(h -> h.stream()).flatMap(edge -> Stream.of(edge.op1, edge.op2)).forEach(op -> op.displayVerticalOp(img, vStep, hStep, color));
    }

    public static List<PolynomialSplineFunction>[] toSplines(List<List<Segment>>[] connectedEdges, boolean vertical) {
        List<List<Segment>> topConnectedEdges = connectedEdges[0];
        List<List<Segment>> bottomConnectedEdges = connectedEdges[1];
        return new List[]{Segment.toSplines(topConnectedEdges, vertical), Segment.toSplines(bottomConnectedEdges, vertical)};
    }

    private static List<PolynomialSplineFunction> toSplines(List<List<Segment>> connectedEdges, boolean vertical) {
        ArrayList<ArrayList<OrientedPoint>> orientedPointsSuperList = new ArrayList<ArrayList<OrientedPoint>>();
        for (List<Segment> segments : connectedEdges) {
            block1: for (Segment segment : segments) {
                for (List list : orientedPointsSuperList) {
                    if (!segment.op1.equals(list.get(list.size() - 1))) continue;
                    list.add(segment.op2);
                    continue block1;
                }
                orientedPointsSuperList.add(new ArrayList<OrientedPoint>(Arrays.asList(segment.op1, segment.op2)));
            }
        }
        return orientedPointsSuperList.stream().map(ops -> Segment.toSpline(ops, vertical)).collect(Collectors.toList());
    }

    private static PolynomialSplineFunction toSpline(List<OrientedPoint> orientedPoints, boolean vertical) {
        return new LinearInterpolator().interpolate(orientedPoints.stream().mapToDouble(op -> vertical ? op.center.y : op.center.x).toArray(), orientedPoints.stream().mapToDouble(op -> vertical ? op.center.x : op.center.y).toArray());
    }
}

