/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class SliderChangeLog
extends Application {
    private final ListView<String> startLog = new ListView();
    private final ListView<String> endLog = new ListView();

    public void start(Stage stage) throws Exception {
        HBox logsPane = this.createLogsPane();
        Slider slider = this.createMonitoredSlider();
        VBox layout = new VBox(10.0);
        layout.setAlignment(Pos.CENTER);
        layout.setPadding(new Insets(10.0));
        layout.getChildren().setAll((Object[])new Node[]{slider, logsPane});
        VBox.setVgrow((Node)logsPane, (Priority)Priority.ALWAYS);
        stage.setTitle("Slider Value Change Logger");
        stage.setScene(new Scene((Parent)layout));
        stage.show();
    }

    private Slider createMonitoredSlider() {
        final Slider slider = new Slider(0.0, 1.0, 0.5);
        slider.setMajorTickUnit(0.5);
        slider.setMinorTickCount(0);
        slider.setShowTickMarks(true);
        slider.setShowTickLabels(true);
        slider.setMinHeight(Double.NEGATIVE_INFINITY);
        slider.valueChangingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean wasChanging, Boolean changing) {
                String valueString = String.format("%1$.3f", slider.getValue());
                if (changing.booleanValue()) {
                    SliderChangeLog.this.startLog.getItems().add((Object)valueString);
                } else {
                    SliderChangeLog.this.endLog.getItems().add((Object)valueString);
                }
            }
        });
        return slider;
    }

    private HBox createLogsPane() {
        HBox logs = new HBox(10.0);
        logs.getChildren().addAll((Object[])new Node[]{this.createLabeledLog("Start", this.startLog), this.createLabeledLog("End", this.endLog)});
        return logs;
    }

    public Pane createLabeledLog(String logName, ListView<String> log) {
        Label label = new Label(logName);
        label.setLabelFor(log);
        VBox logPane = new VBox(5.0);
        logPane.getChildren().setAll((Object[])new Node[]{label, log});
        logPane.setAlignment(Pos.TOP_LEFT);
        return logPane;
    }

    public static void main(String[] args) {
        SliderChangeLog.launch((String[])args);
    }
}

