/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class Lines {
    private final List<Line> lines;

    public Lines(Mat src) {
        this.lines = new ArrayList<Line>();
        for (int i = 0; i < src.rows(); ++i) {
            double[] val = src.get(i, 0);
            Line line = new Line(val[0], val[1], val[2], val[3]);
            this.getLines().add(line);
        }
    }

    public Lines filter(Predicate<Line> predicate) {
        return new Lines(this.getLines().stream().filter(predicate).collect(Collectors.toList()));
    }

    public Lines reduce(int max) {
        if (this.getLines().size() <= max) {
            return this;
        }
        HashSet<Line> newLines = new HashSet<Line>();
        while (newLines.size() < max) {
            newLines.add(this.getLines().get((int)(Math.random() * (double)this.size())));
        }
        return new Lines(newLines);
    }

    public Lines(Collection<Line> lines) {
        this.lines = new ArrayList<Line>(lines);
    }

    public Lines rotate(Mat matrix) {
        return new Lines(this.getLines().stream().map(line -> line.transform(matrix)).collect(Collectors.toList()));
    }

    public Lines perspectivTransform(Mat matrix) {
        return new Lines(this.getLines().stream().map(line -> line.perspectivTransform(matrix)).collect(Collectors.toList()));
    }

    public void draw(Mat frame, Scalar color, int thickness) {
        this.getLines().forEach(line -> line.draw(frame, color, thickness));
    }

    public int size() {
        return this.getLines().size();
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public static class Line {
        public final double x1;
        public final double x2;
        public final double y1;
        public final double y2;

        public Line(Point p1, Point p2) {
            this(p1.x, p1.y, p2.x, p2.y);
        }

        public Line(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }

        public double size() {
            return Math.sqrt(Math.pow(this.y2 - this.y1, 2.0) + Math.pow(this.x2 - this.x1, 2.0));
        }

        public Line transform(Mat rotationMatrix) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.transform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)rotationMatrix);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public Line perspectivTransform(Mat homography) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.perspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)homography);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public void draw(Mat frame, Scalar color, int thickness) {
            Imgproc.line((Mat)frame, (Point)new Point(this.x1, this.y1), (Point)new Point(this.x2, this.y2), (Scalar)color, (int)thickness);
        }
    }
}

