/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.params;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class ParamsPanel
extends VBox {
    private Map<String, SimpleDoubleProperty> model = new HashMap<String, SimpleDoubleProperty>();

    public DoubleProperty addProperty(String name, double value) {
        SimpleDoubleProperty property = new SimpleDoubleProperty(value);
        this.model.put(name, new SimpleDoubleProperty(value));
        return property;
    }

    public DoubleProperty addSliderProperty(String propertyName, double value, double min, double max) {
        DoubleProperty property = this.addProperty(propertyName, value);
        HBox hbox = new HBox();
        Label label = new Label(propertyName);
        Slider slider = new Slider(min, max, value);
        Label valueLabel = new Label(Objects.toString(value));
        property.addListener((ov, oldV, newV) -> {
            valueLabel.setText(Objects.toString(newV));
            System.out.println(propertyName + " " + newV);
        });
        slider.setShowTickLabels(true);
        slider.setShowTickMarks(true);
        slider.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (!slider.isValueChanging()) {
                property.setValue(newValue);
            }
        });
        slider.valueChangingProperty().addListener((ov, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                property.setValue((Number)slider.getValue());
            }
        });
        hbox.getChildren().add((Object)label);
        hbox.getChildren().add((Object)slider);
        hbox.getChildren().add((Object)valueLabel);
        this.getChildren().add((Object)hbox);
        return property;
    }
}

