/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.nn;

import java.io.File;
import java.io.IOException;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class ExistingMiniBatchMultiDataSetIterator
implements MultiDataSetIterator {
    public static final String DEFAULT_PATTERN = "dataset-%d.bin";
    private int currIdx;
    private File rootDir;
    private int totalBatches = -1;
    private MultiDataSetPreProcessor multiDataSetPreProcessor;
    private final String pattern;

    public ExistingMiniBatchMultiDataSetIterator(File rootDir) {
        this(rootDir, DEFAULT_PATTERN);
    }

    public ExistingMiniBatchMultiDataSetIterator(File rootDir, String pattern) {
        this.rootDir = rootDir;
        rootDir.mkdirs();
        this.totalBatches = rootDir.list().length;
        this.pattern = pattern;
    }

    public MultiDataSet next(int num) {
        throw new UnsupportedOperationException("Unable to load custom number of examples");
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        this.currIdx = 0;
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.multiDataSetPreProcessor = preProcessor;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.multiDataSetPreProcessor;
    }

    public boolean hasNext() {
        return this.currIdx < this.totalBatches;
    }

    public void remove() {
    }

    public MultiDataSet next() {
        try {
            MultiDataSet ret = this.read(this.currIdx);
            if (this.multiDataSetPreProcessor != null) {
                this.multiDataSetPreProcessor.preProcess((org.nd4j.linalg.dataset.api.MultiDataSet)ret);
            }
            ++this.currIdx;
            return ret;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read dataset");
        }
    }

    private MultiDataSet read(int idx) throws IOException {
        File path = new File(this.rootDir, String.format(this.pattern, idx));
        MultiDataSet d = new MultiDataSet();
        d.load(path);
        return d;
    }
}

