/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.newmodel;

import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.common.Root;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.newmodel.SimpleModel;
import org.genericsystem.cv.retriever.DocFields;
import org.genericsystem.cv.utils.ClassifierUsingFields;
import org.genericsystem.cv.utils.Deskewer;
import org.genericsystem.cv.utils.ImgFilterFunction;
import org.genericsystem.cv.utils.ImgFunction;
import org.genericsystem.cv.utils.ModelTools;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.RectToolsMapper;
import org.genericsystem.kernel.Engine;
import org.genericsystem.reinforcer.tools.GSRect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillNewModelWithData {
    private static final String DOC_PATH = "docPath";
    private static final String FILENAME = "filename";
    private static final String ENCODED_FILENAME = "encodedFilename";
    private static final String DOC_TIMESTAMP = "docTimestamp";
    private static final String ZONES = "zones";
    private static final String FIELD_NUM = "fieldNum";
    private static final String RECT = "rectangle";
    private static final String CONSOLIDATED = "consolidated";
    private static final Logger logger;
    private static final String gsPath;

    public static void main(String[] args) {
        Path basePath = Paths.get(System.getenv("HOME") + "/genericsystem/gs-ir-files/", new String[0]);
        Path filePath = basePath.resolve(Paths.get("converted-png", "image-1094900021964925380-0.png"));
        Path deskewedPath = Deskewer.deskewAndSave(filePath, Deskewer.METHOD.HOUGH_LINES);
        JsonObject jsonFields = FillNewModelWithData.detectFields(deskewedPath);
        System.out.println(jsonFields.encodePrettily());
        JsonObject data = FillNewModelWithData.processFile(basePath.relativize(deskewedPath), basePath, jsonFields);
        System.out.println(data.encodePrettily());
        Root engine = FillNewModelWithData.getEngine(gsPath);
        FillNewModelWithData.saveOcrDataInModel(engine, data);
        engine.close();
    }

    public static Root getEngine(String gsPath) {
        return new Engine(gsPath, new Class[]{SimpleModel.DocClassType.class, SimpleModel.LayoutType.class, SimpleModel.ImgDocRel.class, SimpleModel.DocType.class, SimpleModel.ImgType.class, SimpleModel.ZoneType.class, SimpleModel.ZoneNumType.class, SimpleModel.ConsolidatedType.class, SimpleModel.ImgPathType.class, SimpleModel.ImgTimestampType.class, SimpleModel.ImgRefreshTimestampType.class, SimpleModel.SupervisedType.class});
    }

    public static boolean registerNewFile(Root engine, Path relativeImgPath, Path basePath, Path resourcesFolder) {
        logger.info("Adding a new image ({}) ", (Object)relativeImgPath.getFileName());
        Path absolutePath = basePath.resolve(relativeImgPath);
        String filenameExt = ModelTools.generateFileName(absolutePath);
        SimpleModel.ImgType imgType = (SimpleModel.ImgType)engine.find(SimpleModel.ImgType.class);
        try {
            SimpleModel.ImgType.ImgInstance imgInstance = imgType.addImg(filenameExt);
            engine.getCurrentCache().flush();
            if (null == imgInstance) {
                logger.error("An error has occured while saving file {}", (Object)filenameExt);
                return false;
            }
            imgInstance.setImgPath(relativeImgPath.toString());
            imgInstance.setImgTimestamp(ModelTools.getCurrentDate());
            engine.getCurrentCache().flush();
            try {
                Files.copy(absolutePath, resourcesFolder.resolve(filenameExt), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                logger.error(String.format("An error has occured while copying image %s to resources folder", filenameExt), (Throwable)e);
            }
            return true;
        }
        catch (RollbackException e) {
            logger.warn("The image {} has already been saved in Generic System", (Object)relativeImgPath.getFileName());
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject detectFields(Path imgPath) {
        try (Img deskewed = new Img(imgPath.toString());){
            JsonObject result;
            List<GSRect> rects = RectToolsMapper.rectToGSRect(ClassifierUsingFields.detectRects(deskewed));
            DocFields fields = DocFields.of(rects);
            JsonObject jsonObject = result = fields.toJsonObject();
            return jsonObject;
        }
        catch (Exception e) {
            throw new IllegalStateException("An error has occured while detecting the fields on file " + imgPath.toString(), e);
        }
    }

    public static JsonObject processFile(Path relativeImgPath, Path basePath, JsonObject jsonFields) {
        Path absolutePath = basePath.resolve(relativeImgPath);
        JsonObject jsonObject = new JsonObject();
        jsonObject.put(FILENAME, relativeImgPath.getFileName().toString());
        jsonObject.put(ENCODED_FILENAME, ModelTools.generateFileName(absolutePath));
        jsonObject.put(DOC_TIMESTAMP, ModelTools.getCurrentDate());
        jsonObject.put(DOC_PATH, relativeImgPath.toString());
        DocFields fields = DocFields.of(jsonFields);
        Img deskewed = new Img(absolutePath.toString());
        List<ImgFilterFunction> imgFilterFunctions = FillNewModelWithData.getFilterFunctions();
        ConcurrentHashMap imgs = new ConcurrentHashMap(imgFilterFunctions.size() + 1);
        imgFilterFunctions.forEach(entry -> {
            String filtername = entry.getName();
            ImgFunction function = entry.getLambda();
            logger.info("Applying algorithm {}...", (Object)filtername);
            Img img = null;
            long start = System.nanoTime();
            img = "original".equals(filtername) || "reality".equals(filtername) ? new Img(deskewed.getSrc(), true) : (Img)function.apply(deskewed);
            long stop = System.nanoTime();
            logger.info("({} ms)", (Object)((stop - start) / 1000000L));
            if (null != img) {
                imgs.put(filtername, img);
            } else {
                logger.error("An error as occured for image {} and filter {}", (Object)relativeImgPath.getFileName(), (Object)filtername);
            }
        });
        ConcurrentHashMap result = new ConcurrentHashMap(fields.size() + 1);
        fields.forEach(field -> {
            logger.info("Field {}", (Object)field.getNum());
            imgs.entrySet().forEach(entry -> {
                if (!"reality".equals(entry.getKey()) && !"best".equals(entry.getKey())) {
                    field.ocr((Img)entry.getValue());
                }
            });
            field.consolidateOcr();
            JsonObject json = new JsonObject();
            json.put(FIELD_NUM, Integer.valueOf(field.getNum()));
            json.put(CONSOLIDATED, field.getConsolidated());
            json.put(RECT, JsonObject.mapFrom((Object)field.getRect()));
            result.put(field.getUid(), json);
        });
        jsonObject.put(ZONES, result);
        deskewed.close();
        imgs.values().forEach(Img::close);
        return jsonObject;
    }

    public static void saveOcrDataInModel(Root engine, JsonObject data) {
        SimpleModel.ImgType.ImgInstance imgInstance;
        String docPath = data.getString(DOC_PATH);
        String filenameExt = data.getString(ENCODED_FILENAME);
        Long timestamp = data.getLong(DOC_TIMESTAMP);
        JsonObject zonesResults = data.getJsonObject(ZONES);
        SimpleModel.ImgType imgType = (SimpleModel.ImgType)engine.find(SimpleModel.ImgType.class);
        try {
            imgInstance = imgType.addImg(filenameExt);
        }
        catch (RollbackException e1) {
            logger.info(String.format("File %s has already been processed by the system. Retrieving the reference...", filenameExt));
            imgInstance = imgType.getImg(filenameExt);
        }
        try {
            imgInstance.setImgPath(docPath);
            imgInstance.setImgTimestamp(timestamp);
            imgInstance.setImgRefreshTimestamp(timestamp);
        }
        catch (RollbackException e) {
            logger.debug("Filename or timestamp have already been set. Resuming task...");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : zonesResults) {
            logger.info("Current zone: {}", entry.getKey());
            JsonObject field = (JsonObject)entry.getValue();
            String ocr = field.getString(CONSOLIDATED);
            String rect = field.getJsonObject(RECT).encode();
            int num = field.getInteger(FIELD_NUM);
            SimpleModel.ZoneType.ZoneInstance zoneInstance = imgInstance.getZone(rect);
            if (null == zoneInstance) {
                zoneInstance = imgInstance.addZone(rect);
            } else {
                logger.debug("Zone {} already known. Override consolidated ('{}' with '{}') and zone num ('{}' with '{}')", new Object[]{entry.getKey(), zoneInstance.getConsolidated(), ocr, zoneInstance.getZoneNum(), num});
            }
            zoneInstance.setConsolidated(ocr);
            if (zoneInstance.getSupervised() == null) {
                zoneInstance.setSupervised("");
            }
            zoneInstance.setZoneNum(num);
        }
        engine.getCurrentCache().flush();
    }

    public static void linkImgToDocClass(Root engine, Path filePath, String defaultClassName) {
        SimpleModel.ImgDocRel.ImgDocLink imgDocLink;
        String name = ModelTools.generateFileName(filePath);
        SimpleModel.DocClassType docClassType = (SimpleModel.DocClassType)engine.find(SimpleModel.DocClassType.class);
        SimpleModel.ImgType imgType = (SimpleModel.ImgType)engine.find(SimpleModel.ImgType.class);
        SimpleModel.ImgType.ImgInstance imgInstance = imgType.getImg(name);
        SimpleModel.DocClassType.DocClassInstance defaultDocClass = docClassType.getDocClass(defaultClassName);
        if (null == defaultDocClass) {
            logger.info("Default class {} does not exist. Creating...", (Object)defaultClassName);
            defaultDocClass = docClassType.addDocClass(defaultClassName);
        }
        if (null == (imgDocLink = imgInstance.getImgDocLink())) {
            SimpleModel.DocType.DocInstance docInstance = defaultDocClass.addDocInstance(name);
            docInstance.addImgDocLink(name, imgInstance);
        } else {
            logger.info("Img {} is already in class {}", (Object)name, (Object)imgDocLink.getDocInstance().getDocClassInstance());
        }
    }

    public static List<ImgFilterFunction> getFilterFunctions() {
        ArrayList<ImgFilterFunction> filterList = new ArrayList<ImgFilterFunction>();
        for (ImgFilterFunction iff : ImgFilterFunction.values()) {
            logger.info("Adding: {}", (Object)iff);
            filterList.add(iff);
        }
        return filterList;
    }

    static {
        NativeLibraryLoader.load();
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        gsPath = System.getenv("HOME") + "/genericsystem/gs-cv-newmodel";
    }
}

