/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.cv.ImgClass;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.calib3d.Calib3d;
import org.opencv.core.DMatch;
import org.opencv.core.KeyPoint;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDMatch;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.features2d.DescriptorExtractor;
import org.opencv.features2d.DescriptorMatcher;
import org.opencv.features2d.FeatureDetector;
import org.opencv.features2d.Features2d;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Classifier {
    private static final Logger logger = LoggerFactory.getLogger(Classifier.class);
    public static final int MATCHING_THRESHOLD = 150;
    private static final String pngDirectoryPath = "png";
    private static final String classesDirectoryPath = "classes";
    private static final FeatureDetector[] featureDetectors;
    private static final DescriptorExtractor[] descriptorExtractors;

    public static void main(String[] args) {
        Path classesDirectory = Paths.get(classesDirectoryPath, new String[0]);
        Arrays.stream(new File(pngDirectoryPath).listFiles()).filter(img -> img.getName().endsWith(".png")).forEach(imgFile -> Classifier.classify(classesDirectory, imgFile.toPath(), featureDetectors, descriptorExtractors));
    }

    public static Mat compareFeature(String filename1, String filename2, int matching_threshold, FeatureDetector featureDetector, DescriptorExtractor descriptorExtractor) {
        Mat img1 = Imgcodecs.imread((String)filename1, (int)1);
        Mat img2 = Imgcodecs.imread((String)filename2, (int)1);
        CompareFeatureResult result = Classifier.compareFeature(img1, img2, matching_threshold, featureDetector, descriptorExtractor);
        img1.release();
        img2.release();
        return result != null ? result.getImg() : null;
    }

    public static Path classify(Path classesDirectory, Path imgFile) {
        return Classifier.classify(classesDirectory, imgFile, featureDetectors, descriptorExtractors);
    }

    /*
     * Exception decompiling
     */
    public static Path classify(Path classesDirectory, Path imgFile, FeatureDetector[] featureDetectors, DescriptorExtractor[] descriptorExtractors) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CompareFeatureResult selectBestClass(Path classesDirectory, Mat img, FeatureDetector[] featureDetectors, DescriptorExtractor[] descriptorExtractors) {
        int[] matchingThresholds = new int[]{30};
        HashMap<String, ArrayList<Object>> resultsPerClass = new HashMap<String, ArrayList<Object>>();
        for (int i = 0; i < matchingThresholds.length; ++i) {
            CompareFeatureResult algoResult = Classifier.selectBestClass(classesDirectory, img, matchingThresholds[i], featureDetectors[i], descriptorExtractors[i]);
            if (algoResult == null) continue;
            String className = algoResult.getImgClass().getDirectory();
            ArrayList<Object> classResults = (ArrayList<Object>)resultsPerClass.get(className);
            if (classResults == null) {
                classResults = new ArrayList<Object>();
            }
            classResults.add(algoResult);
            resultsPerClass.put(className, classResults);
        }
        List bestResults = new ArrayList();
        for (Map.Entry entry : resultsPerClass.entrySet()) {
            List results = (List)entry.getValue();
            Collections.sort(results);
            if (results.size() <= bestResults.size() && (results.size() != bestResults.size() || ((CompareFeatureResult)results.get(0)).getMatchingCount() <= ((CompareFeatureResult)bestResults.get(0)).getMatchingCount())) continue;
            bestResults = (List)entry.getValue();
        }
        ArrayList bestResults_ = bestResults;
        resultsPerClass.values().forEach(list -> {
            if (list != bestResults_) {
                list.forEach(c -> c.close());
            }
        });
        bestResults.subList(1, bestResults.size()).forEach(c -> c.close());
        if (bestResults.size() < (matchingThresholds.length + 1) / 2) {
            return null;
        }
        return (CompareFeatureResult)bestResults.get(0);
    }

    public static CompareFeatureResult selectBestClass(Path classesDirectory, Mat img, int matching_threshold, FeatureDetector detector, DescriptorExtractor extractor) {
        CompareFeatureResult result = null;
        MatOfKeyPoint keypoints1 = null;
        Mat descriptors1 = null;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(classesDirectory, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            keypoints1 = Classifier.getKeyPoints(img, detector);
            descriptors1 = Classifier.getDescriptors(img, keypoints1, extractor);
            for (Path path : directoryStream) {
                ImgClass imgClass = new ImgClass(path.toString());
                Throwable throwable = null;
                try {
                    CompareFeatureResult classResult = Classifier.compareFeature(img, keypoints1, descriptors1, imgClass, matching_threshold, detector, extractor);
                    if (classResult == null) continue;
                    if (result == null) {
                        result = classResult;
                        continue;
                    }
                    if (classResult.compareTo(result) < 0) {
                        result.close();
                        result = classResult;
                        continue;
                    }
                    classResult.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (imgClass == null) continue;
                    if (throwable != null) {
                        try {
                            imgClass.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    imgClass.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            keypoints1.release();
            descriptors1.release();
        }
        return result;
    }

    public static Mat compareFeature(Mat img1, Mat img2, int matching_threshold) {
        CompareFeatureResult result = Classifier.compareFeature(img1, img2, matching_threshold, FeatureDetector.create((int)2011), DescriptorExtractor.create((int)1003));
        return result != null ? result.getImg() : null;
    }

    public static CompareFeatureResult compareFeature(Mat img1, MatOfKeyPoint keypoints1, Mat descriptors1, ImgClass imgClass, int matchingThreshold, FeatureDetector featureDetector, DescriptorExtractor descriptorExtractor) {
        CompareFeatureResult result = Classifier.compareFeature(img1, keypoints1, descriptors1, imgClass.getClassModel() != null ? imgClass.getClassModel().getSrc() : imgClass.getMean().getSrc(), matchingThreshold, featureDetector, descriptorExtractor);
        if (result != null) {
            result.setImgClass(imgClass);
        }
        return result;
    }

    public static CompareFeatureResult compareFeature(Mat img1, Mat img2, int matchingThreshold, FeatureDetector featureDetector, DescriptorExtractor descriptorExtractor) {
        MatOfKeyPoint keypoints1 = Classifier.getKeyPoints(img1, featureDetector);
        Mat descriptors1 = Classifier.getDescriptors(img1, keypoints1, descriptorExtractor);
        CompareFeatureResult result = Classifier.compareFeature(img1, keypoints1, descriptors1, img2, matchingThreshold, featureDetector, descriptorExtractor);
        keypoints1.release();
        descriptors1.release();
        return result;
    }

    private static CompareFeatureResult compareFeature(Mat img1, MatOfKeyPoint keypoints1, Mat descriptors1, Mat img2, int matchingThreshold, FeatureDetector featureDetector, DescriptorExtractor descriptorExtractor) {
        MatOfKeyPoint keypoints2 = Classifier.getKeyPoints(img2, featureDetector);
        Mat descriptors2 = Classifier.getDescriptors(img2, keypoints2, descriptorExtractor);
        CompareFeatureResult result = null;
        if (descriptors2.cols() == descriptors1.cols()) {
            DescriptorMatcher matcher = DescriptorMatcher.create((int)4);
            MatOfDMatch matches = new MatOfDMatch();
            matcher.match(descriptors1, descriptors2, matches);
            DMatch[] match = matches.toArray();
            matches.release();
            double max_dist = 0.0;
            double min_dist = 100.0;
            for (int i = 0; i < descriptors1.rows(); ++i) {
                double dist = match[i].distance;
                if (dist < min_dist) {
                    min_dist = dist;
                }
                if (!(dist > max_dist)) continue;
                max_dist = dist;
            }
            ArrayList<DMatch> goodMatches = new ArrayList<DMatch>();
            for (int i = 0; i < descriptors1.rows(); ++i) {
                if (!(match[i].distance <= 30.0f)) continue;
                goodMatches.add(match[i]);
            }
            if (goodMatches.size() > matchingThreshold) {
                Mat imgMatches = new Mat();
                MatOfDMatch matOfDMatch = new MatOfDMatch((DMatch[])goodMatches.stream().toArray(DMatch[]::new));
                Features2d.drawMatches((Mat)img1, (MatOfKeyPoint)keypoints1, (Mat)img2, (MatOfKeyPoint)keypoints2, (MatOfDMatch)matOfDMatch, (Mat)imgMatches);
                imgMatches.release();
                matOfDMatch.release();
                ArrayList<Point> objectPoints = new ArrayList<Point>();
                ArrayList<Point> scenePoints = new ArrayList<Point>();
                for (DMatch goodMatch : goodMatches) {
                    objectPoints.add(((KeyPoint)keypoints1.toList().get((int)goodMatch.queryIdx)).pt);
                    scenePoints.add(((KeyPoint)keypoints2.toList().get((int)goodMatch.trainIdx)).pt);
                }
                MatOfPoint2f objectPointsMat = new MatOfPoint2f((Point[])objectPoints.stream().toArray(Point[]::new));
                MatOfPoint2f scenePointsMat = new MatOfPoint2f((Point[])scenePoints.stream().toArray(Point[]::new));
                Mat homography = Calib3d.findHomography((MatOfPoint2f)objectPointsMat, (MatOfPoint2f)scenePointsMat, (int)8, (double)10.0);
                objectPointsMat.release();
                scenePointsMat.release();
                Mat transformedImage = new Mat();
                if (homography.rows() == 3 && homography.cols() == 3) {
                    Imgproc.warpPerspective((Mat)img1, (Mat)transformedImage, (Mat)homography, (Size)new Size((double)img2.cols(), (double)img2.rows()));
                    result = new CompareFeatureResult(transformedImage, goodMatches.size());
                    homography.release();
                    logger.debug("----------------- possible match found, threshold: {}, goodMatches: {}.", (Object)matchingThreshold, (Object)goodMatches.size());
                } else {
                    logger.debug("----------------- unable to find a correct homography");
                }
            } else {
                logger.debug("----------------- not a match, threshold: {}, goodMatches: {}.", (Object)matchingThreshold, (Object)goodMatches.size());
            }
        }
        keypoints2.release();
        descriptors2.release();
        return result;
    }

    public static MatOfKeyPoint getKeyPoints(Mat img, FeatureDetector detector) {
        MatOfKeyPoint keypoints = new MatOfKeyPoint();
        detector.detect(img, keypoints);
        return keypoints;
    }

    public static Mat getDescriptors(Mat img, MatOfKeyPoint keypoints, DescriptorExtractor extractor) {
        Mat descriptors = new Mat();
        extractor.compute(img, keypoints, descriptors);
        return descriptors;
    }

    static {
        NativeLibraryLoader.load();
        featureDetectors = new FeatureDetector[]{FeatureDetector.create((int)11)};
        descriptorExtractors = new DescriptorExtractor[]{DescriptorExtractor.create((int)1003)};
    }

    public static class CompareFeatureResult
    implements Comparable<CompareFeatureResult>,
    AutoCloseable {
        private final Mat img;
        private ImgClass imgClass;
        private final int matchingCount;

        public CompareFeatureResult(Mat img, int matchingCount) {
            this.img = img;
            this.matchingCount = matchingCount;
        }

        public Mat getImg() {
            return this.img;
        }

        public ImgClass getImgClass() {
            return this.imgClass;
        }

        public int getMatchingCount() {
            return this.matchingCount;
        }

        public void setImgClass(ImgClass imgClass) {
            this.imgClass = imgClass;
        }

        @Override
        public int compareTo(CompareFeatureResult o) {
            return o.matchingCount - this.matchingCount;
        }

        public String toString() {
            return "CompareFeatureResult, matchingCount: " + this.matchingCount + ", imgClass: " + this.imgClass.getDirectory();
        }

        @Override
        public void close() {
            this.img.release();
            this.imgClass.close();
        }
    }
}

