/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.reinforcer.tools.Levenshtein;

public class Scores {
    private final Map<String, Integer> ocrs = new HashMap<String, Integer>();
    private final List<String> ocrs2 = new ArrayList<String>();
    private final Map<String, String> ocrResults = new HashMap<String, String>();
    private Integer minLevenshtein;
    private String realText;

    public void put(String s) {
        Integer count = this.ocrs.get(s);
        this.ocrs.put(s, 1 + (count != null ? count : 0));
        this.ocrs2.add(s);
    }

    public void put(String filtername, String ocr) {
        this.ocrResults.put(filtername, ocr);
    }

    public Map<String, Integer> getResultsMap() {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        int shorterDistance = Integer.MAX_VALUE;
        for (Map.Entry<String, String> entry : this.ocrResults.entrySet()) {
            int dist = 0;
            for (Map.Entry<String, String> entry2 : this.ocrResults.entrySet()) {
                dist += Levenshtein.distance((String)entry.getValue(), (String)entry2.getValue());
            }
            results.put(entry.getKey(), dist);
            if (dist >= shorterDistance) continue;
            shorterDistance = dist;
        }
        this.minLevenshtein = shorterDistance;
        return results;
    }

    public Map<String, Integer> getSupervisedResultsMap() {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        if (this.realText != null && !this.realText.isEmpty()) {
            System.out.println("Trained data found! Using supervised training");
            for (Map.Entry<String, String> entry : this.ocrResults.entrySet()) {
                int dist = Levenshtein.distance((String)entry.getValue().replaceAll("[ .,]", "").trim(), (String)this.realText.replaceAll("[ .,]", "").trim());
                results.put(entry.getKey(), dist);
            }
        } else {
            System.out.println("Unable to find the zone! Using unsupervised training");
            return this.getResultsMap();
        }
        return results;
    }

    public Integer getMinLevenshtein() {
        return this.minLevenshtein;
    }

    public double getBestScore() {
        int bestScore = 0;
        int allOcrs = 0;
        for (Map.Entry<String, Integer> entry : this.ocrs.entrySet()) {
            allOcrs += entry.getValue().intValue();
            if (bestScore >= entry.getValue()) continue;
            bestScore = entry.getValue();
        }
        return Integer.valueOf(bestScore).doubleValue() / (double)allOcrs;
    }

    public String getBestText() {
        String bestText = "";
        int bestScore = 0;
        for (Map.Entry<String, Integer> entry : this.ocrs.entrySet()) {
            if (bestScore >= entry.getValue()) continue;
            bestScore = entry.getValue();
            bestText = entry.getKey();
        }
        return bestText;
    }

    public String getBestText2() {
        String bestText = "";
        int shorterDistance = Integer.MAX_VALUE;
        for (String key : this.ocrs2) {
            if ("".equals(key)) continue;
            int d = 0;
            for (String key2 : this.ocrs2) {
                d += Levenshtein.distance((String)key, (String)key2);
            }
            if (d >= shorterDistance) continue;
            bestText = key;
            shorterDistance = d;
        }
        return bestText;
    }

    public String getRealText() {
        return this.realText;
    }

    public void setRealText(String realText) {
        this.realText = realText;
    }
}

