/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.fht;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.application.GeneralInterpolator;
import org.genericsystem.cv.application.OrientedPoint;
import org.genericsystem.cv.application.ProjectionLines;
import org.genericsystem.cv.application.Segment;
import org.genericsystem.cv.application.SplineInterpolator;
import org.genericsystem.cv.application.TrajectStep;
import org.genericsystem.cv.application.fht.FHT;
import org.genericsystem.cv.application.mesh.MeshManager;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Size;

public class FHTManager {
    private IntegerProperty vBlurSize = new SimpleIntegerProperty(81);
    private IntegerProperty hBlurSize = new SimpleIntegerProperty(81);
    private DoubleProperty vAnglePenality = new SimpleDoubleProperty(-0.12);
    private DoubleProperty hAnglePenality = new SimpleDoubleProperty(-0.12);
    private DoubleProperty vRecover = new SimpleDoubleProperty(0.6);
    private DoubleProperty hRecover = new SimpleDoubleProperty(0.6);
    private IntegerProperty vStripsNumber = new SimpleIntegerProperty(16);
    private IntegerProperty hStripsNumber = new SimpleIntegerProperty(10);
    private DoubleBinding stripWidth;
    private DoubleBinding stripHeight;
    private DoubleBinding vStep;
    private DoubleBinding hStep;
    private DoubleProperty vLocalThreshold = new SimpleDoubleProperty(0.5);
    private DoubleProperty vGlobalThreshold = new SimpleDoubleProperty(0.05);
    private DoubleProperty hLocalThreshold = new SimpleDoubleProperty(0.5);
    private DoubleProperty hGlobalThreshold = new SimpleDoubleProperty(0.05);
    private DoubleProperty hMaxConnectDistance = new SimpleDoubleProperty(0.05);
    private DoubleProperty vMaxConnectDistance = new SimpleDoubleProperty(0.05);
    private DoubleProperty interpolatorPow = new SimpleDoubleProperty(4.0);
    private DoubleProperty interpolatorMinDist = new SimpleDoubleProperty(1.0E-4);
    private IntegerProperty halfGridWidth = new SimpleIntegerProperty(8);
    private IntegerProperty halfGridHeight = new SimpleIntegerProperty(8);
    private DoubleProperty focale;
    private final Size binarySize;
    private Mat binarized;
    private Mat transposedBinarized;
    private List<Mat> vStrips;
    private List<Mat> hStrips;
    private List<Mat> vHoughs;
    private List<Mat> hHoughs;
    private List<List<TrajectStep>> vHoughTrajs;
    private List<List<TrajectStep>> hHoughTrajs;
    private List<List<OrientedPoint>[]> fhtHorizontals;
    private List<List<OrientedPoint>[]> fhtVerticals;
    private List<List<Segment>>[] horizontalSegments;
    private List<List<Segment>>[] verticalSegments;
    private List<PolynomialSplineFunction>[] hSplines;
    private List<PolynomialSplineFunction>[] vSplines;
    private List<OrientedPoint> flatHorizontalSegments;
    private List<OrientedPoint> flatVerticalSegments;
    private GeneralInterpolator interpolatorFHT;
    private SplineInterpolator superInterpolator;
    private MeshManager meshManager;

    public FHTManager(Size binarySize) {
        this.binarySize = binarySize;
        this.stripWidth = Bindings.createDoubleBinding(() -> binarySize.width / ((double)this.vStripsNumber.get() * (1.0 - this.vRecover.get()) + this.vRecover.get() - 1.0), (Observable[])new Observable[]{this.vStripsNumber, this.vRecover});
        this.vStep = Bindings.createDoubleBinding(() -> (1.0 - this.vRecover.get()) * this.stripWidth.get(), (Observable[])new Observable[]{this.vRecover, this.stripWidth});
        this.stripHeight = Bindings.createDoubleBinding(() -> binarySize.height / ((double)this.hStripsNumber.get() * (1.0 - this.hRecover.get()) + this.hRecover.get() - 1.0), (Observable[])new Observable[]{this.hStripsNumber, this.hRecover});
        this.hStep = Bindings.createDoubleBinding(() -> (1.0 - this.hRecover.get()) * this.stripHeight.get(), (Observable[])new Observable[]{this.hRecover, this.stripHeight});
        this.focale = new SimpleDoubleProperty(Math.max(binarySize.width, binarySize.height) / Math.tan(0.5235987755982988) / 2.0);
    }

    public boolean isInitialized() {
        return this.binarized != null;
    }

    public FHTManager init(Mat binarized) {
        this.binarized = binarized;
        assert (binarized.size().equals((Object)this.binarySize));
        this.transposedBinarized = new Mat();
        Core.transpose((Mat)binarized, (Mat)this.transposedBinarized);
        this.vStrips = null;
        this.hStrips = null;
        this.vHoughs = null;
        this.hHoughs = null;
        this.vHoughTrajs = null;
        this.hHoughTrajs = null;
        this.fhtHorizontals = null;
        this.fhtVerticals = null;
        this.horizontalSegments = null;
        this.verticalSegments = null;
        this.hSplines = null;
        this.vSplines = null;
        this.flatHorizontalSegments = null;
        this.flatVerticalSegments = null;
        this.interpolatorFHT = null;
        this.superInterpolator = null;
        this.meshManager = null;
        return this;
    }

    public List<Mat> getVStrips() {
        return this.vStrips != null ? this.vStrips : (this.vStrips = FHT.extractStrips(this.binarized, this.vStripsNumber.get(), this.stripWidth.get(), this.vStep.get()));
    }

    public List<Mat> getHStrips() {
        return this.hStrips != null ? this.hStrips : (this.hStrips = FHT.extractStrips(this.transposedBinarized, this.hStripsNumber.get(), this.stripHeight.get(), this.hStep.get()));
    }

    public List<Mat> getvHoughs() {
        return this.vHoughs != null ? this.vHoughs : (this.vHoughs = this.getVStrips().stream().map(strip -> FHT.fastHoughTransform(strip)).collect(Collectors.toList()));
    }

    public List<Mat> gethHoughs() {
        return this.hHoughs != null ? this.hHoughs : (this.hHoughs = this.getHStrips().stream().map(strip -> FHT.fastHoughTransform(strip)).collect(Collectors.toList()));
    }

    public List<List<TrajectStep>> getvHoughTrajs() {
        return this.vHoughTrajs != null ? this.vHoughTrajs : (this.vHoughTrajs = this.getvHoughs().stream().map(projectionMap -> FHT.bestTrajectFHT(projectionMap, this.vBlurSize.getValue(), this.vAnglePenality.getValue())).collect(Collectors.toList()));
    }

    public List<List<TrajectStep>> gethHoughTrajs() {
        return this.hHoughTrajs != null ? this.hHoughTrajs : (this.hHoughTrajs = this.gethHoughs().stream().map(projectionMap -> FHT.bestTrajectFHT(projectionMap, this.hBlurSize.getValue(), this.hAnglePenality.getValue())).collect(Collectors.toList()));
    }

    public List<List<OrientedPoint>[]> getFhtHorizontals() {
        return this.fhtHorizontals != null ? this.fhtHorizontals : (this.fhtHorizontals = ProjectionLines.toHorizontalsOrientedPoints(this.getvHoughTrajs(), this.vStep.get(), this.vLocalThreshold.get(), this.vGlobalThreshold.get()));
    }

    public List<List<OrientedPoint>[]> getFhtVerticals() {
        return this.fhtVerticals != null ? this.fhtVerticals : (this.fhtVerticals = ProjectionLines.toVerticalsOrientedPoints(this.gethHoughTrajs(), this.hStep.get(), this.hLocalThreshold.get(), this.hGlobalThreshold.get()));
    }

    public List<List<Segment>>[] getHorizontalSegments() {
        return this.horizontalSegments != null ? this.horizontalSegments : (this.horizontalSegments = Segment.connect(this.getFhtHorizontals(), this.vStep.get(), this.hMaxConnectDistance.get(), false));
    }

    public List<List<Segment>>[] getVerticalSegments() {
        return this.verticalSegments != null ? this.verticalSegments : (this.verticalSegments = Segment.connect(this.getFhtVerticals(), this.hStep.get(), this.vMaxConnectDistance.get(), true));
    }

    public List<PolynomialSplineFunction>[] gethSplines() {
        return this.hSplines != null ? this.hSplines : (this.hSplines = Segment.toSplines(this.getHorizontalSegments(), false));
    }

    public List<PolynomialSplineFunction>[] getvSplines() {
        return this.vSplines != null ? this.vSplines : (this.vSplines = Segment.toSplines(this.getVerticalSegments(), true));
    }

    public List<OrientedPoint> getFlatHorizontalSegments() {
        return this.flatHorizontalSegments != null ? this.flatHorizontalSegments : (this.flatHorizontalSegments = Stream.of(this.getHorizontalSegments()).flatMap(h -> h.stream()).flatMap(h -> h.stream()).flatMap(edge -> Stream.of(edge.op1, edge.op2)).collect(Collectors.toList()));
    }

    public List<OrientedPoint> getFlatVerticalSegments() {
        return this.flatVerticalSegments != null ? this.flatVerticalSegments : (this.flatVerticalSegments = Stream.of(this.getVerticalSegments()).flatMap(h -> h.stream()).flatMap(h -> h.stream()).flatMap(edge -> Stream.of(edge.op1, edge.op2)).collect(Collectors.toList()));
    }

    public GeneralInterpolator getInterpolatorFHT() {
        return this.interpolatorFHT != null ? this.interpolatorFHT : (this.interpolatorFHT = new GeneralInterpolator(this.getFlatHorizontalSegments(), this.getFlatVerticalSegments(), this.interpolatorPow.get(), this.interpolatorMinDist.get()));
    }

    public SplineInterpolator getSuperInterpolator() {
        return this.superInterpolator != null ? this.superInterpolator : (this.superInterpolator = new SplineInterpolator(this.getInterpolatorFHT(), this.gethSplines(), this.getvSplines()));
    }

    public MeshManager getMeshManager() {
        return this.meshManager != null ? this.meshManager : (this.meshManager = new MeshManager(this.halfGridWidth.get(), this.halfGridHeight.get(), this.getSuperInterpolator(), this.binarySize, this.focale.get()));
    }

    public Mat dewarp(Mat img) {
        return this.getMeshManager().dewarp3D(img);
    }

    public IntegerProperty getvBlurSize() {
        return this.vBlurSize;
    }

    public IntegerProperty gethBlurSize() {
        return this.hBlurSize;
    }

    public DoubleProperty getvAnglePenality() {
        return this.vAnglePenality;
    }

    public DoubleProperty gethAnglePenality() {
        return this.hAnglePenality;
    }

    public DoubleBinding getStripWidth() {
        return this.stripWidth;
    }

    public DoubleBinding getStripHeight() {
        return this.stripHeight;
    }

    public IntegerProperty getvStripsNumber() {
        return this.vStripsNumber;
    }

    public IntegerProperty gethStripsNumber() {
        return this.hStripsNumber;
    }

    public DoubleBinding gethStep() {
        return this.hStep;
    }

    public DoubleBinding getvStep() {
        return this.vStep;
    }

    public DoubleProperty getvRecover() {
        return this.vRecover;
    }

    public DoubleProperty gethRecover() {
        return this.hRecover;
    }

    public IntegerProperty getHalfGridHeight() {
        return this.halfGridHeight;
    }

    public IntegerProperty getHalfGridWidth() {
        return this.halfGridWidth;
    }

    public DoubleProperty gethGlobalThreshold() {
        return this.hGlobalThreshold;
    }

    public DoubleProperty getvGlobalThreshold() {
        return this.vGlobalThreshold;
    }

    public DoubleProperty gethLocalThreshold() {
        return this.hLocalThreshold;
    }

    public DoubleProperty getvLocalThreshold() {
        return this.vLocalThreshold;
    }

    public DoubleProperty gethMaxConnectDistance() {
        return this.hMaxConnectDistance;
    }

    public DoubleProperty getvMaxConnectDistance() {
        return this.vMaxConnectDistance;
    }

    public DoubleProperty getInterpolatorMinDist() {
        return this.interpolatorMinDist;
    }

    public DoubleProperty getInterpolatorPow() {
        return this.interpolatorPow;
    }

    public DoubleProperty getFocale() {
        return this.focale;
    }
}

