/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Zone;
import org.genericsystem.layout.Layout;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class Zones
implements Iterable<Zone> {
    private final List<Zone> zones;
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Zones get(Img img, double minArea) {
        return new Zones(img.channels() == 1 ? img : img.bgr2Gray(), minArea);
    }

    public static Zones get(Img img, double minArea, int RETR) {
        return new Zones(img.channels() == 1 ? img : img.bgr2Gray(), minArea, RETR);
    }

    public static Zones get(Img img, double minArea, double dx, double dy) {
        return new Zones(img.channels() == 1 ? img : img.bgr2Gray(), minArea).adjust(dx, dy, img.width(), img.height());
    }

    private Zones adjust(double dx, double dy, int width, int height) {
        return new Zones(this.zones.stream().map(zone -> zone.adjustRect(dx, dy, width, height)).collect(Collectors.toList()));
    }

    public Zones() {
        this.zones = new ArrayList<Zone>();
    }

    public Zones(List<Zone> zonesList) {
        this.zones = zonesList;
    }

    public Zones(Img gray, double minArea) {
        this(gray, minArea, 0);
    }

    public Zones(Img gray, double minArea, int RETR) {
        this.zones = new ArrayList<Zone>();
        List<MatOfPoint> contours = gray.findContours(new Img[1], RETR, 2);
        int num = 0;
        for (int i = 0; i < contours.size(); ++i) {
            MatOfPoint contour = contours.get(i);
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > minArea)) continue;
            Rect rect = Imgproc.boundingRect((MatOfPoint)contour);
            this.zones.add(new Zone(num, rect));
            ++num;
        }
    }

    public Zones(Img img, Layout layout) {
        this.zones = this.extractZonesFromLayout(img, layout);
    }

    private List<Zone> extractZonesFromLayout(Img img, Layout layout) {
        System.out.println("Extracting zones");
        ArrayList<Zone> zones = new ArrayList<Zone>();
        AtomicInteger count = new AtomicInteger(100);
        layout.traverse(img, (roi, shard) -> {
            if (shard.getChildren().isEmpty()) {
                Zone zone = new Zone(count.getAndIncrement(), shard.getLargeRect(img, 0.02, 0.1));
                System.out.println("Zone " + count.get() + " | " + zone);
                zones.add(zone);
            }
        });
        return zones;
    }

    public void draw(Img img, Scalar scalar, int thickness) {
        this.zones.forEach(adjusted -> adjusted.draw(img, scalar, thickness));
    }

    public void writeNum(Img img, Scalar scalar, int thickness) {
        this.zones.forEach(adjusted -> adjusted.write(img, String.valueOf(adjusted.getNum()), 3.0, scalar, thickness));
    }

    public List<Zone> getZones() {
        return this.zones;
    }

    public void save(File file) {
        file.getParentFile().mkdirs();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            mapper.writeValue(file, (Object)this);
            System.out.println("Zones saved in " + file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(String imgClassDirectory) {
        this.save(new File(imgClassDirectory + "/zones/zones.json"));
    }

    public static Zones load(File file) {
        try {
            return (Zones)mapper.readValue(file, Zones.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Zones load(String imgClassDirectory) {
        return Zones.load(new File(imgClassDirectory + "/zones/zones.json"));
    }

    public static boolean isZonesFilePresent(String imgPath) {
        Path classPath = Paths.get(imgPath, new String[0]).getParent();
        Path zonesPath = classPath.resolve("zones/zones.json");
        return zonesPath.toFile().exists();
    }

    @Override
    public Iterator<Zone> iterator() {
        return this.zones.iterator();
    }

    public int size() {
        return this.zones.size();
    }

    public Zones removeIf(Predicate<Zone> filter) {
        this.zones.removeIf(filter);
        return this;
    }

    public boolean isEmpty() {
        return this.zones.isEmpty();
    }

    public String toString() {
        return "Zones [zones=" + this.zones + "]";
    }
}

