/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.retriever.AbstractField;
import org.genericsystem.cv.retriever.Fields;
import org.genericsystem.cv.retriever.Stats;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class Field
extends AbstractField {
    @JsonBackReference
    private Field parent = null;
    @JsonManagedReference
    private final List<Field> children = new ArrayList<Field>();
    private static final double CONFIDENCE_THRESHOLD = 0.92;
    private static final double LOCK_THRESHOLD = 0.9;
    @JsonIgnore
    private int deadCounter = 0;
    @JsonIgnore
    private double locklLevel = 0.0;
    @JsonIgnore
    private boolean validated = false;

    public Field(GSRect rect) {
        super(rect);
    }

    public Field(GSRect rect, Field parent) {
        this(rect);
        this.updateParent(parent);
    }

    public String recursiveToString() {
        StringBuffer sb = new StringBuffer();
        this.recursiveToString(sb, 0);
        return sb.append("\n").toString();
    }

    public void recursiveToString(StringBuffer sb, int depth) {
        if (depth > 8) {
            return;
        }
        sb.append("depth: ").append(depth).append(": ").append(this.rect);
        if (this.isConsolidated()) {
            sb.append(" -> ").append(this.getConsolidated());
        }
        if (!this.children.isEmpty()) {
            ++depth;
            for (Field child : this.children) {
                sb.append("\n");
                for (int i = 0; i < depth; ++i) {
                    sb.append("  ");
                }
                child.recursiveToString(sb, depth);
            }
        }
    }

    public Field recursiveFindPotentialParent(GSRect rect) {
        if (!rect.isInside(this.getRect())) {
            return null;
        }
        for (Field child : this.children) {
            Field candidate = child.recursiveFindPotentialParent(rect);
            if (candidate == null) continue;
            return candidate;
        }
        return this;
    }

    @Override
    public String ocr(Img rootImg) {
        String ocr = super.ocr(rootImg);
        if (this.attempts <= 3L || this.attempts % 5L == 0L) {
            Stats.beginTask("ocr plasty");
            this.consolidateOcr();
            Stats.endTask("ocr plasty");
        }
        return ocr;
    }

    @Override
    public void consolidateOcr() {
        super.consolidateOcr();
        this.adjustLockLevel(this.getConfidence() > 0.92 ? 1.0 : -0.5);
    }

    @Override
    public void drawDebugText(Img display, Point[] targets, Scalar color, int thickness) {
        String conf = String.format("%.3f", this.getLockLevel());
        Point topCenter = new Point((targets[0].x + targets[1].x) / 2.0, (targets[0].y + targets[1].y) / 2.0);
        double l = Math.sqrt(Math.pow(targets[0].x - topCenter.x, 2.0) + Math.pow(targets[0].y - topCenter.y, 2.0));
        Imgproc.putText((Mat)display.getSrc(), (String)conf, (Point)new Point(topCenter.x - l, topCenter.y - 12.0), (int)4, (double)0.35, (Scalar)color);
    }

    public void draw(Img display, int thickness) {
        if (this.needText(display)) {
            this.drawDebugText(display, new Scalar(0.0, 64.0, 255.0), thickness);
        }
        this.drawRect(display, this.deadCounter == 0 ? new Scalar(0.0, 255.0, 0.0) : new Scalar(0.0, 0.0, 255.0), thickness);
    }

    public void drawWithHomography(Img display, Mat homography, int thickness) {
        if (this.needRect(display)) {
            this.drawRect(display, this.getRectPointsWithHomography(homography), this.drawAsLocked() ? new Scalar(0.0, 255.0, 0.0) : new Scalar(0.0, 0.0, 255.0), thickness);
            if (this.isValidated() && this.isOrphan()) {
                this.drawRect(display, this.getRectPointsWithHomography(homography), new Scalar(255.0, 255.0, 0.0), thickness);
            }
            this.drawText(display, this.getRectPointsWithHomography(homography), new Scalar(0.0, 255.0, 0.0), thickness);
        }
    }

    private boolean drawAsLocked() {
        return this.isOrphan() || !this.isOrphan() && this.parent.getDeadCounter() != 0 ? this.isLocked() : false;
    }

    private boolean needRect(Img display) {
        GSRect imgRect = new GSRect(0.0, 0.0, (double)display.width(), (double)display.height());
        return !this.isOrphan() && this.parent.getRect().isInside(imgRect) ? false : this.rect.isInside(imgRect);
    }

    private boolean needText(Img display) {
        return this.deadCounter == 0 && this.needRect(display);
    }

    public boolean isOnDisplay(Img display) {
        GSRect imgRect = new GSRect(0.0, 0.0, (double)display.width(), (double)display.height());
        return imgRect.isOverlapping(this.rect);
    }

    public boolean isValidated() {
        return this.validated;
    }

    @JsonIgnore
    public boolean isLocked() {
        return this.getLockLevel() >= 0.9;
    }

    @JsonIgnore
    public double getLockLevel() {
        return Math.tanh(this.locklLevel);
    }

    public void adjustLockLevel(double step) {
        this.locklLevel += 0.2 * step;
    }

    public void resetDeadCounter() {
        this.deadCounter = 0;
    }

    public void incrementDeadCounter() {
        ++this.deadCounter;
    }

    public int getDeadCounter() {
        return this.deadCounter;
    }

    public boolean addChild(Field child) {
        return this.children.add(child);
    }

    public boolean removeChild(Field child) {
        return this.children.remove(child);
    }

    public List<Field> getChildren() {
        return this.children;
    }

    public Field getParent() {
        return this.parent;
    }

    @JsonIgnore
    public List<Field> getSiblings() {
        if (this.parent == null) {
            return Collections.emptyList();
        }
        return this.parent.getChildren().stream().filter(child -> this != child).collect(Collectors.toList());
    }

    public void updateParent(Field parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        this.parent.addChild(this);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public boolean hasSiblings() {
        return !this.getSiblings().isEmpty();
    }

    @JsonIgnore
    public boolean isOrphan() {
        return this.parent == null;
    }

    public boolean isDead(int maxDeadCount) {
        return !this.isLocked() && this.deadCounter >= maxDeadCount;
    }

    public void recursiveResetChildrenDeadCounter() {
        for (Field child : this.children) {
            child.recursiveResetChildrenDeadCounter();
            child.resetDeadCounter();
        }
    }

    public void recursiveResetParentsDeadCounter() {
        this.resetDeadCounter();
        if (this.getParent() != null) {
            this.getParent().recursiveResetParentsDeadCounter();
        }
    }

    public Field findOldMatch(Fields oldFields) {
        for (Field oldField : oldFields) {
            if (!(this.getRect().inclusiveArea(oldField.getRect()) > 0.6)) continue;
            return oldField;
        }
        return null;
    }

    public void consolidateLabelWithChildren() {
        if (this.children.isEmpty() || this.consolidated == null) {
            return;
        }
        StringBuilder consolidatedLabel = new StringBuilder(this.consolidated);
        for (Field child : this.children) {
            child.consolidateLabelWithChildren();
            if (child.getConsolidated() == null || !consolidatedLabel.toString().contains(child.getConsolidated())) continue;
            int start = consolidatedLabel.indexOf(child.getConsolidated());
            consolidatedLabel.delete(start, start + child.getConsolidated().length());
        }
        if ((consolidatedLabel = new StringBuilder(consolidatedLabel.toString().trim())).length() == 0) {
            this.validated = true;
        }
    }

    public boolean isInFrame(Img img) {
        return this.rect.tl().getX() > 0.0 && this.rect.br().getX() < (double)img.width() && this.rect.tl().getY() > 0.0 && this.rect.br().getY() < (double)img.height();
    }
}

