/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.retriever.CamLiveRetriever;
import org.genericsystem.cv.retriever.ImgDescriptor;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.utils.Converters;

public class DescriptorManager {
    private Map<ImgDescriptor, Mat> descriptors = new HashMap<ImgDescriptor, Mat>();
    private ImgDescriptor reference;
    private Map<ImgDescriptor, Double> distanceMap = new HashMap<ImgDescriptor, Double>();
    private static final Mat IDENTITY_MAT = Mat.eye((Size)new Size(3.0, 3.0), (int)6);
    private Mat frame;

    public void setFrame(Mat frame) {
        this.frame = frame;
    }

    public Map<ImgDescriptor, Mat> getDescriptors() {
        return this.descriptors;
    }

    public void setReference(ImgDescriptor reference) {
        this.reference = reference;
    }

    public Map<ImgDescriptor, Double> getDistanceMap() {
        return this.distanceMap;
    }

    public Img add(ImgDescriptor deperspectivedImgDescriptor, Mat deperspectiveHomography) {
        if (this.descriptors.isEmpty()) {
            this.descriptors.put(deperspectivedImgDescriptor, IDENTITY_MAT);
            this.setReference(deperspectivedImgDescriptor);
            Mat stabilizationHomographyFromFrame = new Mat();
            Core.gemm((Mat)IDENTITY_MAT, (Mat)deperspectiveHomography, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)stabilizationHomographyFromFrame);
            return CamLiveRetriever.warpPerspective(this.frame, stabilizationHomographyFromFrame);
        }
        Mat homographyToRef = IDENTITY_MAT;
        Iterator<ImgDescriptor> iterator = this.descriptors.keySet().iterator();
        if (iterator.hasNext()) {
            ImgDescriptor descriptor = iterator.next();
            Mat joinHomography = deperspectivedImgDescriptor.computeStabilizationGraphy(descriptor);
            if (joinHomography != null) {
                homographyToRef = this.computeHomographyToRef(descriptor, joinHomography);
                this.descriptors.put(deperspectivedImgDescriptor, homographyToRef);
            } else {
                return null;
            }
        }
        this.updateReferenceDeperspectived(this.descriptors);
        Mat stabilizationHomographyFromFrame = new Mat();
        Core.gemm((Mat)this.descriptors.get(deperspectivedImgDescriptor), (Mat)deperspectiveHomography, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)stabilizationHomographyFromFrame);
        return CamLiveRetriever.warpPerspective(this.frame, stabilizationHomographyFromFrame);
    }

    private Mat computeHomographyToRef(ImgDescriptor descriptor, Mat joinHomography) {
        Mat homographyToRef = new Mat();
        Core.gemm((Mat)joinHomography, (Mat)this.descriptors.get(descriptor), (double)1.0, (Mat)new Mat(), (double)1.0, (Mat)homographyToRef);
        return homographyToRef;
    }

    private ImgDescriptor updateReferenceDeperspectived(Map<ImgDescriptor, Mat> descriptorGroup) {
        ImgDescriptor bestDescriptor = this.computeBestDescriptor(descriptorGroup);
        if (bestDescriptor != this.reference) {
            this.computeHomographiesToNewRef(bestDescriptor);
            this.setReference(bestDescriptor);
        }
        return bestDescriptor;
    }

    private void computeHomographiesToNewRef(ImgDescriptor newReference) {
        System.out.println(">>>>>>>>>>> CHANGE: Reference has changed, recomputing homographies to new ref");
        for (ImgDescriptor descriptor : this.descriptors.keySet()) {
            if (descriptor == newReference) {
                this.descriptors.put(this.reference, this.descriptors.get(descriptor).inv());
                this.descriptors.put(descriptor, IDENTITY_MAT);
                continue;
            }
            Mat newHomographyToRef = new Mat();
            Core.gemm((Mat)this.descriptors.get(this.reference), (Mat)this.descriptors.get(descriptor), (double)1.0, (Mat)new Mat(), (double)1.0, (Mat)newHomographyToRef);
            this.descriptors.put(descriptor, newHomographyToRef);
        }
    }

    private ImgDescriptor computeBestDescriptor(Map<ImgDescriptor, Mat> descriptorGroup) {
        Map<ImgDescriptor, Double> distanceMap = this.getDistanceMap();
        for (ImgDescriptor origin : descriptorGroup.keySet()) {
            double totalDistance = 0.0;
            for (ImgDescriptor target : descriptorGroup.keySet()) {
                totalDistance += origin == target ? 0.0 : this.computeDistanceBetweenDeperspectived(this.computeHomographyBetweenDeperspectived(origin, target));
            }
            distanceMap.put(origin, totalDistance);
        }
        return (ImgDescriptor)Collections.min(distanceMap.entrySet(), Comparator.comparingDouble(Map.Entry::getValue)).getKey();
    }

    private Mat computeHomographyBetweenDeperspectived(ImgDescriptor origin, ImgDescriptor target) {
        Mat homographyBetweenDeperspectived = new Mat();
        Core.gemm((Mat)this.descriptors.get(target).inv(), (Mat)this.descriptors.get(origin), (double)1.0, (Mat)new Mat(), (double)1.0, (Mat)homographyBetweenDeperspectived);
        return homographyBetweenDeperspectived;
    }

    private double computeDistanceBetweenDeperspectived(Mat betweenDeperspectivedHomography) {
        List<Point> originalPoints = Arrays.asList(new Point(0.0, 0.0), new Point((double)this.frame.width(), 0.0), new Point((double)this.frame.width(), (double)this.frame.height()), new Point(0.0, (double)this.frame.height()));
        List<Point> points = this.restabilize(originalPoints, betweenDeperspectivedHomography);
        return this.evaluateDistanceBetweenStabilized(points, originalPoints);
    }

    private List<Point> restabilize(List<Point> originals, Mat homography) {
        Mat original = Converters.vector_Point2d_to_Mat(originals);
        Mat results = new Mat();
        Core.perspectiveTransform((Mat)original, (Mat)results, (Mat)homography);
        ArrayList<Point> res = new ArrayList<Point>();
        Converters.Mat_to_vector_Point2d((Mat)results, res);
        return res;
    }

    private double evaluateDistanceBetweenStabilized(List<Point> newPointList, List<Point> oldPointList) {
        double error = 0.0;
        for (int i = 0; i < oldPointList.size(); ++i) {
            double deltaX = newPointList.get((int)i).x - oldPointList.get((int)i).x;
            double deltaY = newPointList.get((int)i).y - oldPointList.get((int)i).y;
            error += deltaX * deltaX + deltaY * deltaY;
        }
        return Math.sqrt(error) / (double)oldPointList.size();
    }
}

