/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;
import org.opencv.videoio.VideoCapture;

public class LinesDetector7
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private double[] vp = new double[]{0.0, 0.0};
    private Calibrated.AngleCalibrated calibrated;

    public static void main(String[] args) {
        LinesDetector7.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskiewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskiewedView, 0, 1);
        Mat dePerspectived = frame.clone();
        this.calibrated = new Calibrated.AngleCalibrated(0.0, 1.5707963267948966);
        double[] pp = new double[]{frame.width() / 2, frame.height() / 2};
        double f = 672.5555555555555;
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(frame);
                Img grad = new Img(frame, false).morphologyEx(4, 2, new Size(2.0, 2.0)).otsu().morphologyEx(3, 2, new Size(3.0, 3.0));
                Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 100.0, 10.0));
                if (lines.size() > 10) {
                    lines.draw(frame, new Scalar(0.0, 0.0, 255.0));
                    lines.draw(frame, new Scalar(0.0, 255.0, 0.0));
                    frameView.setImage(Tools.mat2jfxImage(frame));
                    double[] newThetaPhi = new LevenbergImpl<Line>((line, params) -> this.distance(new Calibrated.AngleCalibrated((double[])params).uncalibrate(pp, 672.5555555555555), (Line)line), lines.lines, this.calibrated.getThetaPhi()).getParams();
                    this.calibrated = this.calibrated.dumpThetaPhi(newThetaPhi, 1);
                    this.vp = this.calibrated.uncalibrate(pp, 672.5555555555555);
                    System.out.println("Vanishing point : " + this.vp);
                    Mat homography = LinesDetector7.findHomography(frame.size(), new Calibrated.AngleCalibrated[]{this.calibrated, new Calibrated.AngleCalibrated(1.5707963267948966, 1.5707963267948966), new Calibrated.AngleCalibrated(1.5707963267948966, 0.0)}, pp, 672.5555555555555);
                    Imgproc.warpPerspective((Mat)frame, (Mat)dePerspectived, (Mat)homography, (Size)frame.size(), (int)1, (int)0, (Scalar)Scalar.all((double)0.0));
                    deskiewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 10L, TimeUnit.MILLISECONDS);
    }

    private double distance(double[] vp, Line line) {
        double a = line.y1 - line.y2;
        double b = line.x2 - line.x1;
        double c = line.y1 * line.x2 - line.x1 * line.y2;
        double norm = Math.sqrt(a * a + b * b + c * c);
        double n0 = -b / norm;
        double n1 = a / norm;
        double nNorm = Math.sqrt(n0 * n0 + n1 * n1);
        double[] midPoint = this.getMiLine(line);
        double r0 = vp[1] * midPoint[2] - midPoint[1];
        double r1 = midPoint[0] - vp[0] * midPoint[2];
        double rNorm = Math.sqrt(r0 * r0 + r1 * r1);
        double num = r0 * n0 + r1 * n1;
        if (num < 0.0) {
            num = -num;
        }
        double d = 0.0;
        if (nNorm != 0.0 && rNorm != 0.0) {
            d = num / (nNorm * rNorm);
        }
        return d < 0.4 ? d : 0.4;
    }

    private double[] getNormalizedLine(Line line) {
        double a = line.y1 - line.y2;
        double b = line.x2 - line.x1;
        double c = line.y1 * line.x2 - line.x1 * line.y2;
        double norm = Math.sqrt(a * a + b * b + c * c);
        return new double[]{a / norm, b / norm, c / norm};
    }

    private double[] getMiLine(Line line) {
        return new double[]{(line.x1 + line.x2) / 2.0, (line.y1 + line.y2) / 2.0, 1.0};
    }

    public static Mat findHomography(Size size, Calibrated.AngleCalibrated[] calibrateds, double[] pp, double f) {
        double[][] vps = new double[][]{calibrateds[0].getCalibratexyz(), calibrateds[1].getCalibratexyz(), calibrateds[2].getCalibratexyz()};
        double[][] vps2D = LinesDetector7.getVp2DFromVps(vps, pp, f);
        System.out.println("vps2D : " + Arrays.deepToString((Object[])vps2D));
        System.out.println("vp1 " + calibrateds[0]);
        System.out.println("vp2 " + calibrateds[1]);
        System.out.println("vp3 " + calibrateds[2]);
        double theta = calibrateds[0].getTheta();
        double theta2 = calibrateds[1].getTheta();
        double x = size.width / 6.0;
        double[] A = new double[]{size.width / 2.0, size.height / 2.0, 1.0};
        double[] B = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0};
        double[] D = new double[]{size.width / 2.0, size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x), 1.0};
        double[] C = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x)};
        double[] A_ = A;
        double[] B_ = new double[]{size.width / 2.0 + x * vps[0][0], size.height / 2.0 + x * vps[0][1], 1.0};
        double[] D_ = new double[]{size.width / 2.0 + x * vps[1][0], size.height / 2.0 + x * vps[1][1], 1.0};
        double[] C_ = LinesDetector7.cross2D(LinesDetector7.cross(B_, vps2D[1]), LinesDetector7.cross(D_, vps2D[0]));
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(A_), new Point(B_), new Point(C_), new Point(D_)}), (Mat)new MatOfPoint2f(new Point[]{new Point(A), new Point(B), new Point(C), new Point(D)}));
    }

    public static double[][] getVp2DFromVps(double[][] vps, double[] pp, double f) {
        double[][] result = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            result[i][0] = vps[i][0] * f / vps[i][2] + pp[0];
            result[i][1] = vps[i][1] * f / vps[i][2] + pp[1];
            result[i][2] = 1.0;
        }
        return result;
    }

    static double[] cross2D(double[] a, double[] b) {
        return LinesDetector7.uncalibrate(LinesDetector7.cross(a, b));
    }

    static double[] uncalibrate(double[] a) {
        return new double[]{a[0] / a[2], a[1] / a[2], 1.0};
    }

    static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Line {
        private final double x1;
        private final double y1;
        private final double x2;
        private final double y2;

        public Line(Point p1, Point p2) {
            this(p1.x, p1.y, p2.x, p2.y);
        }

        public Line(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }

        public double size() {
            return Math.sqrt(Math.pow(this.y2 - this.y1, 2.0) + Math.pow(this.x2 - this.x1, 2.0));
        }

        public Line transform(Mat rotationMatrix) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.transform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)rotationMatrix);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public Line perspectivTransform(Mat homography) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.perspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)homography);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public void draw(Mat frame, Scalar color) {
            Imgproc.line((Mat)frame, (Point)new Point(this.x1, this.y1), (Point)new Point(this.x2, this.y2), (Scalar)color, (int)1);
        }

        public double geta() {
            return (this.y2 - this.y1) / (this.x2 - this.x1);
        }

        public double getb() {
            return this.y1 - this.geta() * this.x1;
        }

        public double distance(Point p) {
            return Math.abs(this.geta() * p.x - p.y + this.getb()) / Math.sqrt(1.0 + Math.pow(this.geta(), 2.0));
        }

        public Point intersection(double a, double b) {
            double x = (b - this.getb()) / (this.geta() - a);
            double y = a * x + b;
            return new Point(x, y);
        }

        public Point intersection(Line line) {
            double x = (line.getb() - this.getb()) / (this.geta() - line.geta());
            double y = this.geta() * x + this.getb();
            return new Point(x, y);
        }

        public Point intersection(double verticalLinex) {
            double x = verticalLinex;
            double y = this.geta() * x + this.getb();
            return new Point(x, y);
        }
    }

    public static class Lines {
        private final List<Line> lines;

        public Lines(Mat src) {
            this.lines = new ArrayList<Line>();
            for (int i = 0; i < src.rows(); ++i) {
                double[] val = src.get(i, 0);
                Line line = new Line(val[0], val[1], val[2], val[3]);
                this.lines.add(line);
            }
        }

        public Lines filter(Predicate<Line> predicate) {
            return new Lines(this.lines.stream().filter(predicate).collect(Collectors.toList()));
        }

        public Lines reduce(int max) {
            if (this.lines.size() <= max) {
                return this;
            }
            HashSet<Line> newLines = new HashSet<Line>();
            while (newLines.size() < max) {
                newLines.add(this.lines.get((int)(Math.random() * (double)this.size())));
            }
            return new Lines(newLines);
        }

        public Lines(Collection<Line> lines) {
            this.lines = new ArrayList<Line>(lines);
        }

        public Lines rotate(Mat matrix) {
            return new Lines(this.lines.stream().map(line -> line.transform(matrix)).collect(Collectors.toList()));
        }

        public Lines perspectivTransform(Mat matrix) {
            return new Lines(this.lines.stream().map(line -> line.perspectivTransform(matrix)).collect(Collectors.toList()));
        }

        public void draw(Mat frame, Scalar color) {
            this.lines.forEach(line -> line.draw(frame, color));
        }

        public int size() {
            return this.lines.size();
        }
    }
}

