/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.video.BackgroundSubtractorMOG2;
import org.opencv.video.Video;
import org.opencv.videoio.VideoCapture;

public class BackGroundSubstractor {
    private static VideoCapture camera;
    private static final String adjustedDirectoryPath2 = "aligned-image-3.png";

    public static void main(String[] args) {
        JFrame jframe = new JFrame("BackgroundSubstractor");
        jframe.setResizable(false);
        jframe.setDefaultCloseOperation(3);
        JLabel vidpanel = new JLabel();
        jframe.setContentPane(vidpanel);
        Mat img = new Mat();
        camera.read(img);
        jframe.setSize(img.width(), img.height());
        jframe.setVisible(true);
        BackgroundSubtractorMOG2 mog2 = Video.createBackgroundSubtractorMOG2();
        Mat average = null;
        while (true) {
            camera.read(img);
            Mat fgMask = new Mat();
            mog2.apply(img, fgMask);
            Mat fg = new Mat();
            img.copyTo(fg, fgMask);
            if (average == null) {
                average = fg;
            } else {
                Core.addWeighted((Mat)average, (double)0.9666666666666667, (Mat)fg, (double)0.03333333333333333, (double)0.0, (Mat)average);
            }
            ImageIcon image = new ImageIcon(Tools.mat2bufferedImage(average));
            vidpanel.setIcon(image);
            vidpanel.repaint();
        }
    }

    static {
        NativeLibraryLoader.load();
        camera = new VideoCapture(0);
    }
}

