/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.DirectionalFilter;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class LayoutComparator
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public static void main(String[] args) {
        LayoutComparator.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView src = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src, 0, 0);
        ImageView src1 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src1, 1, 0);
        ImageView src2 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src2, 2, 0);
        ImageView src3 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src3, 3, 0);
        ImageView src4 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src4, 4, 0);
        ImageView src5 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src5, 0, 1);
        ImageView src6 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src6, 1, 1);
        ImageView src7 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src7, 2, 1);
        ImageView src8 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src8, 3, 1);
        ImageView src9 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src9, 4, 1);
        DirectionalFilter df = new DirectionalFilter();
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(frame);
                Img frameImg = new Img(frame, false);
                Img gray = frameImg.bgr2Gray();
                Mat gx = df.gx(gray.getSrc());
                Mat gy = df.gy(gray.getSrc());
                Core.subtract((Mat)Mat.zeros((Size)gy.size(), (int)gy.type()), (Mat)gy, (Mat)gy);
                Mat mag = new Mat();
                Mat ori = new Mat();
                Core.cartToPolar((Mat)gx, (Mat)gy, (Mat)mag, (Mat)ori);
                int[][] binning = df.bin(ori, 64);
                Mat mask = new Mat();
                Mat result = Mat.zeros((Size)mag.size(), (int)CvType.CV_64FC1);
                mag.copyTo(result, mask);
                System.out.println((int)Core.sumElems((Mat)result).val[0]);
                Core.multiply((Mat)result, (Scalar)new Scalar(10.0), (Mat)result, (double)1.0);
                Img img0 = new Img(result, false);
                Img img1 = frameImg.canny(60.0, 180.0).morphologyEx(3, 0, new Size(11.0, 3.0));
                Img img2 = frameImg.bgr2Gray().grad(2.0, 2.0).thresHold(0.0, 255.0, 9).bitwise_not().morphologyEx(3, 2, new Size(11.0, 3.0));
                Img img3 = frameImg.sauvolaThreshold().morphologyEx(3, 0, new Size(11.0, 3.0));
                Img img4 = frameImg.bgr2Gray().gaussianBlur(new Size(3.0, 3.0)).absDiff(new Scalar(255.0)).adaptativeThresHold(255.0, 1, 0, 11, 3.0).bitwise_not().morphologyEx(3, 0, new Size(11.0, 3.0));
                src.setImage(img0.toJfxImage());
                src1.setImage(img1.toJfxImage());
                src2.setImage(img2.toJfxImage());
                src3.setImage(img3.toJfxImage());
                src4.setImage(img4.toJfxImage());
                src6.setImage(this.detectContours(frameImg, img1).toJfxImage());
                src7.setImage(this.detectContours(frameImg, img2).toJfxImage());
                src8.setImage(this.detectContours(frameImg, img3).toJfxImage());
                src9.setImage(this.detectContours(frameImg, img4).toJfxImage());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }, 400L, 10L, TimeUnit.MILLISECONDS);
    }

    Img detectContours(Img frame, Img binary) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)binary.getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        double minArea = 10.0;
        Img result = new Img(frame.getSrc(), true);
        contours.stream().filter(contour -> Imgproc.contourArea((Mat)contour) > minArea).peek(c -> Imgproc.drawContours((Mat)result.getSrc(), Arrays.asList(c), (int)0, (Scalar)new Scalar(0.0, 255.0, 0.0))).peek(c -> {
            Point[] pts = new Point[4];
            Imgproc.minAreaRect((MatOfPoint2f)new MatOfPoint2f(c.toArray())).points(pts);
            Imgproc.drawContours((Mat)result.getSrc(), Arrays.asList(new MatOfPoint(pts)), (int)0, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)2);
        }).count();
        return result;
    }

    public void stop() throws Exception {
        this.timer.shutdown();
        this.capture.release();
        super.stop();
    }

    static {
        NativeLibraryLoader.load();
    }
}

