/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.mesh;

import java.util.Arrays;
import java.util.List;
import java.util.stream.DoubleStream;
import org.genericsystem.cv.application.mesh.AbstractMesh;
import org.genericsystem.cv.application.mesh.Mesh;
import org.genericsystem.cv.application.mesh.Points;
import org.genericsystem.cv.application.mesh.ReverseMap;
import org.genericsystem.cv.application.mesh.ReversePoints;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Point3;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;

public class Mesh3D
extends AbstractMesh<Point3> {
    private final Mesh mesh;
    private List<Point3> points3D;
    private final Size enlargedSize;

    /*
     * Exception decompiling
     */
    public Mesh3D(Mesh mesh, Size enlargedSize, double focal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Mat draw3Dsurface(Scalar colorStart, Scalar colorEnd, Size size) {
        double xMin = this.points3D.stream().mapToDouble(p -> p.x + p.z).min().getAsDouble();
        double yMin = this.points3D.stream().mapToDouble(p -> p.y + p.z).min().getAsDouble();
        double zMin = this.points3D.stream().mapToDouble(p -> p.z).min().getAsDouble();
        double xMax = this.points3D.stream().mapToDouble(p -> p.x + p.z).max().getAsDouble();
        double yMax = this.points3D.stream().mapToDouble(p -> p.y + p.z).max().getAsDouble();
        double zMax = this.points3D.stream().mapToDouble(p -> p.z).max().getAsDouble();
        System.out.println("Z : " + zMin + " " + zMax);
        int newWidth = (int)size.width;
        int newHeight = (int)Math.ceil((yMax - yMin) * size.width / (xMax - xMin));
        Mat result = new Mat(newHeight, newWidth, CvType.CV_8UC3, new Scalar(0.0, 0.0, 0.0));
        for (Point3[] point3Array : this.values()) {
            Point[] pts = (Point[])Arrays.stream(point3Array).map(p -> this.build2DPoint((Point3)p, 0.0, result.width(), 0.0, result.height(), xMin, xMax, yMin, yMax)).toArray(Point[]::new);
            double lambda = (point3Array[0].z - zMin) / (zMax - zMin);
            Scalar color = this.combine(colorStart, colorEnd, lambda);
            this.drawPolygon(result, pts, color, color);
        }
        return result;
    }

    private Point build2DPoint(Point3 p, double xMin, double xMax, double yMin, double yMax, double xMinOrig, double xMaxOrig, double yMinOrig, double yMaxOrig) {
        return new Point(this.normalize(p.x + p.z, xMin, xMax, xMinOrig, xMaxOrig), this.normalize(p.y + p.z, yMin, yMax, yMinOrig, yMaxOrig));
    }

    private double normalize(double x, double xMin, double xMax, double xMinOrig, double xMaxOrig) {
        return (xMax - xMin) * (x - xMinOrig) / (xMaxOrig - xMinOrig) + xMin;
    }

    private Scalar combine(Scalar colorStart, Scalar colorEnd, double lambda) {
        double[] c1 = colorStart.val;
        double[] c2 = colorEnd.val;
        double[] c = new double[c1.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (1.0 - lambda) * c1[i] + lambda * c2[i];
        }
        return new Scalar(c);
    }

    public double[] getWidths() {
        double[] widths = new double[this.halfWidth * 2];
        for (int j = 0; j < widths.length; ++j) {
            double sum = 0.0;
            for (int i = 0; i < this.halfHeight * 2 - 1; ++i) {
                Point3[] para = (Point3[])this.get(i - this.halfHeight, j - this.halfWidth);
                assert (para != null) : "i:" + (i - this.halfHeight) + " j: " + (j - this.halfWidth);
                sum += this.euclideanDistance(para[0], para[1]);
            }
            Point3[] para = (Point3[])this.get(this.halfHeight * 2 - 1 - this.halfHeight, j - this.halfWidth);
            widths[j] = (sum += this.euclideanDistance(para[2], para[3])) / (double)(this.halfHeight * 2);
        }
        return widths;
    }

    public double[] getHeights() {
        double[] heights = new double[this.halfHeight * 2];
        for (int i = 0; i < heights.length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.halfWidth * 2 - 1; ++j) {
                Point3[] para = (Point3[])this.get(i - this.halfHeight, j - this.halfWidth);
                sum += this.euclideanDistance(para[0], para[3]);
            }
            Point3[] para = (Point3[])this.get(i - this.halfHeight, this.halfWidth * 2 - 1 - this.halfWidth);
            heights[i] = (sum += this.euclideanDistance(para[1], para[2])) / (double)(this.halfWidth * 2);
        }
        return heights;
    }

    public Mesh reverseMesh() {
        double[] heights = this.getHeights();
        double[] widths = this.getWidths();
        double height = 2.0 * Math.min(DoubleStream.of(heights).limit(this.halfHeight).sum(), DoubleStream.of(heights).skip(this.halfHeight).sum());
        double width = 2.0 * Math.min(DoubleStream.of(widths).limit(this.halfWidth).sum(), DoubleStream.of(widths).skip(this.halfWidth).sum());
        double coef = Math.max(this.enlargedSize.height / height, this.enlargedSize.width / width);
        int i = 0;
        while (i < heights.length) {
            int n = i++;
            heights[n] = heights[n] * coef;
        }
        i = 0;
        while (i < widths.length) {
            int n = i++;
            widths[n] = widths[n] * coef;
        }
        Points candidatePoints = this.mesh.getPoints();
        Point imageCenter = candidatePoints.getPoint(0, 0);
        ReverseMap reverseMap = new ReverseMap(this.mesh, this.halfWidth, this.halfHeight, imageCenter, widths, heights);
        ReversePoints points = new ReversePoints(reverseMap, candidatePoints.xBorder, candidatePoints.yBorder, imageCenter, this.halfWidth, this.halfHeight, this.enlargedSize);
        return new Mesh(points, this.halfWidth, this.halfHeight);
    }

    public Mat dewarp(Mat src, Size originalSize) {
        int j;
        double x;
        int i;
        double[] heights = this.getHeights();
        double[] widths = this.getWidths();
        double height = 2.0 * Math.min(DoubleStream.of(heights).limit(this.halfHeight).sum(), DoubleStream.of(heights).skip(this.halfHeight).sum());
        double width = 2.0 * Math.min(DoubleStream.of(widths).limit(this.halfWidth).sum(), DoubleStream.of(widths).skip(this.halfWidth).sum());
        double coef = Math.max(originalSize.height / height, originalSize.width / width);
        int i2 = 0;
        while (i2 < heights.length) {
            int n = i2++;
            heights[n] = heights[n] * coef;
        }
        i2 = 0;
        while (i2 < widths.length) {
            int n = i2++;
            widths[n] = widths[n] * coef;
        }
        System.out.println(Arrays.toString(heights));
        System.out.println(Arrays.toString(widths));
        System.out.println(DoubleStream.of(heights).sum());
        System.out.println(DoubleStream.of(widths).sum());
        Mat enlargedImage = new Mat(src.size(), CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
        double y = enlargedImage.height() / 2;
        for (i = 0; i < this.halfHeight; ++i) {
            x = enlargedImage.width() / 2;
            for (j = 0; j < this.halfWidth; ++j) {
                if (x >= 0.0 && x + widths[j + this.halfWidth] < (double)enlargedImage.width() && y >= 0.0 && y + heights[i + this.halfHeight] < (double)enlargedImage.height()) {
                    this.deWarp(src, enlargedImage, this.mesh.getCell(i, j), x, y, widths[j + this.halfWidth], heights[i + this.halfHeight]);
                }
                x += widths[j + this.halfWidth];
            }
            x = enlargedImage.width() / 2;
            for (j = -1; j >= -this.halfWidth; --j) {
                if (!((x -= widths[j + this.halfWidth]) >= 0.0) || !(x + widths[j + this.halfWidth] < (double)enlargedImage.width()) || !(y >= 0.0) || !(y + heights[i + this.halfHeight] < (double)enlargedImage.height())) continue;
                this.deWarp(src, enlargedImage, this.mesh.getCell(i, j), x, y, widths[j + this.halfWidth], heights[i + this.halfHeight]);
            }
            y += heights[i + this.halfHeight];
        }
        y = enlargedImage.height() / 2;
        for (i = -1; i >= -this.halfHeight; --i) {
            y -= heights[i + this.halfHeight];
            x = enlargedImage.width() / 2;
            for (j = 0; j < this.halfWidth; ++j) {
                if (x >= 0.0 && x + widths[j + this.halfWidth] < (double)enlargedImage.width() && y >= 0.0 && y + heights[i + this.halfHeight] < (double)enlargedImage.height()) {
                    this.deWarp(src, enlargedImage, this.mesh.getCell(i, j), x, y, widths[j + this.halfWidth], heights[i + this.halfHeight]);
                }
                x += widths[j + this.halfWidth];
            }
            x = enlargedImage.width() / 2;
            for (j = -1; j >= -this.halfWidth; --j) {
                if (!((x -= widths[j + this.halfWidth]) >= 0.0) || !(x + widths[j + this.halfWidth] < (double)enlargedImage.width()) || !(y >= 0.0) || !(y + heights[i + this.halfHeight] < (double)enlargedImage.height())) continue;
                this.deWarp(src, enlargedImage, this.mesh.getCell(i, j), x, y, widths[j + this.halfWidth], heights[i + this.halfHeight]);
            }
        }
        double xBorder = ((double)enlargedImage.width() - originalSize.width) / 2.0;
        double yBorder = ((double)enlargedImage.height() - originalSize.height) / 2.0;
        return new Mat(enlargedImage, new Rect(new Point(xBorder, yBorder), new Point((double)enlargedImage.width() - xBorder, (double)enlargedImage.height() - yBorder)));
    }

    private double euclideanDistance(Point3 p1, Point3 p2) {
        return Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y) + (p2.z - p1.z) * (p2.z - p1.z));
    }

    private static /* synthetic */ Point lambda$new$2(Size enlargedSize, double focal, Point pts) {
        return new Point((pts.x - enlargedSize.width / 2.0) / focal, (pts.y - enlargedSize.height / 2.0) / focal);
    }

    private static /* synthetic */ int[][] lambda$new$1(int x$0) {
        return new int[x$0][];
    }
}

