/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Mat;
import org.opencv.videoio.VideoCapture;

public class VideoDisplay
extends AbstractApp {
    private static final String refPath = "classes/id-fr-front/image4-0.png";
    private static Img ref;
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public static void main(String[] args) {
        VideoDisplay.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView src = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src, 0, 0);
        mainGrid.add((Node)ref.getImageView(), 0, 1);
        this.timer.scheduleAtFixedRate(() -> {
            this.capture.read(frame);
            src.setImage(Tools.mat2jfxImage(frame));
        }, 0L, 33L, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Exception {
        this.timer.shutdown();
        this.capture.release();
        super.stop();
    }

    static {
        NativeLibraryLoader.load();
        ref = new Img(refPath);
    }
}

