/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.Line;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Ransac;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;
import org.opencv.videoio.VideoCapture;

public class LinesDetector6
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private Point vp = new Point(0.0, 0.0);

    public static void main(String[] args) {
        LinesDetector6.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskewedView, 0, 1);
        Mat dePerspectived = frame.clone();
        if (Lines.K == null) {
            Lines.K = new Mat(3, 3, CvType.CV_64FC1, new Scalar(0.0));
            Lines.K.put(0, 0, new double[]{frame.width()});
            Lines.K.put(0, 2, new double[]{frame.width() / 2});
            Lines.K.put(1, 1, new double[]{frame.height()});
            Lines.K.put(1, 2, new double[]{frame.height() / 2});
            Lines.K.put(2, 2, new double[]{1.0});
        }
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(frame);
                Img grad = new Img(frame, false).morphologyEx(4, 2, new Size(2.0, 2.0)).otsu().morphologyEx(3, 2, new Size(7.0, 7.0));
                Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 100.0, 10.0));
                if (lines.size() > 10) {
                    lines.draw(frame, new Scalar(0.0, 0.0, 255.0));
                    frameView.setImage(Tools.mat2jfxImage(frame));
                    Mat vpCalib = LinesDetector6.calibrate(Converters.vector_double_to_Mat(Arrays.asList(this.vp.x, this.vp.y, 1.0)));
                    LevenbergImpl<Line> fitHost = new LevenbergImpl<Line>((datas, params) -> {
                        Mat lineMat = Lines.getLineMat(datas);
                        double di = params[0] * lineMat.get(0, 0)[0] + params[1] * lineMat.get(1, 0)[0] + params[2] * lineMat.get(2, 0)[0];
                        return (di /= Math.sqrt(params[0] * params[0] + params[1] * params[1] + params[2] * params[2]) * Core.norm((Mat)lineMat)) * di;
                    }, lines.getLines(), new double[]{vpCalib.get(0, 0)[0], vpCalib.get(1, 0)[0], vpCalib.get(2, 0)[0]});
                    double[] newVp = fitHost.getParams();
                    Mat result = LinesDetector6.unCalibrate(Converters.vector_double_to_Mat(Arrays.asList(newVp[0], newVp[1], newVp[2])));
                    this.vp = new Point(result.get(0, 0)[0], result.get(1, 0)[0]);
                    System.out.println("vp = " + this.vp);
                    Point bary = new Point((double)(frame.width() / 2), (double)(frame.height() / 2));
                    Mat homography = this.findHomography(this.vp, bary, frame.width(), frame.height());
                    Imgproc.warpPerspective((Mat)frame, (Mat)dePerspectived, (Mat)homography, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    deskewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 33L, 250L, TimeUnit.MILLISECONDS);
    }

    public static Mat calibrate(Mat uncalibrated) {
        Mat dst = new Mat();
        Core.gemm((Mat)Lines.K.inv(), (Mat)uncalibrated, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Core.normalize((Mat)dst, (Mat)dst);
        return dst;
    }

    public static Mat unCalibrate(Mat calibrated) {
        Mat dst = new Mat();
        Core.gemm((Mat)Lines.K, (Mat)calibrated, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        if (dst.get(2, 0)[0] != 0.0) {
            dst.put(0, 0, new double[]{dst.get(0, 0)[0] / dst.get(2, 0)[0]});
            dst.put(1, 0, new double[]{dst.get(1, 0)[0] / dst.get(2, 0)[0]});
            dst.put(2, 0, new double[]{1.0});
        }
        return dst;
    }

    public Point[] rotate(Point bary, double alpha, Point ... p) {
        Mat matrix = Imgproc.getRotationMatrix2D((Point)bary, (double)(alpha / Math.PI * 180.0), (double)1.0);
        MatOfPoint2f results = new MatOfPoint2f();
        Core.transform((Mat)new MatOfPoint2f(p), (Mat)results, (Mat)matrix);
        return results.toArray();
    }

    private Mat findHomography(Point vp, Point bary, double width, double height) {
        Point B_;
        Point C_;
        Point D_;
        Point A_;
        double alpha_ = Math.atan2(vp.y - bary.y, vp.x - bary.x);
        if (alpha_ < -1.5707963267948966 && alpha_ > -Math.PI) {
            alpha_ += Math.PI;
        }
        if (alpha_ < Math.PI && alpha_ > 1.5707963267948966) {
            alpha_ -= Math.PI;
        }
        double alpha = alpha_;
        Point rotatedVp = this.rotate(bary, alpha, vp)[0];
        Point A = new Point(0.0, 0.0);
        Point B = new Point(width, 0.0);
        Point C = new Point(width, height);
        Point D = new Point(0.0, height);
        Point AB2 = new Point(width / 2.0, 0.0);
        Point CD2 = new Point(width / 2.0, height);
        if (rotatedVp.x >= width / 2.0) {
            A_ = new Line(AB2, rotatedVp).intersection(0.0);
            D_ = new Line(CD2, rotatedVp).intersection(0.0);
            C_ = new Line(A_, bary).intersection(new Line(CD2, rotatedVp));
            B_ = new Line(D_, bary).intersection(new Line(AB2, rotatedVp));
        } else {
            B_ = new Line(AB2, rotatedVp).intersection(width);
            C_ = new Line(CD2, rotatedVp).intersection(width);
            A_ = new Line(C_, bary).intersection(new Line(AB2, rotatedVp));
            D_ = new Line(B_, bary).intersection(new Line(CD2, rotatedVp));
        }
        System.out.println("vp : " + vp);
        System.out.println("rotated vp : " + rotatedVp);
        System.out.println("Alpha : " + alpha * 180.0 / Math.PI);
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(this.rotate(bary, -alpha, A_, B_, C_, D_)), (Mat)new MatOfPoint2f(new Point[]{A, B, C, D}));
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Lines
    extends org.genericsystem.cv.utils.Lines {
        private static Mat K;

        public Lines(Mat src) {
            super(src);
        }

        public Lines(Collection<Line> lines) {
            super(lines);
        }

        public static Lines of(Collection<Line> lines) {
            return new Lines(lines);
        }

        public static void calibrate(Mat uncalibrate) {
            Core.gemm((Mat)K.inv(), (Mat)uncalibrate, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)uncalibrate);
            Core.normalize((Mat)uncalibrate, (Mat)uncalibrate);
        }

        public static Mat uncalibrate(Mat calibrated) {
            Mat uncalibrate = new Mat(3, 1, CvType.CV_64FC1);
            Core.gemm((Mat)K, (Mat)calibrated, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)uncalibrate);
            if (uncalibrate.get(2, 0)[0] != 0.0) {
                uncalibrate.put(0, 0, new double[]{uncalibrate.get(0, 0)[0] / uncalibrate.get(2, 0)[0]});
                uncalibrate.put(1, 0, new double[]{uncalibrate.get(1, 0)[0] / uncalibrate.get(2, 0)[0]});
                uncalibrate.put(2, 0, new double[]{1.0});
            }
            return uncalibrate;
        }

        private static Mat getLineMat(Line line) {
            Mat a = new Mat(3, 1, CvType.CV_64FC1);
            Mat b = new Mat(3, 1, CvType.CV_64FC1);
            a.put(0, 0, new double[]{line.getX1()});
            a.put(1, 0, new double[]{line.getY1()});
            a.put(2, 0, new double[]{1.0});
            b.put(0, 0, new double[]{line.getX2()});
            b.put(1, 0, new double[]{line.getY2()});
            b.put(2, 0, new double[]{1.0});
            Mat an = new Mat(3, 1, CvType.CV_64FC1);
            Mat bn = new Mat(3, 1, CvType.CV_64FC1);
            Core.gemm((Mat)K.inv(), (Mat)a, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)an);
            Core.gemm((Mat)K.inv(), (Mat)b, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)bn);
            Mat li = an.cross(bn);
            Core.normalize((Mat)li, (Mat)li);
            a.release();
            b.release();
            an.release();
            bn.release();
            return li;
        }

        public Ransac<Line> vanishingPointRansac(double width, double height) {
            int minimal_sample_set_dimension = 2;
            double maxError = 0.03246f;
            if (K == null) {
                K = new Mat(3, 3, CvType.CV_64FC1, new Scalar(0.0));
                K.put(0, 0, new double[]{width});
                K.put(0, 2, new double[]{width / 2.0});
                K.put(1, 1, new double[]{height});
                K.put(1, 2, new double[]{height / 2.0});
                K.put(2, 2, new double[]{1.0});
            }
            return new Ransac<Line>(this.getLines(), this.getModelProvider(minimal_sample_set_dimension, maxError), minimal_sample_set_dimension, 100, maxError, Double.valueOf(Math.floor((double)this.size() * 0.7)).intValue());
        }

        private Function<Collection<Line>, Ransac.Model<Line>> getModelProvider(int minimal_sample_set_dimension, final double maxError) {
            return datas -> {
                final Mat[] vp = new Mat[1];
                if (datas.size() == minimal_sample_set_dimension) {
                    Iterator it = datas.iterator();
                    vp[0] = Lines.getLineMat((Line)it.next()).cross(Lines.getLineMat((Line)it.next()));
                    Core.normalize((Mat)vp[0], (Mat)vp[0]);
                } else {
                    Mat li_set = new Mat(3, datas.size(), CvType.CV_64FC1);
                    Mat tau = new Mat(datas.size(), datas.size(), CvType.CV_64FC1, new Scalar(0.0, 0.0, 0.0));
                    int i = 0;
                    for (Line line : datas) {
                        Mat li = Lines.getLineMat(line);
                        li_set.put(0, i, li.get(0, 0));
                        li_set.put(1, i, li.get(1, 0));
                        li_set.put(2, i, li.get(2, 0));
                        tau.put(i, i, new double[]{line.size()});
                        ++i;
                    }
                    Mat L = li_set.t();
                    Mat ATA = new Mat(3, 3, CvType.CV_64FC1);
                    Mat dst = new Mat();
                    Core.gemm((Mat)L.t(), (Mat)tau.t(), (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
                    Core.gemm((Mat)dst, (Mat)tau, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
                    Core.gemm((Mat)dst, (Mat)L, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)ATA);
                    Mat v = new Mat();
                    Core.SVDecomp((Mat)ATA, (Mat)new Mat(), (Mat)v, (Mat)new Mat());
                    if (v.rows() < 3) {
                        throw new IllegalStateException();
                    }
                    vp[0] = new Mat(3, 1, CvType.CV_64FC1);
                    vp[0].put(0, 0, v.get(0, 2));
                    vp[0].put(1, 0, v.get(1, 2));
                    vp[0].put(2, 0, v.get(2, 2));
                    Core.normalize((Mat)vp[0], (Mat)vp[0]);
                    vp[0] = Lines.uncalibrate(vp[0]);
                }
                return new Ransac.Model<Line>(){

                    @Override
                    public double computeError(Line line) {
                        Mat lineMat = Lines.getLineMat(line);
                        double di = vp[0].dot(lineMat);
                        return (di /= Core.norm((Mat)vp[0]) * Core.norm((Mat)lineMat)) * di;
                    }

                    @Override
                    public double computeGlobalError(List<Line> datas, Collection<Line> consensusDatas) {
                        double globalError = 0.0;
                        for (Line line : datas) {
                            double error = this.computeError(line);
                            if (error > maxError) {
                                error = maxError;
                            }
                            globalError += error;
                        }
                        return globalError /= (double)datas.size();
                    }

                    @Override
                    public Object[] getParams() {
                        return new Object[]{vp[0]};
                    }
                };
            };
        }
    }
}

