/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.retriever.DescriptorManager;
import org.genericsystem.cv.retriever.Fields;
import org.genericsystem.cv.retriever.ImgDescriptor;
import org.genericsystem.cv.retriever.Stats;
import org.genericsystem.cv.utils.Line;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamLiveRetriever
extends AbstractApp {
    static final Logger logger;
    private static long counter;
    private static final int STABILIZATION_DELAY = 500;
    private static final int FRAME_DELAY = 100;
    private final ScheduledExecutorService timerFields = new ScheduledThreadPoolExecutor(1, new ThreadPoolExecutor.DiscardPolicy());
    private final Fields fields = new Fields();
    private int recoveringCounter = 0;
    private ImgDescriptor stabilizedImgDescriptor;
    private ImgDescriptor deperspectivedImgDescriptor;
    private final VideoCapture capture = new VideoCapture(0);
    private Mat frame = new Mat();
    private boolean stabilizationHasChanged = true;
    private int stabilizationErrors = 0;
    private Calibrated.AngleCalibrated calibrated0;
    private DescriptorManager descriptorManager = new DescriptorManager();
    private Mat deperspectiveHomography = new Mat();
    private final double f = 672.5555555555555;
    private boolean stabilizedMode = false;
    private boolean textsEnabledMode = false;
    private Lines lines;
    private Img display;
    private Img savedDisplay = null;
    protected DeperspectivationMode mode = DeperspectivationMode.FULL;

    public static void main(String[] args) {
        CamLiveRetriever.launch((String[])args);
    }

    public void stop() throws Exception {
        super.stop();
        this.timerFields.shutdown();
        this.timerFields.awaitTermination(5L, TimeUnit.SECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        this.capture.read(this.frame);
        double[] pp = new double[]{this.frame.width() / 2, this.frame.height() / 2};
        this.calibrated0 = new Calibrated.AngleCalibrated(0.0, 1.5707963267948966);
        ImageView src0 = new ImageView(Tools.mat2jfxImage(this.frame));
        mainGrid.add((Node)src0, 0, 0);
        ImageView src1 = new ImageView(Tools.mat2jfxImage(this.frame));
        mainGrid.add((Node)src1, 1, 0);
        ImageView src2 = new ImageView(Tools.mat2jfxImage(this.frame));
        mainGrid.add((Node)src2, 1, 1);
        this.timerFields.scheduleAtFixedRate(() -> this.onSpace(), 0L, 500L, TimeUnit.MILLISECONDS);
        Img display = new Img(this.frame, false);
        this.timerFields.scheduleAtFixedRate(() -> {
            try {
                Stats.beginTask("frame");
                this.capture.read(this.frame);
                if (this.frame == null) {
                    logger.warn("No frame !");
                    return;
                }
                Stats.beginTask("deperspectivation");
                Mat deperspectivGraphy = this.computeDeperspectivedHomography(this.frame, pp, 672.5555555555555, this.mode);
                Stats.endTask("deperspectivation");
                if (deperspectivGraphy != null) {
                    ImgDescriptor newImgDescriptor;
                    this.descriptorManager.setFrame(this.frame);
                    this.deperspectiveHomography = deperspectivGraphy;
                    if (this.stabilizedImgDescriptor == null) {
                        this.stabilizedImgDescriptor = new ImgDescriptor(this.frame, deperspectivGraphy);
                        return;
                    }
                    if (this.stabilizationHasChanged && this.stabilizationErrors > 20) {
                        this.fields.reset();
                        this.stabilizationErrors = 0;
                        this.stabilizedImgDescriptor = new ImgDescriptor(this.frame, deperspectivGraphy);
                        return;
                    }
                    Stats.beginTask("get img descriptors");
                    this.deperspectivedImgDescriptor = newImgDescriptor = new ImgDescriptor(this.frame, deperspectivGraphy);
                    Stats.endTask("get img descriptors");
                    Stats.beginTask("stabilization homography");
                    Mat betweenStabilizedHomography = this.stabilizedImgDescriptor.computeStabilizationGraphy(newImgDescriptor);
                    Stats.endTask("stabilization homography");
                    if (betweenStabilizedHomography != null) {
                        this.stabilizationErrors = 0;
                        Mat stabilizationHomographyFromFrame = new Mat();
                        Core.gemm((Mat)betweenStabilizedHomography.inv(), (Mat)deperspectivGraphy, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)stabilizationHomographyFromFrame);
                        Img stabilized = CamLiveRetriever.warpPerspective(this.frame, stabilizationHomographyFromFrame);
                        Img stabilizedDisplay = new Img(stabilized.getSrc(), true);
                        if (this.stabilizationHasChanged && this.recoveringCounter == 0) {
                            Stats.beginTask("stabilizationHasChanged");
                            stabilized = newImgDescriptor.getDeperspectivedImg();
                            stabilizedDisplay = new Img(stabilized.getSrc(), true);
                            Stats.beginTask("restabilizeFields");
                            this.fields.restabilizeFields(betweenStabilizedHomography);
                            Stats.endTask("restabilizeFields");
                            this.stabilizedImgDescriptor = newImgDescriptor;
                            stabilizationHomographyFromFrame = deperspectivGraphy;
                            this.stabilizationHasChanged = false;
                            Stats.endTask("stabilizationHasChanged");
                        }
                        Stats.beginTask("consolidate fields");
                        this.fields.consolidate(stabilizedDisplay);
                        Stats.endTask("consolidate fields");
                        Stats.beginTask("performOcr");
                        this.fields.performOcr(stabilized);
                        Stats.endTask("performOcr");
                        Img stabilizedDebug = new Img(stabilizedDisplay.getSrc(), true);
                        Stats.beginTask("draw");
                        this.fields.drawFieldsOnStabilizedDebug(stabilizedDebug);
                        this.fields.drawOcrPerspectiveInverse(display, stabilizationHomographyFromFrame.inv(), 1);
                        this.fields.drawFieldsOnStabilized(stabilizedDisplay);
                        Stats.endTask("draw");
                        Image stabilizedDisplayImage = stabilizedDisplay.toJfxImage();
                        if (this.savedDisplay == null) {
                            this.savedDisplay = stabilizedDisplay;
                        }
                        Platform.runLater(() -> src2.setImage(this.savedDisplay.toJfxImage()));
                        Platform.runLater(() -> src1.setImage(stabilizedDisplayImage));
                        if (++counter % 20L == 0L) {
                            System.out.println(Stats.getStatsAndReset());
                            counter = 0L;
                        }
                    } else {
                        ++this.stabilizationErrors;
                        logger.warn("Unable to compute a valid stabilization ({} times)", (Object)this.stabilizationErrors);
                    }
                }
                Image displayImage = display.toJfxImage();
                Platform.runLater(() -> src0.setImage(displayImage));
            }
            catch (Throwable e) {
                logger.warn("Exception while computing layout.", e);
            }
            finally {
                Stats.endTask("frame");
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    private Mat computeDeperspectivedHomography(Mat frame, double[] pp, double f, DeperspectivationMode mode) {
        Mat diffFrame;
        if (!this.stabilizedMode) {
            this.capture.read(frame);
        }
        if (DeperspectivationMode.NONE == mode) {
            return Mat.eye((int)3, (int)3, (int)CvType.CV_64FC1);
        }
        this.display = new Img(frame, true);
        ArrayList<Line> addedLines = null;
        if (this.textsEnabledMode) {
            diffFrame = this.getDiffFrame(frame);
            List<Circle> circles = this.detectCircles(frame, diffFrame, 30, 100);
            Collection<Circle> selectedCircles = this.selectRandomCirles(circles, 20);
            addedLines = new ArrayList<Line>();
            for (Circle circle : selectedCircles) {
                Img circledImg = this.getCircledImg(frame, (int)circle.radius, circle.center);
                double angle = this.getBestAngle(circledImg, 42, 12.0, 5, 180.0, null) / 180.0 * Math.PI;
                addedLines.add(this.buildLine(frame, circle.center, angle, circle.radius));
                Imgproc.circle((Mat)this.display.getSrc(), (Point)circle.center, (int)((int)circle.radius), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            }
        }
        diffFrame = new Mat();
        Core.absdiff((Mat)frame, (Scalar)new Scalar(255.0), (Mat)diffFrame);
        Img grad = new Img(diffFrame, false).adaptativeGaussianInvThreshold(5, 3.0).morphologyEx(3, 2, new Size(10.0, 10.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
        this.lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 40.0, 10.0));
        if (addedLines != null) {
            this.lines.lines.addAll(addedLines);
        }
        if (this.lines.size() > 4) {
            double[] thetaPhi = new LevenbergImpl<Line>((line, params) -> CamLiveRetriever.distance(new Calibrated.AngleCalibrated((double[])params).uncalibrate(pp, f), line), this.lines.lines, this.calibrated0.getThetaPhi()).getParams();
            this.calibrated0 = this.calibrated0.dumpThetaPhi(thetaPhi, 1);
            Calibrated.AngleCalibrated[] result = CamLiveRetriever.findOtherVps(this.calibrated0, this.lines, pp, f);
            return CamLiveRetriever.findHomography(frame.size(), result, pp, f);
        }
        System.out.println("Not enough lines : " + this.lines.size());
        return null;
    }

    public static Calibrated.AngleCalibrated[] findOtherVps(Calibrated.AngleCalibrated calibrated0, Lines lines, double[] pp, double f) {
        Calibrated.AngleCalibrated[] result = new Calibrated.AngleCalibrated[]{null, null, null};
        double bestError = Double.MAX_VALUE;
        for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / 180) {
            double error = 0.0;
            Calibrated.AngleCalibrated calibratexy = calibrated0.getOrthoFromAngle(angle);
            Calibrated.AngleCalibrated calibratez = calibrated0.getOrthoFromVps(calibratexy);
            if (calibratexy.getPhi() < calibratez.getPhi()) {
                Calibrated.AngleCalibrated tmp = calibratexy;
                calibratexy = calibratez;
                calibratez = tmp;
            }
            double[] uncalibrate = calibratexy.uncalibrate(pp, f);
            for (Line line : lines.lines) {
                error += CamLiveRetriever.distance(uncalibrate, line);
            }
            if (!(error < bestError)) continue;
            bestError = error;
            result[0] = calibrated0;
            result[1] = calibratexy;
            result[2] = calibratez;
        }
        double theta0 = Math.abs(result[0].getTheta()) % Math.PI;
        theta0 = Math.min(Math.PI - theta0, theta0);
        double theta1 = Math.abs(result[1].getTheta()) % Math.PI;
        if (theta0 > (theta1 = Math.min(Math.PI - theta1, theta1))) {
            Calibrated.AngleCalibrated tmp = result[0];
            result[0] = result[1];
            result[1] = tmp;
        }
        return result;
    }

    private static double distance(double[] vp, Line line) {
        double dy = line.y1 - line.y2;
        double dx = line.x2 - line.x1;
        double dz = line.y1 * line.x2 - line.x1 * line.y2;
        double norm = Math.sqrt(dy * dy + dx * dx + dz * dz);
        double n0 = -dx / norm;
        double n1 = dy / norm;
        double nNorm = Math.sqrt(n0 * n0 + n1 * n1);
        double[] midPoint = new double[]{(line.x1 + line.x2) / 2.0, (line.y1 + line.y2) / 2.0, 1.0};
        double r0 = vp[1] * midPoint[2] - midPoint[1];
        double r1 = midPoint[0] - vp[0] * midPoint[2];
        double rNorm = Math.sqrt(r0 * r0 + r1 * r1);
        double num = r0 * n0 + r1 * n1;
        if (num < 0.0) {
            num = -num;
        }
        double d = 0.0;
        if (nNorm != 0.0 && rNorm != 0.0) {
            d = num / (nNorm * rNorm);
        }
        return d < 0.4 ? d : 0.4;
    }

    public static Mat findHomography(Size size, Calibrated.AngleCalibrated[] calibrateds, double[] pp, double f) {
        double[][] vps = new double[][]{calibrateds[0].getCalibratexyz(), calibrateds[1].getCalibratexyz(), calibrateds[2].getCalibratexyz()};
        double[][] vps2D = CamLiveRetriever.getVp2DFromVps(vps, pp, f);
        double theta = calibrateds[0].getTheta();
        double theta2 = calibrateds[1].getTheta();
        double x = size.width / 6.0;
        double[] A = new double[]{size.width / 2.0, size.height / 2.0, 1.0};
        double[] B = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0};
        double[] D = new double[]{size.width / 2.0, size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x), 1.0};
        double[] C = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x)};
        double[] A_ = A;
        double[] B_ = new double[]{size.width / 2.0 + x * vps[0][0], size.height / 2.0 + x * vps[0][1], 1.0};
        double[] D_ = new double[]{size.width / 2.0 + x * vps[1][0], size.height / 2.0 + x * vps[1][1], 1.0};
        double[] C_ = CamLiveRetriever.cross2D(CamLiveRetriever.cross(B_, vps2D[1]), CamLiveRetriever.cross(D_, vps2D[0]));
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(A_), new Point(B_), new Point(C_), new Point(D_)}), (Mat)new MatOfPoint2f(new Point[]{new Point(A), new Point(B), new Point(C), new Point(D)}));
    }

    private Mat getDiffFrame(Mat frame) {
        Mat result = new Mat();
        Imgproc.cvtColor((Mat)frame, (Mat)result, (int)6);
        Imgproc.GaussianBlur((Mat)result, (Mat)result, (Size)new Size(3.0, 3.0), (double)0.0);
        Mat diffFrame = new Mat();
        Core.absdiff((Mat)result, (Scalar)new Scalar(255.0), (Mat)diffFrame);
        Imgproc.adaptiveThreshold((Mat)diffFrame, (Mat)diffFrame, (double)255.0, (int)0, (int)1, (int)7, (double)3.0);
        return diffFrame;
    }

    private Collection<Circle> selectRandomCirles(List<Circle> circles, int circlesNumber) {
        if (circles.size() <= circlesNumber) {
            return circles;
        }
        HashSet<Circle> result = new HashSet<Circle>();
        while (result.size() < circlesNumber) {
            result.add(circles.get((int)(Math.random() * (double)circles.size())));
        }
        return result;
    }

    private List<Circle> detectCircles(Mat frame, Mat diffFrame, int minRadius, int maxRadius) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)diffFrame, contours, (Mat)new Mat(), (int)1, (int)2);
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (int i = 0; i < contours.size(); ++i) {
            MatOfPoint contour = (MatOfPoint)contours.get(i);
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > 50.0)) continue;
            float[] radius = new float[1];
            Point center = new Point();
            MatOfPoint2f contour2F = new MatOfPoint2f(contour.toArray());
            Imgproc.minEnclosingCircle((MatOfPoint2f)contour2F, (Point)center, (float[])radius);
            if (!(radius[0] > (float)minRadius) || !(radius[0] < (float)maxRadius) || !(center.x > (double)radius[0]) || !(center.y > (double)radius[0]) || !(center.x + (double)radius[0] < (double)frame.width()) || !(center.y + (double)radius[0] < (double)frame.height())) continue;
            circles.add(new Circle(center, radius[0]));
        }
        return circles;
    }

    public Img getCircledImg(Mat frame, int radius, Point center) {
        Mat mask = new Mat(new Size((double)(radius * 2), (double)(radius * 2)), CvType.CV_8UC1, new Scalar(0.0));
        Imgproc.circle((Mat)mask, (Point)new Point((double)radius, (double)radius), (int)radius, (Scalar)new Scalar(255.0), (int)-1);
        Rect rect = new Rect(new Point(center.x - (double)radius, center.y - (double)radius), new Point(center.x + (double)radius, center.y + (double)radius));
        Mat roi = new Img(new Mat(frame, rect), true).bilateralFilter().adaptativeGaussianInvThreshold(3, 3.0).getSrc();
        Mat circled = new Mat();
        roi.copyTo(circled, mask);
        Img circledImg = new Img(circled, false);
        return circledImg;
    }

    public Line buildLine(Mat mat, Point center, double angle, double size) {
        double x1 = center.x - Math.sin(angle) * size;
        double y1 = center.y + Math.cos(angle) * size;
        double x2 = center.x + Math.sin(angle) * size;
        double y2 = center.y - Math.cos(angle) * size;
        return new Line(new Point(x1, y1), new Point(x2, y2));
    }

    public double getBestAngle(Img circledImg, int absMinMax, double step, int filterSize, double threshold, Img[] binarized) {
        double maxScore = 0.0;
        double bestAngle = -1.0;
        if (binarized != null) {
            binarized[0] = new Img(new Mat(new Size((double)(2 * absMinMax * 10), 200.0), CvType.CV_8UC1, new Scalar(0.0)), false);
        }
        ArrayList<double[]> results = new ArrayList<double[]>();
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += step) {
            double score = this.score(circledImg, angle, filterSize, threshold);
            if (angle != 0.0 && score > maxScore) {
                maxScore = score;
                bestAngle = angle;
            }
            if (angle != 0.0) {
                results.add(new double[]{angle, score});
            }
            if (binarized == null) continue;
            new Line(((double)absMinMax + angle) * 10.0, 0.0, ((double)absMinMax + angle) * 10.0, score / 1000.0).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0), 1);
        }
        BiFunction<Double, double[], Double> f = (x, params) -> params[0] * x * x * x * x + params[1] * x * x * x + params[2] * x * x + params[3] * x + params[4];
        BiFunction<double[], double[], Double> e = (xy, params) -> (Double)f.apply(xy[0], (double[])params) - xy[1];
        double[] result = new LevenbergImpl<double[]>(e, results, new double[]{1.0, 1.0, 1.0, 1.0, 1.0}).getParams();
        Point point = null;
        double polynomAngle = 0.0;
        double max = 0.0;
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += 1.0) {
            Point oldPoint = point;
            double score = f.apply(angle, result);
            point = new Point(((double)absMinMax + angle) * 10.0, score / 1000.0);
            if (score > max) {
                max = score;
                polynomAngle = angle;
            }
            if (binarized == null || oldPoint == null) continue;
            new Line(oldPoint, point).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0), 1);
        }
        if (binarized != null) {
            Imgproc.circle((Mat)binarized[0].getSrc(), (Point)new Point(((double)absMinMax + polynomAngle) * 10.0, max / 1000.0), (int)10, (Scalar)new Scalar(255.0, 255.0, 0.0), (int)3);
        }
        return polynomAngle;
    }

    public double score(Img circled, double angle, int filterSize, double threshold) {
        Mat M = Imgproc.getRotationMatrix2D((Point)new Point((double)(circled.width() / 2), (double)(circled.width() / 2)), (double)angle, (double)1.0);
        Mat rotated = new Mat();
        Imgproc.warpAffine((Mat)circled.getSrc(), (Mat)rotated, (Mat)M, (Size)new Size((double)circled.width(), (double)circled.width()));
        Img binarized = new Img(rotated, false).directionalFilter(filterSize).thresHold(threshold, 255.0, 0);
        Mat result = new Mat();
        Core.reduce((Mat)binarized.getSrc(), (Mat)result, (int)1, (int)0, (int)6);
        Core.reduce((Mat)result, (Mat)result, (int)0, (int)0, (int)6);
        return result.get(0, 0)[0];
    }

    @Override
    protected void onSpace() {
        this.stabilizationHasChanged = true;
    }

    @Override
    protected void onR() {
        this.fields.reset();
    }

    static Img warpPerspective(Mat frame, Mat homography) {
        Mat dePerspectived = new Mat(frame.size(), 6, Scalar.all((double)255.0));
        Imgproc.warpPerspective((Mat)frame, (Mat)dePerspectived, (Mat)homography, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
        return new Img(dePerspectived, false);
    }

    static double[] getVpFromVp2D(double[] vpImg, double[] pp, double f) {
        double[] vp = new double[]{vpImg[0] / vpImg[2] - pp[0], vpImg[1] / vpImg[2] - pp[1], f};
        if (vp[2] == 0.0) {
            vp[2] = 0.0011;
        }
        double N = Math.sqrt(vp[0] * vp[0] + vp[1] * vp[1] + vp[2] * vp[2]);
        vp[0] = vp[0] * (1.0 / N);
        vp[1] = vp[1] * (1.0 / N);
        vp[2] = vp[2] * (1.0 / N);
        return vp;
    }

    public static double[][] getVp2DFromVps(double[][] vps, double[] pp, double f) {
        double[][] result = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            result[i][0] = vps[i][0] * f / vps[i][2] + pp[0];
            result[i][1] = vps[i][1] * f / vps[i][2] + pp[1];
            result[i][2] = 1.0;
        }
        return result;
    }

    static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    static double det(double[] u, double[] v, double[] w) {
        return u[0] * v[1] * w[2] + u[2] * v[0] * w[1] + u[1] * v[2] * w[0] - u[2] * v[1] * w[0] - u[1] * v[0] * w[2] - u[0] * v[2] * w[1];
    }

    static double[] cross2D(double[] a, double[] b) {
        return CamLiveRetriever.uncalibrate(CamLiveRetriever.cross(a, b));
    }

    static double[] uncalibrate(double[] a) {
        return new double[]{a[0] / a[2], a[1] / a[2], 1.0};
    }

    @Override
    protected void onT() {
        this.textsEnabledMode = !this.textsEnabledMode;
    }

    @Override
    protected void onS() {
        Img image = this.descriptorManager.add(this.deperspectivedImgDescriptor, this.deperspectiveHomography);
        this.savedDisplay = image != null ? image : this.savedDisplay;
    }

    static {
        NativeLibraryLoader.load();
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        counter = 0L;
    }

    public static class Lines
    extends org.genericsystem.cv.utils.Lines {
        public Lines(Mat src) {
            super(src);
        }

        public Lines(Collection<Line> lines) {
            super(lines);
        }

        public Lines filter(Predicate<Line> predicate) {
            return new Lines(this.lines.stream().filter(predicate).collect(Collectors.toList()));
        }

        public Lines reduce(int max) {
            if (this.lines.size() <= max) {
                return this;
            }
            HashSet<Line> newLines = new HashSet<Line>();
            while (newLines.size() < max) {
                newLines.add((Line)this.lines.get((int)(Math.random() * (double)this.size())));
            }
            return new Lines(newLines);
        }
    }

    private static class Circle {
        Point center;
        float radius;

        public Circle(Point center, float radius) {
            this.center = center;
            this.radius = radius;
        }
    }

    public static enum DeperspectivationMode {
        NONE,
        ROTATION,
        FULL;

    }
}

