/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FilenameUtils;
import org.genericsystem.cv.Zone;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Rect;

public class ModelTools {
    public static final String DATE_TIME_FORMAT = "uuuu-MM-dd HH:mm:ss";

    public static void main(String[] args) {
        Path path = Paths.get(System.getProperty("user.home"), "Downloads", "photosafpa.zip");
        File file = path.toFile();
        System.out.println(file.getAbsolutePath());
        if (!file.exists()) {
            System.out.println("File does not exists");
            System.exit(0);
        }
        String hash = ModelTools.hashCode(path);
        String md5 = ModelTools.getHashFromFile(path, "md5");
        String sha1 = ModelTools.getHashFromFile(path, "sha-1");
        String sha256 = ModelTools.getHashFromFile(path, "sha-256");
        String sha512 = ModelTools.getHashFromFile(path, "sha-512");
        System.out.println("hash: " + hash + " - " + hash.length());
        System.out.println("md5: " + md5 + " - " + md5.length());
        System.out.println("sha-1: " + sha1 + " - " + sha1.length());
        System.out.println("sha-256: " + sha256 + " - " + sha256.length());
        System.out.println("sha-512: " + sha512 + " - " + sha512.length());
    }

    public static String getHashFromFile(Path path, String algorithm) throws RuntimeException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
            md.update(Files.readAllBytes(path));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate a hash code (no such algorithm)", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate a hash code (problem reading the file)", e);
        }
        byte[] hash = md.digest();
        return DatatypeConverter.printHexBinary((byte[])hash);
    }

    public static String getHashFromBytes(byte[] bytes, String algorithm) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
            md.update(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate a hash code (no such algorithm)", e);
        }
        byte[] hash = md.digest();
        return DatatypeConverter.printHexBinary((byte[])hash);
    }

    private static String hashCode(Path path) throws RuntimeException {
        int hashCode;
        try {
            hashCode = Arrays.hashCode(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate a hash code (problem reading the file", e);
        }
        return Integer.toHexString(hashCode).toUpperCase();
    }

    public static Long getCurrentDate() {
        LocalDateTime ldt = LocalDateTime.now();
        return ldt.atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
    }

    public static LocalDateTime getCurrentDateFromString(String date) {
        return LocalDateTime.parse(date, DateTimeFormatter.ofPattern(DATE_TIME_FORMAT));
    }

    public static LocalDateTime getCurrentDateFromString(String date, String pattern) {
        return LocalDateTime.parse(date, DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatDate(Long timestamp) {
        return ModelTools.formatDate(timestamp, DATE_TIME_FORMAT);
    }

    public static String formatDate(Long timestamp, String pattern) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.systemDefault());
        return ldt.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String getImgClass(Path imagePath) {
        Path imgClassDirectory = imagePath.getParent();
        String docType = imgClassDirectory.getName(imgClassDirectory.getNameCount() - 1).toString();
        return docType;
    }

    public static String generateFileName(Path filePath) {
        try {
            String filename = ModelTools.getHashFromFile(filePath, "sha-256");
            String filenameExt = filename + "." + FilenameUtils.getExtension((String)filePath.getFileName().toString());
            return filenameExt;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("An error has occured during the generation of the hashcode from file", e);
        }
    }

    public static String generateZoneUID(Zone zone) {
        return ModelTools.generateZoneUID(zone.getRect());
    }

    public static String generateZoneUID(Rect rect) {
        try {
            byte[] bytes = rect.toString().getBytes(Charset.forName("UTF8"));
            String zoneUID = ModelTools.getHashFromBytes(bytes, "sha-256");
            return zoneUID;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("An error has occured during the generation of the hashcode from zone", e);
        }
    }

    public static String generateZoneUID(GSRect rect) {
        try {
            byte[] bytes = rect.toString().getBytes(Charset.forName("UTF8"));
            String zoneUID = ModelTools.getHashFromBytes(bytes, "sha-256");
            return zoneUID;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("An error has occured during the generation of the hashcode from zone", e);
        }
    }
}

