/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.mesh;

import java.util.List;
import org.genericsystem.cv.application.mesh.AbstractMesh;
import org.genericsystem.cv.application.mesh.Points;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;

public class Mesh
extends AbstractMesh<Points.IndexedPoint> {
    private final Points points;

    public Mesh(Points points, int halfWidth, int halfHeight) {
        super(halfWidth, halfHeight);
        this.points = points;
        for (int i = -halfHeight; i < halfHeight; ++i) {
            for (int j = -halfWidth; j < halfWidth; ++j) {
                Points.IndexedPoint leftTop = points.get(i, j);
                Points.IndexedPoint rightTop = points.get(i, j + 1);
                Points.IndexedPoint rightBottom = points.get(i + 1, j + 1);
                Points.IndexedPoint leftBottom = points.get(i + 1, j);
                assert (leftTop != null) : i + " " + j;
                assert (rightTop != null) : i + " " + j;
                assert (rightBottom != null) : i + " " + j;
                assert (leftBottom != null) : i + " " + j;
                this.put(i, j, leftTop, rightTop, rightBottom, leftBottom);
            }
        }
    }

    public Points getPoints() {
        return this.points;
    }

    public List<Point> getPointIndex() {
        return this.points.getPointIndex();
    }

    void draw(Mat img, Scalar meshColor, Scalar ptsColor) {
        for (int i = -this.halfHeight; i < this.halfHeight; ++i) {
            for (int j = -this.halfWidth; j < this.halfWidth; ++j) {
                this.drawPolygon(img, this.getCell(i, j), meshColor, ptsColor);
            }
        }
    }

    Point[] getCell(int i, int j) {
        Points.IndexedPoint[] indexedPts = (Points.IndexedPoint[])this.get(i, j);
        if (indexedPts == null) {
            System.out.println(i + " " + j);
        }
        return new Point[]{indexedPts[0].getPoint(), indexedPts[1].getPoint(), indexedPts[2].getPoint(), indexedPts[3].getPoint()};
    }

    public Mat dewarp(Mat img, Size originalSize) {
        double rectHeight = originalSize.height / (double)(2 * this.halfHeight);
        double rectWidth = originalSize.width / (double)(2 * this.halfWidth);
        Mat dewarpedImage = new Mat(originalSize, CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
        for (int i = -this.halfHeight; i < this.halfHeight; ++i) {
            for (int j = -this.halfWidth; j < this.halfWidth; ++j) {
                this.deWarp(img, dewarpedImage, this.getCell(i, j), (double)(j + this.halfWidth) * rectWidth, (double)(i + this.halfHeight) * rectHeight, rectWidth, rectHeight);
            }
        }
        return dewarpedImage;
    }
}

