/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelTasks {
    private final List<Runnable> tasks;
    private final int counter;

    public ParallelTasks() {
        this(new ArrayList<Runnable>());
    }

    public ParallelTasks(List<Runnable> tasks) {
        this.tasks = tasks;
        this.counter = Runtime.getRuntime().availableProcessors();
    }

    public void add(Runnable task) {
        this.tasks.add(task);
    }

    public void run() throws InterruptedException {
        ExecutorService threads = Executors.newFixedThreadPool(this.counter);
        try {
            CountDownLatch latch = new CountDownLatch(this.tasks.size());
            this.tasks.forEach(task -> threads.execute(() -> {
                try {
                    task.run();
                }
                finally {
                    latch.countDown();
                }
            }));
            latch.await();
        }
        finally {
            threads.shutdown();
        }
    }

    public int getCounter() {
        return this.counter;
    }
}

