/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.LinesDetector;
import org.genericsystem.cv.utils.Line;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Ransac;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class LinesDetector2
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private LinesDetector.Damper damper = new LinesDetector.Damper(10);

    public static void main(String[] args) {
        LinesDetector2.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        this.damper.pushNewValue(0.0);
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskiewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskiewedView, 0, 1);
        Mat dePerspectived = frame.clone();
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(frame);
                Img grad = new Img(frame, false).morphologyEx(4, 0, new Size(2.0, 2.0)).otsu();
                Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 100, 100.0, 10.0));
                System.out.println("Average angle: " + lines.getMean() / Math.PI * 180.0);
                if (lines.size() > 10) {
                    frameView.setImage(Tools.mat2jfxImage(frame));
                    Ransac<Line> ransac = lines.vanishingPointRansac(frame.width(), frame.height());
                    Mat homography = (Mat)ransac.getBestModel().getParams()[0];
                    lines = Lines.of(ransac.getBestDataSet().values());
                    lines = Lines.of(lines.perspectivTransform(homography));
                    System.out.println("Ransac angle : " + (Double)ransac.getBestModel().getParams()[1] / Math.PI * 180.0);
                    Mat mask = new Mat(frame.size(), CvType.CV_8UC1, new Scalar(255.0));
                    Mat maskWarpped = new Mat();
                    Imgproc.warpPerspective((Mat)mask, (Mat)maskWarpped, (Mat)homography, (Size)frame.size());
                    Mat tmp = new Mat();
                    Imgproc.warpPerspective((Mat)frame, (Mat)tmp, (Mat)homography, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    tmp.copyTo(dePerspectived, maskWarpped);
                    lines.draw(dePerspectived, new Scalar(0.0, 255.0, 0.0));
                    deskiewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 33L, 33L, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Lines
    extends org.genericsystem.cv.utils.Lines {
        public Lines(Mat src) {
            super(src);
        }

        public Lines(Collection<Line> lines) {
            super(lines);
        }

        public static Lines of(Collection<Line> lines) {
            return new Lines(lines);
        }

        public Ransac<Line> vanishingPointRansac(int width, int height) {
            Point bary = new Point((double)(width / 2), (double)(height / 2));
            Function modelProvider = datas -> {
                Iterator it = datas.iterator();
                Line line = (Line)it.next();
                double a = (line.getY2() - line.getY1()) / (line.getX2() - line.getX1());
                double b = (line.getY1() + line.getY2() - a * (line.getX1() + line.getX2())) / 2.0;
                Line line2 = (Line)it.next();
                double a2 = (line2.getY2() - line2.getY1()) / (line2.getX2() - line2.getX1());
                double b2 = (line2.getY1() + line2.getY2() - a * (line2.getX1() + line2.getX2())) / 2.0;
                double vpx = (b2 - b) / (a - a2);
                double vpy = a * vpx + b;
                double alpha_ = Math.atan2(vpy - bary.y, vpx - bary.x);
                if (alpha_ < -1.5707963267948966 && alpha_ > -Math.PI) {
                    alpha_ += Math.PI;
                }
                if (alpha_ < Math.PI && alpha_ > 1.5707963267948966) {
                    alpha_ -= Math.PI;
                }
                final double alpha = alpha_;
                final Mat[] homography = new Mat[]{null};
                if (Double.isFinite(alpha)) {
                    Mat matrix = Imgproc.getRotationMatrix2D((Point)bary, (double)(alpha / Math.PI * 180.0), (double)1.0);
                    Mat matrixInv = Imgproc.getRotationMatrix2D((Point)bary, (double)(-alpha / Math.PI * 180.0), (double)1.0);
                    MatOfPoint2f results = new MatOfPoint2f();
                    Core.transform((Mat)new MatOfPoint2f(new Point[]{new Point(line.getX1(), line.getY1()), new Point(line.getX2(), line.getY2())}), (Mat)results, (Mat)matrix);
                    Point[] rotTargets = results.toArray();
                    double newy1 = Math.max(rotTargets[0].y, rotTargets[1].y);
                    MatOfPoint2f resultsInv = new MatOfPoint2f();
                    Core.transform((Mat)new MatOfPoint2f(new Point[]{new Point(rotTargets[0].x, bary.y), new Point(rotTargets[1].x, bary.y)}), (Mat)resultsInv, (Mat)matrixInv);
                    Point[] rotInvTargets = resultsInv.toArray();
                    homography[0] = Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(line.getX1(), line.getY1()), new Point(line.getX2(), line.getY2()), rotInvTargets[1], rotInvTargets[0]}), (Mat)new MatOfPoint2f(new Point[]{new Point(rotTargets[0].x, newy1), new Point(rotTargets[1].x, newy1), new Point(rotTargets[1].x, bary.y), new Point(rotTargets[0].x, bary.y)}));
                }
                return new Ransac.Model<Line>(){

                    @Override
                    public double computeError(Line line) {
                        return Double.isFinite(alpha) ? Math.abs(line.perspectivTransform(homography[0]).getAngle()) : Double.MAX_VALUE;
                    }

                    @Override
                    public double computeGlobalError(List<Line> datas, Collection<Line> consensuDatas) {
                        double error = 0.0;
                        for (Line data : datas) {
                            error += Math.pow(this.computeError(data), 2.0);
                        }
                        return error / (double)datas.size();
                    }

                    @Override
                    public Object[] getParams() {
                        return new Object[]{homography[0], alpha};
                    }
                };
            };
            return new Ransac<Line>(this.lines, modelProvider, 2, 150, 0.05235987755982988, Double.valueOf(Math.floor((double)this.lines.size() * 0.5)).intValue());
        }
    }
}

