/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.lm;

import org.genericsystem.cv.lm.Levenberg;

public class LM {
    private final int LMITER = 6;
    private final double LMBOOST = 2.0;
    private final double LMSHRINK = 0.1;
    private final double LAMBDAZERO = 0.001;
    private final double LAMBDAMAX = 1.0E9;
    private final double LMTOL = 1.0E-5;
    private final double BIGVAL = 9.0E99;
    private double sos;
    private double sosprev;
    private double lambda;
    private final Levenberg myH;
    private final int nadj;
    private final int npts;
    private final double[] delta;
    private final double[] beta;
    private final double[][] alpha;
    private final double[][] amatrix;

    public LM(Levenberg gH, int gnadj, int gnpts) {
        this.myH = gH;
        this.nadj = gnadj;
        this.npts = gnpts;
        this.delta = new double[this.nadj];
        this.beta = new double[this.nadj];
        this.alpha = new double[this.nadj][this.nadj];
        this.amatrix = new double[this.nadj][this.nadj];
        this.lambda = 0.001;
        int niter = 0;
        boolean done = false;
        while (!(done = this.bLMiter()) && ++niter < 6) {
        }
    }

    private boolean bLMiter() {
        int k;
        for (k = 0; k < this.nadj; ++k) {
            this.delta[k] = 0.0;
        }
        this.sos = this.myH.dNudge(this.delta);
        if (this.sos == 9.0E99) {
            System.out.println("  bLMiter finds faulty initial dNudge()");
            return false;
        }
        this.sosprev = this.sos;
        if (!this.myH.bBuildJacobian()) {
            System.out.println("  bLMiter finds bBuildJacobian()=false");
            return false;
        }
        for (k = 0; k < this.nadj; ++k) {
            this.beta[k] = 0.0;
            for (int i = 0; i < this.npts; ++i) {
                int n = k;
                this.beta[n] = this.beta[n] - this.myH.dGetResid(i) * this.myH.dGetJac(i, k);
            }
        }
        for (k = 0; k < this.nadj; ++k) {
            for (int j = 0; j < this.nadj; ++j) {
                this.alpha[j][k] = 0.0;
                for (int i = 0; i < this.npts; ++i) {
                    double[] dArray = this.alpha[j];
                    int n = k;
                    dArray[n] = dArray[n] + this.myH.dGetJac(i, j) * this.myH.dGetJac(i, k);
                }
            }
        }
        double rrise = 0.0;
        do {
            int j;
            int k2;
            for (k2 = 0; k2 < this.nadj; ++k2) {
                for (j = 0; j < this.nadj; ++j) {
                    this.amatrix[j][k2] = this.alpha[j][k2] + (j == k2 ? this.lambda : 0.0);
                }
            }
            this.gaussj(this.amatrix, this.nadj);
            for (k2 = 0; k2 < this.nadj; ++k2) {
                this.delta[k2] = 0.0;
                for (j = 0; j < this.nadj; ++j) {
                    int n = k2;
                    this.delta[n] = this.delta[n] + this.amatrix[j][k2] * this.beta[j];
                }
            }
            this.sos = this.myH.dNudge(this.delta);
            if (this.sos == 9.0E99) {
                System.out.println("  LMinner failed SOS step");
                return false;
            }
            rrise = (this.sos - this.sosprev) / (1.0 + this.sos);
            if (rrise <= 0.0) {
                this.lambda *= 0.1;
                break;
            }
            int q = 0;
            while (q < this.nadj) {
                int n = q++;
                this.delta[n] = this.delta[n] * -1.0;
            }
            this.myH.dNudge(this.delta);
            if (rrise < 1.0E-5) break;
            this.lambda *= 2.0;
        } while (this.lambda < 1.0E9);
        boolean done = rrise > -1.0E-5 || this.lambda > 1.0E9;
        return done;
    }

    private double gaussj(double[][] a, int N) {
        double save;
        int j;
        int i;
        int k;
        double det = 1.0;
        int[] ik = new int[100];
        int[] jk = new int[100];
        for (k = 0; k < N; ++k) {
            double big = 0.0;
            for (i = k; i < N; ++i) {
                for (j = k; j < N; ++j) {
                    if (!(Math.abs(big) <= Math.abs(a[i][j]))) continue;
                    big = a[i][j];
                    ik[k] = i;
                    jk[k] = j;
                }
            }
            if (big == 0.0) {
                return 0.0;
            }
            i = ik[k];
            if (i > k) {
                for (j = 0; j < N; ++j) {
                    save = a[k][j];
                    a[k][j] = a[i][j];
                    a[i][j] = -save;
                }
            }
            if ((j = jk[k]) > k) {
                for (i = 0; i < N; ++i) {
                    save = a[i][k];
                    a[i][k] = a[i][j];
                    a[i][j] = -save;
                }
            }
            for (i = 0; i < N; ++i) {
                if (i == k) continue;
                a[i][k] = -a[i][k] / big;
            }
            for (i = 0; i < N; ++i) {
                for (j = 0; j < N; ++j) {
                    if (i == k || j == k) continue;
                    double[] dArray = a[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * a[k][j];
                }
            }
            for (j = 0; j < N; ++j) {
                if (j == k) continue;
                double[] dArray = a[k];
                int n = j;
                dArray[n] = dArray[n] / big;
            }
            a[k][k] = 1.0 / big;
            det *= big;
        }
        for (int L = 0; L < N; ++L) {
            k = N - L - 1;
            j = ik[k];
            if (j > k) {
                for (i = 0; i < N; ++i) {
                    save = a[i][k];
                    a[i][k] = -a[i][j];
                    a[i][j] = save;
                }
            }
            if ((i = jk[k]) <= k) continue;
            for (j = 0; j < N; ++j) {
                save = a[k][j];
                a[k][j] = -a[i][j];
                a[i][j] = save;
            }
        }
        return det;
    }
}

