/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.opencv.ml.SVM;

public class Svm {
    private static final String imgClassDirectory = "tmp";

    public static void main(String[] args) {
        Mat classes = new Mat();
        Mat trainingData = new Mat();
        Mat trainingImages = new Mat();
        Mat trainingLabels = new Mat();
        Size size = new Size(128.0, 128.0);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(".", "classes"), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            int imgClass = 0;
            for (Path directoryPath : directoryStream) {
                System.out.println("--- Images of class: " + directoryPath);
                int imgClass_ = imgClass++;
                try (DirectoryStream<Path> imagesStream = Files.newDirectoryStream(directoryPath, path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".png"));){
                    imagesStream.forEach(path -> {
                        System.out.println("------ Image: " + path + " image class : " + imgClass_);
                        Mat img = Imgcodecs.imread((String)path.toString());
                        Imgproc.resize((Mat)img, (Mat)img, (Size)size);
                        img = img.reshape(1, 1);
                        trainingImages.push_back(img);
                        trainingLabels.push_back(new Mat(new Size(1.0, 1.0), 4, new Scalar((double)imgClass_)));
                    });
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        trainingImages.convertTo(trainingData, CvType.CV_32FC1);
        trainingLabels.copyTo(classes);
        SVM clasificador = SVM.create();
        clasificador.setType(100);
        clasificador.setTermCriteria(new TermCriteria(1, 100, 1.0E-6));
        clasificador.setKernel(0);
        clasificador.train(trainingData, 0, trainingLabels);
        for (File file : new File("tmp/samples/").listFiles()) {
            if (!file.getName().endsWith(".png")) continue;
            Mat img = Imgcodecs.imread((String)file.getPath());
            Imgproc.resize((Mat)img, (Mat)img, (Size)size);
            img = img.reshape(1, 1);
            img.convertTo(img, CvType.CV_32FC1);
            System.out.println(file.getName() + " : " + clasificador.predict(img));
        }
    }

    static {
        NativeLibraryLoader.load();
    }
}

