/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;
import org.opencv.videoio.VideoCapture;

public class LinesDetector8
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private double[] vp = new double[]{0.0, 0.0, 1.0};
    private Calibrated.AngleCalibrated calibrated;
    static final double f = 672.5555555555555;
    private Mat frame = new Mat();

    public static void main(String[] args) {
        LinesDetector8.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        this.capture.read(this.frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(this.frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskiewedView = new ImageView(Tools.mat2jfxImage(this.frame));
        mainGrid.add((Node)deskiewedView, 0, 1);
        Mat dePerspectived = this.frame.clone();
        double[] pp = new double[]{this.frame.width() / 2, this.frame.height() / 2};
        this.calibrated = new Calibrated.AngleCalibrated(0.0, 1.5707963267948966);
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(this.frame);
                Img grad = new Img(this.frame, false).morphologyEx(4, 2, new Size(2.0, 2.0)).otsu().morphologyEx(3, 2, new Size(3.0, 3.0));
                Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 100.0, 10.0));
                if (lines.size() > 10) {
                    lines.draw(this.frame, new Scalar(0.0, 0.0, 255.0));
                    Lines filtered = lines.filter(line -> this.distance(this.calibrated.getCalibratexyz(), (Line)line, pp, 672.5555555555555) < 0.1);
                    filtered.draw(this.frame, new Scalar(0.0, 255.0, 0.0));
                    frameView.setImage(Tools.mat2jfxImage(this.frame));
                    double[] thetaphi = new LevenbergImpl<Line>((line, params) -> this.distance(new Calibrated.AngleCalibrated((double[])params).getCalibratexyz(), (Line)line, pp, 672.5555555555555), lines.lines, this.calibrated.getThetaPhi()).getParams();
                    this.calibrated = this.calibrated.dumpThetaPhi(thetaphi, 1);
                    this.vp = this.calibrated.uncalibrate(pp, 672.5555555555555);
                    System.out.println("Vanishing point : " + Arrays.toString(this.vp));
                    Mat homography = LinesDetector8.findHomography(this.frame.size(), new Calibrated.AngleCalibrated[]{this.calibrated, new Calibrated.AngleCalibrated(new double[]{this.calibrated.getTheta() + 1.5707963267948966, 1.5707963267948966}), new Calibrated.AngleCalibrated(new double[]{1.5707963267948966, 0.0})}, pp, 672.5555555555555);
                    Imgproc.warpPerspective((Mat)this.frame, (Mat)dePerspectived, (Mat)homography, (Size)this.frame.size(), (int)1, (int)0, (Scalar)Scalar.all((double)0.0));
                    deskiewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 10L, TimeUnit.MILLISECONDS);
    }

    public static Mat findHomography(Size size, Calibrated.AngleCalibrated[] calibrateds, double[] pp, double f) {
        double[][] vps = new double[][]{calibrateds[0].getCalibratexyz(), calibrateds[1].getCalibratexyz(), calibrateds[2].getCalibratexyz()};
        double[][] vps2D = LinesDetector8.getVp2DFromVps(vps, pp, f);
        System.out.println("vps2D : " + Arrays.deepToString((Object[])vps2D));
        System.out.println("vp1 " + calibrateds[0]);
        System.out.println("vp2 " + calibrateds[1]);
        System.out.println("vp3 " + calibrateds[2]);
        double theta = calibrateds[0].getTheta();
        double theta2 = calibrateds[1].getTheta();
        double x = size.width / 6.0;
        double[] A = new double[]{size.width / 2.0, size.height / 2.0, 1.0};
        double[] B = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0};
        double[] D = new double[]{size.width / 2.0, size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x), 1.0};
        double[] C = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x)};
        double[] A_ = A;
        double[] B_ = new double[]{size.width / 2.0 + x * vps[0][0], size.height / 2.0 + x * vps[0][1], 1.0};
        double[] D_ = new double[]{size.width / 2.0 + x * vps[1][0], size.height / 2.0 + x * vps[1][1], 1.0};
        double[] C_ = LinesDetector8.cross2D(LinesDetector8.cross(B_, vps2D[1]), LinesDetector8.cross(D_, vps2D[0]));
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(A_), new Point(B_), new Point(C_), new Point(D_)}), (Mat)new MatOfPoint2f(new Point[]{new Point(A), new Point(B), new Point(C), new Point(D)}));
    }

    public static double[][] getVp2DFromVps(double[][] vps, double[] pp, double f) {
        double[][] result = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            result[i][0] = vps[i][0] * f / vps[i][2] + pp[0];
            result[i][1] = vps[i][1] * f / vps[i][2] + pp[1];
            result[i][2] = 1.0;
        }
        return result;
    }

    private double distance(double[] calibratedxyz, Line line, double[] pp, double f) {
        double[] lineMat = LinesDetector8.cross(Calibrated.calibrate(new double[]{line.x1, line.y1, 1.0}, pp, f), Calibrated.calibrate(new double[]{line.x2, line.y2, 1.0}, pp, f));
        double di = calibratedxyz[0] * lineMat[0] + calibratedxyz[1] * lineMat[1] + calibratedxyz[2] * lineMat[2];
        double normLineMat = Math.sqrt(lineMat[0] * lineMat[0] + lineMat[1] * lineMat[1] + lineMat[2] * lineMat[2]);
        return (di /= Math.sqrt(calibratedxyz[0] * calibratedxyz[0] + calibratedxyz[1] * calibratedxyz[1] + calibratedxyz[2] * calibratedxyz[2]) * normLineMat) * di > 0.1 ? 0.1 : di * di;
    }

    static double[] cross2D(double[] a, double[] b) {
        return LinesDetector8.uncalibrate(LinesDetector8.cross(a, b));
    }

    static double[] uncalibrate(double[] a) {
        return new double[]{a[0] / a[2], a[1] / a[2], 1.0};
    }

    static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    public Point[] rotate(Point bary, double alpha, Point ... p) {
        Mat matrix = Imgproc.getRotationMatrix2D((Point)bary, (double)(alpha / Math.PI * 180.0), (double)1.0);
        MatOfPoint2f results = new MatOfPoint2f();
        Core.transform((Mat)new MatOfPoint2f(p), (Mat)results, (Mat)matrix);
        return results.toArray();
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Line {
        final double x1;
        final double y1;
        final double x2;
        final double y2;

        public Line(Point p1, Point p2) {
            this(p1.x, p1.y, p2.x, p2.y);
        }

        public Line(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }

        public double size() {
            return Math.sqrt(Math.pow(this.y2 - this.y1, 2.0) + Math.pow(this.x2 - this.x1, 2.0));
        }

        public Line transform(Mat rotationMatrix) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.transform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)rotationMatrix);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public Line perspectivTransform(Mat homography) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.perspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)homography);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public void draw(Mat frame, Scalar color) {
            this.draw(frame, color, 1);
        }

        public void draw(Mat frame, Scalar color, int thickness) {
            Imgproc.line((Mat)frame, (Point)new Point(this.x1, this.y1), (Point)new Point(this.x2, this.y2), (Scalar)color, (int)thickness);
        }

        public double geta() {
            return (this.y2 - this.y1) / (this.x2 - this.x1);
        }

        public double getb() {
            return this.y1 - this.geta() * this.x1;
        }

        public double distance(Point p) {
            return Math.abs(this.geta() * p.x - p.y + this.getb()) / Math.sqrt(1.0 + Math.pow(this.geta(), 2.0));
        }

        public Point intersection(double a, double b) {
            double x = (b - this.getb()) / (this.geta() - a);
            double y = a * x + b;
            return new Point(x, y);
        }

        public Point intersection(Line line) {
            double x = (line.getb() - this.getb()) / (this.geta() - line.geta());
            double y = this.geta() * x + this.getb();
            return new Point(x, y);
        }

        public Point intersection(double verticalLinex) {
            double x = verticalLinex;
            double y = this.geta() * x + this.getb();
            return new Point(x, y);
        }
    }

    public static class Lines {
        final List<Line> lines;

        public Lines(Mat src) {
            this.lines = new ArrayList<Line>();
            for (int i = 0; i < src.rows(); ++i) {
                double[] val = src.get(i, 0);
                Line line = new Line(val[0], val[1], val[2], val[3]);
                this.lines.add(line);
            }
        }

        public Lines filter(Predicate<Line> predicate) {
            return new Lines(this.lines.stream().filter(predicate).collect(Collectors.toList()));
        }

        public Lines reduce(int max) {
            if (this.lines.size() <= max) {
                return this;
            }
            HashSet<Line> newLines = new HashSet<Line>();
            while (newLines.size() < max) {
                newLines.add(this.lines.get((int)(Math.random() * (double)this.size())));
            }
            return new Lines(newLines);
        }

        public Lines(Collection<Line> lines) {
            this.lines = new ArrayList<Line>(lines);
        }

        public Lines rotate(Mat matrix) {
            return new Lines(this.lines.stream().map(line -> line.transform(matrix)).collect(Collectors.toList()));
        }

        public Lines perspectivTransform(Mat matrix) {
            return new Lines(this.lines.stream().map(line -> line.perspectivTransform(matrix)).collect(Collectors.toList()));
        }

        public void draw(Mat frame, Scalar color) {
            this.lines.forEach(line -> line.draw(frame, color));
        }

        public int size() {
            return this.lines.size();
        }
    }
}

