/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import org.genericsystem.cv.Img;
import org.opencv.core.Mat;
import org.opencv.imgcodecs.Imgcodecs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewClassCreator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path createNewClass(Path classesDirectory, Path imgPath) {
        Path newClassDir = null;
        Class<NewClassCreator> clazz = NewClassCreator.class;
        synchronized (NewClassCreator.class) {
            newClassDir = classesDirectory.resolve(String.valueOf(System.nanoTime()));
            newClassDir.toFile().mkdirs();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Path savedFile = newClassDir.resolve(imgPath.getFileName());
            try (Img img = new Img(imgPath.toString());){
                Object object = NewClassCreator.class;
                synchronized (NewClassCreator.class) {
                    if (savedFile.toFile().exists()) {
                        String[] fileNameParts = imgPath.getFileName().toString().split("\\.(?=[^\\.]+$)");
                        savedFile = File.createTempFile(fileNameParts[0] + "-", "." + fileNameParts[1], newClassDir.toFile()).toPath();
                    }
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    Imgcodecs.imwrite((String)savedFile.toString(), (Mat)img.getSrc());
                    logger.debug("Saved file {} in class {}", (Object)imgPath.getFileName(), (Object)newClassDir);
                    object = savedFile;
                    return object;
                }
            }
            catch (IOException e) {
                logger.error("Error while saving image {} in class {}.", new Object[]{e, imgPath.getFileName(), newClassDir});
                return null;
            }
        }
    }
}

