/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.cv.application.OrientedPoint;
import org.genericsystem.cv.application.TrajectStep;
import org.opencv.core.Point;

public class ProjectionLines {
    public static List<List<OrientedPoint>[]> toHorizontalsOrientedPoints(List<List<TrajectStep>> trajectSteps, double vStep, double localTheshold, double globalTheshold) {
        ArrayList<List<OrientedPoint>[]> fhtHorizontals = new ArrayList<List<OrientedPoint>[]>();
        for (int vStripIndex = 0; vStripIndex < trajectSteps.size(); ++vStripIndex) {
            fhtHorizontals.add(ProjectionLines.toHorizontalOrientedPoints(trajectSteps.get(vStripIndex), vStep * (double)vStripIndex, localTheshold, globalTheshold));
        }
        return fhtHorizontals;
    }

    private static List<OrientedPoint>[] toHorizontalOrientedPoints(List<TrajectStep> trajectSteps, double x, double localTheshold, double globalTheshold) {
        ArrayList topPoints = new ArrayList();
        ArrayList bottomPoints = new ArrayList();
        List<TrajectStep[]> lines = ProjectionLines.getStripLinesFHT(trajectSteps, localTheshold, globalTheshold);
        lines.stream().forEach(trajectStep -> {
            topPoints.add(new OrientedPoint(new Point(x, (double)trajectStep[0].y), Math.atan(trajectStep[0].derivative), trajectStep[0].magnitude, trajectStep[0].derivative));
            bottomPoints.add(new OrientedPoint(new Point(x, (double)trajectStep[1].y), Math.atan(trajectStep[1].derivative), trajectStep[1].magnitude, trajectStep[1].derivative));
        });
        return new List[]{topPoints, bottomPoints};
    }

    public static List<List<OrientedPoint>[]> toVerticalsOrientedPoints(List<List<TrajectStep>> trajectSteps, double hStep, double localTheshold, double globalTheshold) {
        ArrayList<List<OrientedPoint>[]> fhtHorizontals = new ArrayList<List<OrientedPoint>[]>();
        for (int vStripIndex = 0; vStripIndex < trajectSteps.size(); ++vStripIndex) {
            fhtHorizontals.add(ProjectionLines.toVerticalOrientedPoints(trajectSteps.get(vStripIndex), hStep * (double)vStripIndex, localTheshold, globalTheshold));
        }
        return fhtHorizontals;
    }

    private static List<OrientedPoint>[] toVerticalOrientedPoints(List<TrajectStep> trajectSteps, double y, double localTheshold, double globalTheshold) {
        ArrayList leftPoints = new ArrayList();
        ArrayList rightPoints = new ArrayList();
        List<TrajectStep[]> lines = ProjectionLines.getStripLinesFHT(trajectSteps, localTheshold, globalTheshold);
        lines.stream().forEach(trajectStep -> {
            leftPoints.add(new OrientedPoint(new Point((double)trajectStep[0].y, y), -Math.atan(trajectStep[0].derivative), trajectStep[0].magnitude, trajectStep[0].derivative));
            rightPoints.add(new OrientedPoint(new Point((double)trajectStep[1].y, y), -Math.atan(trajectStep[1].derivative), trajectStep[1].magnitude, trajectStep[1].derivative));
        });
        return new List[]{leftPoints, rightPoints};
    }

    public static List<TrajectStep[]> getStripLinesFHT(List<TrajectStep> magnitudes, double localTheshold, double globalTheshold) {
        HashSet<TrajectStep> alreadyComputed = new HashSet<TrajectStep>();
        double max = magnitudes.stream().mapToDouble(ts -> ts.magnitude).max().getAsDouble();
        ArrayList<TrajectStep[]> result = new ArrayList<TrajectStep[]>();
        for (TrajectStep trajectStep : magnitudes.stream().sorted().collect(Collectors.toList())) {
            int y;
            int y2;
            int y1;
            if (trajectStep.magnitude < globalTheshold * max) break;
            if (alreadyComputed.contains(trajectStep)) continue;
            double tAlpha = localTheshold * trajectStep.magnitude;
            for (y1 = trajectStep.y; y1 >= 0 && magnitudes.get((int)y1).magnitude >= tAlpha; --y1) {
            }
            if (y1 != 0) {
                ++y1;
            }
            for (y2 = trajectStep.y; y2 < magnitudes.size() && magnitudes.get((int)y2).magnitude >= tAlpha; ++y2) {
            }
            if (y2 != magnitudes.size() - 1) {
                --y2;
            }
            boolean alreadyVisited = false;
            for (y = y1; y <= y2; ++y) {
                if (!alreadyComputed.contains(magnitudes.get(y))) continue;
                alreadyVisited = true;
                break;
            }
            for (y = y1; y <= y2; ++y) {
                alreadyComputed.add(magnitudes.get(y));
            }
            if (alreadyVisited) continue;
            result.add(new TrajectStep[]{magnitudes.get(y1), magnitudes.get(y2)});
        }
        return result;
    }
}

