/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Ocr;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.fht.FHTManager;
import org.genericsystem.cv.application.stabilizer.ImgDescriptor;
import org.genericsystem.cv.application.stabilizer.ReferenceManager;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.features2d.MSER;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class GraphicApp
extends AbstractApp {
    private final GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame;
    private ReferenceManager referenceManager;
    private Config config = new Config();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private FHTManager fhtManager = new FHTManager(this.gsCapture.getResize());
    private ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3]};
    private int frameCount = 0;
    private final MSER detector = MSER.create((int)1, (int)6, (int)50, (double)1.0, (double)0.2, (int)200, (double)1.01, (double)0.03, (int)5);
    private final QualityManager qualityManager = new QualityManager(3, 1.0);
    private DoubleProperty sigma = new SimpleDoubleProperty(2.0);
    private DoubleProperty threshold = new SimpleDoubleProperty(5.0);
    private DoubleProperty amount = new SimpleDoubleProperty(2.0);
    private DoubleProperty sharpConvLevel = new SimpleDoubleProperty(0.0);

    public static void main(String[] args) {
        GraphicApp.launch((String[])args);
    }

    public GraphicApp() {
        this.frame = this.gsCapture.read();
        this.referenceManager = new ReferenceManager(this.gsCapture.getResize());
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        this.addDoubleSliderProperty("sharp sigma", this.sigma, 0.0, 5.0);
        this.addDoubleSliderProperty("threshold", this.threshold, 0.0, 10.0);
        this.addDoubleSliderProperty("amount", this.amount, 0.0, 5.0);
        this.addDoubleSliderProperty("sharp conv level", this.sharpConvLevel, 0.0, 10.0);
        double displaySizeReduction = 1.0;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 2000L, 50L, TimeUnit.MILLISECONDS);
    }

    public boolean contains(Rect rect, Rect shiftedRect) {
        return rect.tl().x <= shiftedRect.tl().x && rect.tl().y <= shiftedRect.tl().y && rect.br().x >= shiftedRect.br().x && rect.br().y >= shiftedRect.br().y;
    }

    private Mat sharpen(Mat img, double sigma, double threshold, double amount) {
        Mat blurred = new Mat();
        Imgproc.GaussianBlur((Mat)img, (Mat)blurred, (Size)new Size(0.0, 0.0), (double)sigma, (double)sigma);
        Mat lowContrastMask = new Mat();
        Core.absdiff((Mat)img, (Mat)blurred, (Mat)lowContrastMask);
        Imgproc.threshold((Mat)lowContrastMask, (Mat)lowContrastMask, (double)threshold, (double)255.0, (int)1);
        Mat sharpened = new Mat();
        Core.addWeighted((Mat)img, (double)(1.0 + amount), (Mat)blurred, (double)(-amount), (double)0.0, (Mat)sharpened);
        img.copyTo(sharpened, lowContrastMask);
        return sharpened;
    }

    private Mat sharpen2(Mat img, double alpha) {
        Mat sharpenConv = Mat.zeros((Size)new Size(3.0, 3.0), (int)CvType.CV_64FC1);
        sharpenConv.put(0, 1, new double[]{-alpha / 4.0});
        sharpenConv.put(1, 0, new double[]{-alpha / 4.0});
        sharpenConv.put(1, 1, new double[]{alpha + 1.0});
        sharpenConv.put(1, 2, new double[]{-alpha / 4.0});
        sharpenConv.put(2, 1, new double[]{-alpha / 4.0});
        Mat sharpen = new Mat();
        Imgproc.filter2D((Mat)img, (Mat)sharpen, (int)-1, (Mat)sharpenConv);
        return sharpen;
    }

    private boolean isOverlapping(Rect first, Rect other) {
        return first.tl().x < other.br().x && other.tl().x < first.br().x && first.tl().y < other.br().y && other.tl().y < first.br().y;
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
            ++this.frameCount;
        }
        long ref = System.currentTimeMillis();
        Img gray = this.frame.bgr2Gray();
        if (!this.qualityManager.filter(gray.getSrc())) {
            System.out.println("Not enough quality");
            return null;
        }
        Image[] images = new Image[10];
        images[0] = this.frame.toJfxImage();
        if (this.frameCount < 30) {
            return images;
        }
        Img binarized = this.frame.adaptativeGaussianInvThreshold(7, 5.0);
        Img flat = new Img(this.fhtManager.init(binarized.getSrc()).dewarp(this.frame.getSrc()), false);
        images[1] = flat.toJfxImage();
        ref = this.trace("Dewarp", ref);
        Mat flatSharpened = this.sharpen(flat.getSrc(), this.sigma.get(), this.threshold.get(), this.amount.get());
        Img flatSharpImg = new Img(flatSharpened, false);
        images[1] = flatSharpImg.toJfxImage();
        Img flatGray = flat.bgr2Gray();
        Mat flatBinarized = new Mat();
        Imgproc.adaptiveThreshold((Mat)flatGray.getSrc(), (Mat)flatBinarized, (double)255.0, (int)1, (int)1, (int)7, (double)5.0);
        images[2] = new Img(flatBinarized, false).toJfxImage();
        ArrayList regions = new ArrayList();
        MatOfRect mor = new MatOfRect();
        this.detector.detectRegions(flat.bgr2Gray().getSrc(), regions, mor);
        ArrayList rects = new ArrayList();
        Converters.Mat_to_vector_Rect((Mat)mor, rects);
        List<Rect> distinctRects = rects.stream().distinct().collect(Collectors.toList());
        Mat dislayMser = flatSharpImg.getSrc().clone();
        distinctRects.removeIf(rect -> {
            for (Rect other : distinctRects) {
                if (other.equals(rect) || !this.contains(other, (Rect)rect)) continue;
                return true;
            }
            return false;
        });
        distinctRects.sort((rect1, rect2) -> Double.compare(rect1.area(), rect2.area()));
        distinctRects.removeIf(rect -> {
            List<Rect> overlappings = distinctRects.stream().filter(other -> !other.equals(rect) && this.isOverlapping((Rect)rect, (Rect)other)).collect(Collectors.toList());
            if (overlappings.size() > 1) {
                System.out.println("------------------");
                overlappings.forEach(overlap -> System.out.println("Blue : " + overlap));
                System.out.println("Red : " + rect);
                Imgproc.rectangle((Mat)dislayMser, (Rect)rect, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
                return true;
            }
            return false;
        });
        distinctRects.forEach(rect -> Imgproc.rectangle((Mat)dislayMser, (Rect)rect, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1));
        images[3] = new Img(dislayMser, false).toJfxImage();
        List<RectSpan> spans = this.assemble(distinctRects, 25.0, 10.0);
        List<Rect> spanRects = spans.stream().map(span -> span.getRect()).collect(Collectors.toList());
        Mat assembleMask = Mat.zeros((Size)flat.size(), (int)CvType.CV_8UC3);
        spans.forEach(span -> {
            Scalar color = new Scalar(Math.random() * 255.0, Math.random() * 255.0, Math.random() * 255.0);
            span.getRects().forEach(superRect -> Imgproc.rectangle((Mat)assembleMask, (Rect)((SuperRect)superRect).rect, (Scalar)color, (int)-1));
            Imgproc.rectangle((Mat)assembleMask, (Rect)span.getRect(), (Scalar)color, (int)1);
        });
        images[4] = new Img(assembleMask, false).toJfxImage();
        ref = this.trace("Assemblage", ref);
        Mat spanMask = Mat.zeros((Size)flat.size(), (int)CvType.CV_8UC1);
        spanRects.forEach(rect -> Imgproc.rectangle((Mat)spanMask, (Rect)rect, (Scalar)new Scalar(255.0), (int)-1));
        Mat flatDisplay = Mat.zeros((Size)flat.size(), (int)flat.type());
        flatSharpImg.getSrc().copyTo(flatDisplay, spanMask);
        spanRects.forEach(rect -> Imgproc.rectangle((Mat)flatDisplay, (Point)rect.tl(), (Point)rect.br(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1));
        images[5] = new Img(flatDisplay, false).toJfxImage();
        ref = this.trace("Close mask", ref);
        Mat flatDisplay2 = Mat.zeros((Size)flat.size(), (int)flat.type());
        Labels labels = new Labels(spanRects);
        labels.ocr(flatSharpened, 10, 1, 2, 2);
        labels.putOcr(flatDisplay2);
        Imgproc.putText((Mat)flatDisplay2, (String)("Quality : " + (int)QualityManager.quality(flatSharpImg.bgr2Gray().getSrc())), (Point)new Point(50.0, 50.0), (int)1, (double)1.0, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
        images[6] = new Img(flatDisplay2, false).toJfxImage();
        ref = this.trace("Ocr", ref);
        ImgDescriptor newImgDescriptor = new ImgDescriptor(flat);
        if (newImgDescriptor.getDescriptors().empty()) {
            System.out.println("Empty descriptors");
            return null;
        }
        this.referenceManager.submit(newImgDescriptor);
        List<Rect> referenceRects = this.referenceManager.getReferenceRects();
        Mat referenceTemplate = Mat.zeros((Size)flat.size(), (int)CvType.CV_8UC1);
        referenceRects.forEach(rect -> Imgproc.rectangle((Mat)referenceTemplate, (Rect)rect, (Scalar)new Scalar(255.0), (int)-1));
        images[7] = new Img(referenceTemplate, false).toJfxImage();
        Mat display = Mat.zeros((Size)this.frame.size(), (int)CvType.CV_8UC1);
        this.referenceManager.getResizedFieldsRects().forEach(rect -> Imgproc.rectangle((Mat)display, (Rect)rect, (Scalar)new Scalar(255.0), (int)-1));
        images[8] = new Img(display, false).toJfxImage();
        return images;
    }

    /*
     * WARNING - void declaration
     */
    private List<RectSpan> assemble(List<Rect> rects, double maxConnectedDistance, double alignTolerance) {
        List superRects = rects.stream().map(SuperRect::new).collect(Collectors.toList());
        Collections.sort(superRects);
        System.out.println("superRects size " + superRects.size());
        List<Object> connectedRectsList = new ArrayList();
        for (int i = 0; i < superRects.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                SuperRect rect2;
                if (i == j) continue;
                SuperRect rect1 = (SuperRect)superRects.get(i);
                if (rect1.compareTo(rect2 = (SuperRect)superRects.get(j)) < 0) {
                    SuperRect tmp = rect1;
                    rect1 = rect2;
                    rect2 = tmp;
                }
                if (!this.yOverlaps(((SuperRect)rect1).rect.tl().y, ((SuperRect)rect1).rect.br().y, ((SuperRect)rect2).rect.tl().y, ((SuperRect)rect2).rect.br().y, alignTolerance)) continue;
                connectedRectsList.add(new ConnectedRects(rect1, rect2));
            }
        }
        connectedRectsList = connectedRectsList.stream().filter(connectedRects -> ((ConnectedRects)connectedRects).distance() < maxConnectedDistance).collect(Collectors.toList());
        System.out.println("connectedRectsList size " + connectedRectsList.size());
        Collections.sort(connectedRectsList);
        for (ConnectedRects connectedRects2 : connectedRectsList) {
            if (connectedRects2.getRect1().succ != null || connectedRects2.getRect2().pred != null) continue;
            connectedRects2.getRect1().succ = connectedRects2.getRect2();
            connectedRects2.getRect2().pred = connectedRects2.getRect1();
        }
        ArrayList<RectSpan> spans = new ArrayList<RectSpan>();
        while (!superRects.isEmpty()) {
            void var9_14;
            void var9_12;
            SuperRect superRect = (SuperRect)superRects.get(0);
            while (var9_12.pred != null) {
                SuperRect superRect2 = var9_12.pred;
            }
            RectSpan curSpan = new RectSpan();
            while (var9_14 != null) {
                superRects.remove(var9_14);
                curSpan.add((SuperRect)var9_14);
                SuperRect superRect3 = var9_14.succ;
            }
            if (curSpan.getRects().size() <= 1) continue;
            spans.add(curSpan);
        }
        return spans;
    }

    private boolean yOverlaps(double top1, double bottom1, double top2, double bottom2, double alignTolerance) {
        return !(bottom1 + alignTolerance < top2) && !(bottom2 + alignTolerance < top1);
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onR() {
        this.timer.schedule(() -> this.referenceManager.clear(), 0L, TimeUnit.MILLISECONDS);
    }

    List<Rect> detectRects(Mat mask, int minArea, int maxArea) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)mask, contours, (Mat)new Mat(), (int)0, (int)2);
        Size size = mask.size();
        ArrayList<Rect> result = new ArrayList<Rect>();
        for (MatOfPoint contour : contours) {
            double area = Imgproc.contourArea((Mat)contour);
            if (!(area >= (double)minArea) || !(area <= (double)maxArea)) continue;
            Rect rect = Imgproc.boundingRect((MatOfPoint)contour);
            result.add(rect);
        }
        Collections.reverse(result);
        return result;
    }

    public double getFillRatio(MatOfPoint contour, Rect rect) {
        Mat mask = Mat.zeros((Size)rect.size(), (int)CvType.CV_8UC1);
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0), (int)-1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        Mat mat = new Mat();
        Core.findNonZero((Mat)mask, (Mat)mat);
        return (double)mat.rows() / rect.area();
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Labels {
        private final List<Label> labels;

        public Labels(List<Rect> rects) {
            this.labels = rects.stream().map(Label::new).collect(Collectors.toList());
        }

        public Labels(Labels labels) {
            this.labels = new ArrayList<Label>(labels.getLabels());
        }

        public void putOcr(Mat img) {
            this.getLabels().forEach(field -> field.putOcr(img));
        }

        public void ocr(Mat img, int confidence, int componentLevel, int dx, int dy) {
            this.getLabels().forEach(field -> field.ocr(img, confidence, componentLevel, dx, dy));
        }

        public List<Label> getLabels() {
            return this.labels;
        }
    }

    public static class Label {
        private final Rect rect;
        private String label;

        public Label(Rect rect) {
            this.rect = rect;
        }

        public void ocr(Mat img, int confidence, int componentLevel, int dx, int dy) {
            double newTlx = this.rect.tl().x - (double)dx >= 0.0 ? this.rect.tl().x - (double)dx : 0.0;
            double newTly = this.rect.tl().y - (double)dy >= 0.0 ? this.rect.tl().y - (double)dy : 0.0;
            double newBrx = this.rect.br().x + (double)dx <= (double)img.width() ? this.rect.br().x + (double)dx : (double)img.width();
            double newBry = this.rect.br().y + (double)dy <= (double)img.height() ? this.rect.br().y + (double)dy : (double)img.height();
            Mat roi = new Mat(img, new Rect(new Point(newTlx, newTly), new Point(newBrx, newBry)));
            this.label = Ocr.doWork(roi, confidence, componentLevel);
        }

        public void putOcr(Mat img) {
            String normalizedText = Normalizer.normalize(this.label, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            int[] baseLine = new int[1];
            Size size = Imgproc.getTextSize((String)normalizedText, (int)1, (double)1.0, (int)1, (int[])baseLine);
            double scale = Math.min((double)this.rect.width / size.width, (double)this.rect.height / size.height);
            if (scale < 0.5) {
                scale = 0.5;
            }
            if (scale > 2.0) {
                scale = 2.0;
            }
            Imgproc.putText((Mat)img, (String)normalizedText, (Point)new Point(this.rect.tl().x, this.rect.br().y), (int)1, (double)scale, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
        }

        public String getLabel() {
            return this.label;
        }

        public Rect getRect() {
            return this.rect;
        }
    }

    private static class SuperRect
    implements Comparable<SuperRect> {
        private final Rect rect;
        public SuperRect pred;
        public SuperRect succ;

        public SuperRect(Rect rect) {
            this.rect = rect;
        }

        @Override
        public int compareTo(SuperRect sr) {
            int xCompare = Double.compare(sr.rect.br().x + sr.rect.tl().x, this.rect.br().x + this.rect.tl().x);
            return xCompare != 0 ? xCompare : Double.compare(sr.rect.br().y + sr.rect.tl().y, this.rect.br().y + this.rect.tl().y);
        }
    }

    public static class RectSpan {
        private List<SuperRect> rects = new ArrayList<SuperRect>();
        private Rect rect;

        public void add(SuperRect rect) {
            this.rects.add(rect);
        }

        public List<SuperRect> getRects() {
            return this.rects;
        }

        public Rect getRect() {
            return this.rect != null ? this.rect : (this.rect = this.buildRect());
        }

        private Rect buildRect() {
            double[] tops = this.getRects().stream().mapToDouble(rect -> ((SuperRect)rect).rect.tl().y).toArray();
            double topYAverage = DoubleStream.of(tops).average().getAsDouble();
            double topYVariance = 0.0;
            for (double top : tops) {
                topYVariance += (top - topYAverage) * (top - topYAverage);
            }
            topYVariance /= (double)(this.getRects().size() - 1);
            double[] bottoms = this.getRects().stream().mapToDouble(rect -> ((SuperRect)rect).rect.br().y).toArray();
            double bottomYAverage = DoubleStream.of(bottoms).average().getAsDouble();
            double bottomYVariance = 0.0;
            for (double bottom : bottoms) {
                bottomYVariance += (bottom - bottomYAverage) * (bottom - bottomYAverage);
            }
            double yMin = topYAverage - Math.sqrt(topYVariance);
            double yMax = bottomYAverage + Math.sqrt(bottomYVariance /= (double)(this.getRects().size() - 1));
            double xMin = ((SuperRect)this.getRects().get((int)0)).rect.tl().x;
            double xMax = ((SuperRect)this.getRects().get((int)(this.getRects().size() - 1))).rect.br().x;
            return new Rect(new Point(xMin, yMin), new Point(xMax, yMax));
        }
    }

    private static class ConnectedRects
    implements Comparable<ConnectedRects> {
        private final SuperRect rect1;
        private final SuperRect rect2;
        private Double distance;
        private final double coeff = 4.0;

        public ConnectedRects(SuperRect rect1, SuperRect rect2) {
            this.rect1 = rect1;
            this.rect2 = rect2;
        }

        public SuperRect getRect1() {
            return this.rect1;
        }

        public SuperRect getRect2() {
            return this.rect2;
        }

        @Override
        public int compareTo(ConnectedRects link) {
            return Double.compare(this.distance(), link.distance());
        }

        private double distance() {
            return this.distance != null ? this.distance : this.buildDistance();
        }

        private Double buildDistance() {
            double dx = ((SuperRect)this.rect2).rect.tl().x - ((SuperRect)this.rect1).rect.br().x;
            dx = dx >= 0.0 ? dx : 0.0;
            double dy = (((SuperRect)this.rect1).rect.tl().y + ((SuperRect)this.rect1).rect.br().y) / 2.0 - (((SuperRect)this.rect2).rect.tl().y + ((SuperRect)this.rect2).rect.br().y) / 2.0;
            return Math.sqrt(dx * dx + 4.0 * dy * dy);
        }
    }

    private static class QualityManager {
        int size;
        double coeff;
        double average = 0.0;

        public QualityManager(int size, double coeff) {
            this.size = size;
            this.coeff = coeff;
        }

        public boolean filter(Mat gray) {
            double quality = QualityManager.quality(gray);
            this.average = ((double)this.size * this.average + quality) / (double)(this.size + 1);
            System.out.println("Quality : " + quality + " average : " + this.average + " filtered : " + (quality < this.average * this.coeff));
            return quality >= this.average * this.coeff;
        }

        public static double quality(Mat gray) {
            Mat dest = new Mat();
            Imgproc.Laplacian((Mat)gray, (Mat)dest, (int)3);
            MatOfDouble median = new MatOfDouble();
            MatOfDouble std = new MatOfDouble();
            Core.meanStdDev((Mat)dest, (MatOfDouble)median, (MatOfDouble)std);
            return Math.pow(std.get(0, 0)[0], 2.0);
        }
    }
}

