/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.web;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;

public class Runner {
    private static final String UNIT_EXAMPLES_DIR = "unit-examples";
    private static final String UNIT_EXAMPLES_JAVA_DIR = "unit-examples/src/main/java/";

    public static void runClusteredExample(Class clazz) {
        Runner.runExample(UNIT_EXAMPLES_JAVA_DIR, clazz, new VertxOptions().setClustered(true), null);
    }

    public static void runExample(Class clazz) {
        Runner.runExample(UNIT_EXAMPLES_JAVA_DIR, clazz, new VertxOptions().setClustered(false), null);
    }

    public static void runExample(String exampleDir, Class clazz, VertxOptions options, DeploymentOptions deploymentOptions) {
        Runner.runExample(exampleDir + clazz.getPackage().getName().replace(".", "/"), clazz.getName(), options, deploymentOptions);
    }

    public static void runScriptExample(String prefix, String scriptName, VertxOptions options) {
        File file = new File(scriptName);
        String dirPart = file.getParent();
        String scriptDir = prefix + dirPart;
        Runner.runExample(scriptDir, scriptDir + "/" + file.getName(), options, null);
    }

    public static void runExample(String exampleDir, String verticleID, VertxOptions options, DeploymentOptions deploymentOptions) {
        if (options == null) {
            options = new VertxOptions();
        }
        try {
            File current = new File(".").getCanonicalFile();
            if (exampleDir.startsWith(current.getName()) && !exampleDir.equals(current.getName())) {
                exampleDir = exampleDir.substring(current.getName().length() + 1);
            }
        }
        catch (IOException current) {
            // empty catch block
        }
        System.setProperty("vertx.cwd", exampleDir);
        Consumer<Vertx> runner = vertx -> {
            try {
                if (deploymentOptions != null) {
                    vertx.deployVerticle(verticleID, deploymentOptions);
                } else {
                    vertx.deployVerticle(verticleID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        };
        if (options.isClustered()) {
            Vertx.clusteredVertx((VertxOptions)options, res -> {
                if (res.succeeded()) {
                    Vertx vertx = (Vertx)res.result();
                    runner.accept(vertx);
                } else {
                    res.cause().printStackTrace();
                }
            });
        } else {
            Vertx vertx2 = Vertx.vertx((VertxOptions)options);
            runner.accept(vertx2);
        }
    }
}

