/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.apache.commons.io.FilenameUtils;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.Line;
import org.genericsystem.cv.utils.Lines;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Ransac;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deskewer {
    private static final Logger logger;
    private static final double ransacError = 0.1;
    private static final double closedImgSizeFactor = 2.0E-6;
    private static final double minAreaFactor = 3.0E-5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path deskewAndSave(Path imgPath, METHOD method) {
        String ext = FilenameUtils.getExtension((String)imgPath.getFileName().toString());
        String filename = imgPath.toString().replace("." + ext, "") + "_deskewed." + ext;
        Path savedPath = imgPath.resolveSibling(filename);
        Img img = Deskewer.deskew(imgPath, METHOD.ROTADED_RECTANGLES);
        try {
            Object object = Deskewer.class;
            synchronized (Deskewer.class) {
                if (savedPath.toFile().exists()) {
                    String[] fileNameParts = savedPath.getFileName().toString().split("\\.(?=[^\\.]+$)");
                    savedPath = File.createTempFile(fileNameParts[0] + "-", "." + fileNameParts[1], imgPath.getParent().toFile()).toPath();
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                Imgcodecs.imwrite((String)savedPath.toString(), (Mat)img.getSrc());
                object = savedPath;
                return object;
            }
        }
        catch (IOException e) {
            logger.error("An error has occured while saving file " + savedPath.toString(), (Throwable)e);
            Path path = null;
            return path;
        }
        finally {
            if (null != img) {
                img.close();
            }
        }
    }

    public static Img deskew(Path imgPath, METHOD method) {
        if (!imgPath.toFile().exists()) {
            throw new IllegalStateException("No files were found at Path " + imgPath);
        }
        Img img = new Img(imgPath.toString());
        Img deskewed = Deskewer.deskew(img, method);
        img.close();
        return deskewed;
    }

    public static Img deskew(Img img, METHOD method) {
        Img closed = Deskewer.getClosedImg(img);
        Img rotated = Deskewer.deskew(img, closed, method);
        closed.close();
        return rotated;
    }

    public static Img deskew(Img img, Img closed, METHOD method) {
        double angle = Deskewer.detectAngle(closed.getSrc(), method);
        logger.trace("Deskew angle = {}", (Object)angle);
        if (Double.isNaN(angle)) {
            return img;
        }
        logger.info("Found deskew angle : {}", (Object)angle);
        Point center = new Point((double)(img.width() / 2), (double)(img.height() / 2));
        Mat rotationMatrix = Imgproc.getRotationMatrix2D((Point)center, (double)angle, (double)1.0);
        Rect bbox = new RotatedRect(center, img.size(), angle).boundingRect();
        double[] array = rotationMatrix.get(0, 2);
        array[0] = array[0] + ((double)(bbox.width / 2) - center.x);
        rotationMatrix.put(0, 2, array);
        array = rotationMatrix.get(1, 2);
        array[0] = array[0] + ((double)(bbox.height / 2) - center.y);
        rotationMatrix.put(1, 2, array);
        Mat rotated = new Mat(bbox.size(), CvType.CV_8UC3, Scalar.all((double)255.0));
        Mat rotatedMasked = new Mat();
        Mat mask = new Mat(img.size(), CvType.CV_8UC1, new Scalar(255.0));
        Mat warpedMask = new Mat();
        Imgproc.warpAffine((Mat)mask, (Mat)warpedMask, (Mat)rotationMatrix, (Size)bbox.size());
        Imgproc.warpAffine((Mat)img.getSrc(), (Mat)rotatedMasked, (Mat)rotationMatrix, (Size)bbox.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
        rotatedMasked.copyTo(rotated, warpedMask);
        rotatedMasked.release();
        mask.release();
        warpedMask.release();
        rotationMatrix.release();
        return new Img(rotated, false);
    }

    public static Img getBinary(Img img) {
        return Deskewer.getClosedImg(img);
    }

    public static Img getRotatedRectanglesDrawn(Img img, Scalar scalar, int thickness) {
        Img imgCopy = new Img(img.getSrc(), true);
        Img closed = Deskewer.getClosedImg(imgCopy);
        List<RotatedRect> rectangles = Deskewer.getRotatedRects(closed.getSrc());
        rectangles.stream().forEach(rect -> Deskewer.drawSingleRotatedRectangle(imgCopy.getSrc(), rect, scalar, thickness));
        List<RotatedRect> filteredRectangles = Deskewer.getRansacInliersRects(rectangles, 0.1);
        filteredRectangles.stream().forEach(rect -> Deskewer.drawSingleRotatedRectangle(imgCopy.getSrc(), rect, new Scalar(0.0, 255.0, 0.0), thickness));
        closed.close();
        return imgCopy;
    }

    public static Img getLinesDrawn(Img img, Scalar scalar, int thickness) {
        Img imgCopy = new Img(img.getSrc(), true);
        Img closed = Deskewer.getClosedImg(imgCopy);
        Lines lines = Deskewer.getLines(closed.getSrc());
        lines.stream().forEach(line -> Deskewer.drawSingleLine(imgCopy.getSrc(), line, scalar, thickness));
        Lines filteredLines = Deskewer.getRansacInliersLines(lines, 0.1);
        filteredLines.stream().forEach(line -> Deskewer.drawSingleLine(imgCopy.getSrc(), line, new Scalar(0.0, 255.0, 0.0), thickness));
        closed.close();
        return imgCopy;
    }

    public static double detectAngle(Mat dilated, METHOD method) {
        switch (method) {
            case HOUGH_LINES: {
                Lines lines = Deskewer.getLines(dilated);
                return Deskewer.getRansacInliersLines(lines, 0.1).getMeanInDegree();
            }
        }
        List<RotatedRect> rotatedRects = Deskewer.getRotatedRects(dilated);
        for (RotatedRect rotatedRect : rotatedRects) {
            if (!(rotatedRect.angle <= -45.0)) continue;
            rotatedRect.angle += 90.0;
            double tmp = rotatedRect.size.width;
            rotatedRect.size.width = rotatedRect.size.height;
            rotatedRect.size.height = tmp;
        }
        return Deskewer.getRansacInliersRects(rotatedRects, 0.1).stream().mapToDouble(i -> i.angle).average().orElse(rotatedRects.stream().mapToDouble(r -> r.angle).average().getAsDouble());
    }

    private static void drawSingleRotatedRectangle(Mat mat, RotatedRect rect, Scalar scalar, int thickness) {
        Point[] points = new Point[4];
        rect.points(points);
        for (int i = 0; i < 4; ++i) {
            Imgproc.line((Mat)mat, (Point)points[i], (Point)points[(i + 1) % 4], (Scalar)scalar, (int)thickness);
        }
    }

    private static void drawSingleLine(Mat mat, Line line, Scalar scalar, int thickness) {
        line.draw(mat, scalar, thickness);
    }

    private static Img getClosedImg(Img img) {
        double size = 2.0E-6 * img.size().area();
        size = 2.0 * Math.floor(size / 2.0) + 1.0;
        return img.bilateralFilter(20, 80.0, 80.0).bgr2Gray().grad(2.0, 2.0).thresHold(0.0, 255.0, 9).bitwise_not().morphologyEx(3, 2, new Size(size, size));
    }

    private static List<RotatedRect> getInliers(List<RotatedRect> data, double confidence) {
        if (null == data) {
            return null;
        }
        double average = data.stream().mapToDouble(rect -> rect.angle).average().getAsDouble();
        double sd = Math.sqrt(data.stream().mapToDouble(rect -> Math.pow(rect.angle - average, 2.0)).average().getAsDouble());
        Collections.sort(data, (r1, r2) -> Double.compare(r1.angle, r2.angle));
        int middle = data.size() / 2;
        double median = middle % 2 == 1 ? data.get((int)middle).angle : DoubleStream.of(data.get((int)middle).angle, data.get((int)(middle - 1)).angle).average().getAsDouble();
        return data.stream().filter(rect -> Math.abs(rect.angle - median) < confidence * sd).collect(Collectors.toList());
    }

    private static List<RotatedRect> getRansacInliersRects(List<RotatedRect> data, double error) {
        int n = 3;
        int k = 50;
        double t = error;
        int d = data.size() * 2 / 3;
        if (d < n) {
            if (d >= n - 1) {
                n = 2;
            } else {
                return data;
            }
        }
        Map<Object, Object> bestFit = new HashMap();
        int maxAttempts = 10;
        for (int i = 1; bestFit.size() <= 3 && i <= maxAttempts; ++i) {
            try {
                Ransac<RotatedRect> ransac = new Ransac<RotatedRect>(data, Deskewer.getModelProviderRects(), n, k * i, t, d);
                bestFit = ransac.getBestDataSet();
                continue;
            }
            catch (Exception e) {
                logger.trace("Can't get a good model. Increase the error margin to {}", (Object)(t *= 1.5));
            }
        }
        return bestFit.values().stream().collect(Collectors.toList());
    }

    private static Lines getRansacInliersLines(Lines data, double error) {
        int n = 3;
        int k = 50;
        double t = error;
        int d = data.size() * 2 / 3;
        if (d < n) {
            if (d >= n - 1) {
                n = 2;
            } else {
                return data;
            }
        }
        Map<Object, Object> bestFit = new HashMap();
        int maxAttempts = 10;
        for (int i = 1; bestFit.size() <= 3 && i <= maxAttempts; ++i) {
            try {
                Ransac<Line> ransac = new Ransac<Line>(data.getLines(), Deskewer.getModelProviderLines(), n, k * i, t, d);
                bestFit = ransac.getBestDataSet();
                continue;
            }
            catch (Exception e) {
                logger.trace("Can't get a good model. Increase the error margin to {}", (Object)(t *= 1.5));
            }
        }
        return new Lines(bestFit.values().stream().collect(Collectors.toList()));
    }

    private static Function<Collection<RotatedRect>, Ransac.Model<RotatedRect>> getModelProviderRects() {
        return datas -> {
            final double average = datas.stream().mapToDouble(rect -> rect.angle).average().getAsDouble();
            return new Ransac.Model<RotatedRect>(){

                @Override
                public double computeError(RotatedRect data) {
                    return Math.abs(data.angle - average);
                }

                @Override
                public double computeGlobalError(List<RotatedRect> datas, Collection<RotatedRect> consensusDatas) {
                    double error = 0.0;
                    for (RotatedRect rect : consensusDatas) {
                        error += Math.pow(this.computeError(rect), 2.0);
                    }
                    return Math.sqrt(error) / (double)consensusDatas.size();
                }

                @Override
                public Object[] getParams() {
                    return new Object[]{average};
                }
            };
        };
    }

    private static Function<Collection<Line>, Ransac.Model<Line>> getModelProviderLines() {
        return datas -> {
            final double average = datas.stream().mapToDouble(line -> line.getAngle()).average().getAsDouble();
            return new Ransac.Model<Line>(){

                @Override
                public double computeError(Line data) {
                    return Math.abs(data.getAngle() - average);
                }

                @Override
                public double computeGlobalError(List<Line> datas, Collection<Line> consensusDatas) {
                    double error = 0.0;
                    for (Line line : consensusDatas) {
                        error += Math.pow(this.computeError(line), 2.0);
                    }
                    return Math.sqrt(error) / (double)consensusDatas.size();
                }

                @Override
                public Object[] getParams() {
                    return new Object[]{average};
                }
            };
        };
    }

    private static List<RotatedRect> getRotatedRects(Mat dilated) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)dilated, contours, (Mat)new Mat(), (int)1, (int)2);
        double minArea = 3.0E-5 * dilated.size().area();
        List<RotatedRect> rotatedRects = contours.stream().filter(contour -> Imgproc.contourArea((Mat)contour) > minArea).map(contour -> Imgproc.minAreaRect((MatOfPoint2f)new MatOfPoint2f(contour.toArray()))).collect(Collectors.toList());
        return rotatedRects;
    }

    private static Lines getLines(Mat dilated) {
        Img binary = new Img(dilated);
        Lines lines = new Lines(binary.houghLinesP(1, Math.PI / 180, 100, 100.0, 10.0));
        binary.close();
        return lines;
    }

    static {
        NativeLibraryLoader.load();
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    public static enum METHOD {
        ROTADED_RECTANGLES,
        HOUGH_LINES;

    }
}

