/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassifierUsingFields {
    private static final Logger logger;
    private static final double closedImgSizeFactor = 1.2E-6;
    private static final double minAreaFactor = 3.0E-5;

    public static Path classify(Path imgPath) {
        Path classifiedImgPath = null;
        return classifiedImgPath;
    }

    public static Img getFieldsDrawn(Img img, Scalar scalar, int thickness) {
        Img imgCopy = new Img(img.getSrc(), true);
        List<Rect> rectangles = ClassifierUsingFields.detectRects(imgCopy);
        rectangles.forEach(rect -> ClassifierUsingFields.drawSingleRectangle(imgCopy.getSrc(), rect, scalar, thickness));
        return imgCopy;
    }

    public static Img getBinary(Img img) {
        return ClassifierUsingFields.getClosedImage(img);
    }

    public static List<Rect> detectRects(Img img) {
        Img closed = ClassifierUsingFields.getClosedImage(img);
        List<MatOfPoint> contours = ClassifierUsingFields.getContours(closed);
        double minArea = 3.0E-5 * img.size().area();
        List<Rect> res = contours.stream().filter(contour -> Imgproc.contourArea((Mat)contour) > minArea).map(Imgproc::boundingRect).filter(rect -> rect.height > 3 && rect.width > 3).collect(Collectors.toList());
        contours.forEach(Mat::release);
        return res;
    }

    private static void drawSingleRectangle(Mat mat, Rect rect, Scalar scalar, int thickness) {
        Imgproc.rectangle((Mat)mat, (Point)rect.tl(), (Point)rect.br(), (Scalar)scalar, (int)thickness);
    }

    private static Img getClosedImage(Img img) {
        double size = 1.2E-6 * img.size().area();
        size = 2.0 * Math.floor(size / 2.0) + 1.0;
        return img.bilateralFilter(10, 80.0, 80.0).bgr2Gray().grad(2.0, 2.0).thresHold(0.0, 255.0, 9).bitwise_not().morphologyEx(3, 2, new Size(size, size / 5.0 + 1.0));
    }

    private static List<MatOfPoint> getContours(Img closed) {
        ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
        Imgproc.findContours((Mat)closed.getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        return contours;
    }

    static {
        NativeLibraryLoader.load();
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

