/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.textdetection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.textdetection.RobustTextDetectorManager;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class RobustTextDetectorDemo
extends AbstractApp {
    private final GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        RobustTextDetectorDemo.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.0;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    Mat convertContourToMat(MatOfPoint contour) {
        Point[] pts = contour.toArray();
        Mat result = new Mat(pts.length, 2, CvType.CV_64FC1);
        for (int i = 0; i < result.rows(); ++i) {
            result.put(i, 0, new double[]{pts[i].x});
            result.put(i, 1, new double[]{pts[i].y});
        }
        return result;
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
        }
        Image[] images = new Image[12];
        long ref = System.currentTimeMillis();
        long ref2 = System.currentTimeMillis();
        Img gray = this.frame.bgr2Gray();
        RobustTextDetectorManager manager = new RobustTextDetectorManager(gray.getSrc(), 2);
        images[0] = new Img(manager.getMserMask(), false).toJfxImage();
        ref = this.trace("mser mask", ref);
        images[1] = new Img(manager.getCannyMask(), false).toJfxImage();
        ref = this.trace("canny", ref);
        images[2] = new Img(manager.getMserAndCannyMask(), false).toJfxImage();
        ref = this.trace("mserAndCanny", ref);
        images[3] = new Img(manager.getMserAndCannyGrownMask(), false).toJfxImage();
        ref = this.trace("grow", ref);
        images[4] = new Img(manager.getEdgeEnhancedMserMask(), false).toJfxImage();
        ref = this.trace("edgeEnhancedMser", ref);
        images[5] = new Img(manager.getEdgeEnhanceMserCCMask(), false).toJfxImage();
        ref = this.trace("cc", ref);
        images[6] = new Img(manager.getFilteredStrokeWidthMask(), false).toJfxImage();
        ref = this.trace("swt", ref);
        Mat bounding_region = new Mat();
        Imgproc.morphologyEx((Mat)manager.getFilteredStrokeWidthMask(), (Mat)bounding_region, (int)3, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(9.0, 5.0)));
        Imgproc.morphologyEx((Mat)bounding_region, (Mat)bounding_region, (int)2, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(3.0, 3.0)));
        images[7] = new Img(bounding_region, false).toJfxImage();
        Imgproc.morphologyEx((Mat)manager.getFilteredStrokeWidthMask(), (Mat)bounding_region, (int)3, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(27.0, 5.0)));
        Imgproc.morphologyEx((Mat)bounding_region, (Mat)bounding_region, (int)2, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(3.0, 3.0)));
        images[8] = new Img(bounding_region, false).toJfxImage();
        ref = this.trace("morphologies", ref);
        Mat thresholdMask = new Mat();
        Imgproc.adaptiveThreshold((Mat)gray.getSrc(), (Mat)thresholdMask, (double)255.0, (int)1, (int)1, (int)7, (double)3.0);
        Mat result = Mat.zeros((Size)this.frame.size(), (int)CvType.CV_8UC1);
        thresholdMask.copyTo(result, bounding_region);
        images[9] = new Img(result, false).toJfxImage();
        ref = this.trace("masked threshold", ref);
        ref2 = this.trace("total", ref2);
        return images;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

